/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.ui;

import com.day.crx.explorer.impl.j2ee.CRXContext;
import com.day.crx.explorer.impl.ui.NodeTree;
import com.day.crx.explorer.impl.ui.NodeTreeHTMLProvider;
import com.day.crx.explorer.impl.util.RequestData;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import org.apache.jackrabbit.util.Text;

public class NodeTreeServlet
extends HttpServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JspFactory factory = JspFactory.getDefaultFactory();
        PageContext pageContext = factory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, false, 8192, true);
        try {
            response.setContentType("text/html; charset=utf-8");
            CRXContext ctx = CRXContext.getInstance(this.getServletContext(), request);
            RequestData req = ctx.getRequestData();
            Session repSession = ctx.getSession();
            if (repSession == null) {
                return;
            }
            String path = req.getParameter("Path", "/");
            String openNode = req.getParameter("OpenNode", "/");
            String selectedNode = req.getParameter("SelectedNode", "");
            String nodeOnly = req.getParameter("NodeOnly");
            String treeName = req.getParameter("TreeName");
            String providerClass = req.getParameter("Provider");
            if (path.equals("")) {
                path = "/";
            }
            Node node = (Node)repSession.getItem(path);
            NodeTreeHTMLProvider provider = NodeTree.getProvider(providerClass);
            if (nodeOnly != null) {
                provider.drawNode(pageContext, treeName, node, openNode, selectedNode);
            } else {
                provider.drawLevel(pageContext, treeName, node, openNode, selectedNode);
            }
            pageContext.getOut().flush();
        }
        catch (Exception e) {
            response.getWriter().println("Unable to write HTML: " + Text.encodeIllegalXMLCharacters((String)e.toString()));
        }
        finally {
            factory.releasePageContext(pageContext);
        }
    }
}

