/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.ui;

import com.day.crx.explorer.impl.ui.NodeTypeTreeHTMLProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.servlet.jsp.PageContext;

public class NodeTypeTree {
    private HashMap items = new HashMap();
    public static final int FILTER_ALL = 3;
    public static final int FILTER_MIXIN = 1;
    public static final int FILTER_PRIMARY = 2;
    private int filter = 3;
    private String docroot;
    private Session session;
    private boolean flat;
    private ArrayList required = new ArrayList();
    private ArrayList fakeTypes = new ArrayList();

    public String getDocroot() {
        return this.docroot;
    }

    public void addRequiredTypes(NodeType[] types) {
        this.required.add(types);
    }

    public void setFilter(int filter) {
        this.filter = filter;
    }

    public void setDocroot(String docroot) {
        this.docroot = docroot;
    }

    public NodeTypeTree(Session session) {
        this.session = session;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void setFlat(boolean flat) {
        this.flat = flat;
    }

    public void draw(PageContext out, NodeTypeTreeHTMLProvider provider) throws IOException, RepositoryException {
        provider.drawLevel(out, this.compile(), 0);
    }

    public void addFakeType(String name) {
        this.fakeTypes.add(name);
    }

    private boolean isAllowed(NodeType nt) {
        int type = nt.isMixin() ? 1 : 2;
        return (type & this.filter) != 0;
    }

    private Item compile() throws RepositoryException {
        this.items.clear();
        Item root = new Item();
        NodeTypeIterator iter = this.session.getWorkspace().getNodeTypeManager().getAllNodeTypes();
        while (iter.hasNext()) {
            this.update(root, iter.nextNodeType());
        }
        if (!this.flat && this.required.size() > 0) {
            root = new Item();
            for (int i = 0; i < this.required.size(); ++i) {
                NodeType[] req = (NodeType[])this.required.get(i);
                if (req.length == 0) continue;
                Item base = new Item();
                for (Item next : this.items.values()) {
                    for (int j = 0; j < req.length; ++j) {
                        Item reqi = (Item)this.items.get(req[j].getName());
                        if (next.isDescendant(reqi)) continue;
                        next = null;
                        break;
                    }
                    if (next == null) continue;
                    base.merge(next);
                }
                if (!base.getChildren().hasNext()) {
                    throw new RepositoryException("Incompatible required types. No common Node Types found.");
                }
                Iterator all = base.getChildren();
                while (all.hasNext()) {
                    root.merge((Item)all.next());
                }
            }
        }
        if (this.filter != 3) {
            root.removeFiltered();
        }
        Iterator it = this.fakeTypes.iterator();
        while (it.hasNext()) {
            root.add(new Item((String)it.next()));
        }
        return root;
    }

    private Item update(Item root, NodeType nt) {
        if (this.required.size() == 0 && !this.isAllowed(nt)) {
            return null;
        }
        Item item = (Item)this.items.get(nt.getName());
        if (item == null) {
            item = new Item(nt);
            this.items.put(nt.getName(), item);
            NodeType[] superTypes = nt.getDeclaredSupertypes();
            if (superTypes.length > 0 && !this.flat) {
                for (int i = 0; i < superTypes.length; ++i) {
                    Item superItem = this.update(root, superTypes[i]);
                    if (superItem == null) continue;
                    superItem.add(item);
                }
            } else {
                root.add(item);
            }
        }
        return item;
    }

    public class Item {
        private final NodeType nodeType;
        private final String ntName;
        private TreeMap children = new TreeMap();

        public Item() {
            this.nodeType = null;
            this.ntName = null;
        }

        public Item(NodeType nt) {
            this.nodeType = nt;
            this.ntName = nt == null ? "" : nt.getName();
        }

        public Item(String ntName) {
            this.nodeType = null;
            this.ntName = ntName;
        }

        public NodeTypeTree getTree() {
            return NodeTypeTree.this;
        }

        public Iterator getChildren() {
            return this.children.values().iterator();
        }

        public String getName() {
            return this.ntName;
        }

        public boolean isMixin() {
            return this.nodeType == null ? false : this.nodeType.isMixin();
        }

        protected void add(Item item) {
            this.children.put(item.getName(), item);
        }

        protected void removeFiltered() {
            TreeMap<String, Item> newChildren = new TreeMap<String, Item>();
            for (Item child : this.children.values()) {
                child.removeFiltered();
                if (NodeTypeTree.this.isAllowed(child.nodeType)) {
                    newChildren.put(child.getName(), child);
                    continue;
                }
                newChildren.putAll(child.children);
            }
            this.children = newChildren;
        }

        protected void merge(Item item) {
            for (Item child : this.children.values()) {
                if (!item.isDescendant(child)) continue;
                return;
            }
            TreeMap<String, Item> newChildren = new TreeMap<String, Item>();
            for (Item child : this.children.values()) {
                if (child.isDescendant(item)) continue;
                newChildren.put(child.getName(), child);
            }
            newChildren.put(item.getName(), item);
            this.children = newChildren;
        }

        protected boolean isDescendant(Item other) {
            if (other.getName().equals(this.getName()) || other.children.containsKey(this.getName())) {
                return true;
            }
            Iterator iter = other.getChildren();
            while (iter.hasNext()) {
                Item child = (Item)iter.next();
                if (!this.isDescendant(child)) continue;
                return true;
            }
            return false;
        }
    }
}

