/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.ui;

import com.day.crx.explorer.impl.j2ee.JCRExplorerServlet;
import com.day.crx.explorer.impl.ui.NodeTypeTree;
import com.day.crx.i18n.Dictionary;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringEscapeUtils;

public class NodeTypeView {
    public static final String[] ON_VERSION_ACTIONS = new String[]{"COPY", "VERSION", "INITIALIZE", "COMPUTE", "IGNORE", "ABORT"};
    public static final String PARAM_NODETYPE = "nodetype";
    public static final Comparator<ItemDefinition> ITEM_DEFINITION_COMPARATOR = new Comparator<ItemDefinition>(){

        @Override
        public int compare(ItemDefinition o1, ItemDefinition o2) {
            String n2;
            String n1 = o1.getName() == null ? "*" : o1.getName();
            String string = n2 = o2.getName() == null ? "*" : o2.getName();
            if (n1.equals(n2)) {
                return o1.equals(o2) ? 0 : -1;
            }
            return n1.compareTo(n2);
        }
    };
    private final String docroot;
    private final Dictionary dict = Dictionary.getCurrent();
    private PageContext context;
    private String ntLinkHref;
    private String ntLinkParam = "nodetype";
    private final Session session;
    private NodeTypeTree nodeTypeTree;

    public NodeTypeView(Session session, String docroot, PageContext context) {
        this.session = session;
        this.docroot = docroot;
        this.context = context;
    }

    public NodeTypeTree getNodeTypeTree() {
        if (this.nodeTypeTree == null) {
            this.nodeTypeTree = new NodeTypeTree(this.session);
        }
        return this.nodeTypeTree;
    }

    public PageContext getPageContext() {
        return this.context;
    }

    public void setNtLinkHref(String ntLinkHref) {
        this.ntLinkHref = ntLinkHref;
    }

    public void setNtLinkParam(String ntLinkParam) {
        this.ntLinkParam = ntLinkParam;
    }

    public void drawNodeType(NodeType nt) throws IOException {
        if (nt != null) {
            this.drawNodeType(nt.getName());
        }
    }

    public String getDocroot() {
        return this.docroot;
    }

    public void drawNodeType(String nt) throws IOException {
        if (nt != null) {
            JspWriter out = this.getOut();
            if (this.ntLinkHref != null) {
                out.print("<a href=\"" + this.ntLinkHref + "?" + this.ntLinkParam + "=" + StringEscapeUtils.escapeHtml4((String)nt) + "\">");
            }
            NodeTypeView.printNodeType(this.getOut(), this.docroot, nt);
            if (this.ntLinkHref != null) {
                out.print("</a>");
            }
        }
    }

    public static void printNodeType(JspWriter out, String docroot, String ntName) throws IOException {
        out.print("<img border=\"0\" align=\"middle\" src=\"" + docroot + JCRExplorerServlet.getNTIcon(ntName) + "\">&nbsp;" + StringEscapeUtils.escapeHtml4((String)ntName));
    }

    public void drawNodeTypes(NodeType[] nts, NodeType[] declared) throws IOException {
        HashSet<String> decl = new HashSet<String>();
        if (declared != null) {
            for (NodeType aDeclared : declared) {
                decl.add(aDeclared.getName());
            }
        }
        JspWriter out = this.getOut();
        for (NodeType nt : nts) {
            if (declared == null || decl.contains(nt.getName())) {
                this.drawNodeType(nt);
                out.print("<br>");
                continue;
            }
            out.print("<font color=\"#888888\">");
            this.drawNodeType(nt);
            out.print("</font><br>");
        }
    }

    public void drawNodeTypes(String[] nts, String[] declared) throws IOException {
        HashSet<String> decl = new HashSet<String>();
        if (declared != null) {
            decl.addAll(Arrays.asList(declared));
        }
        JspWriter out = this.getOut();
        for (String nt : nts) {
            if (declared == null || decl.contains(nt)) {
                this.drawNodeType(nt);
                out.print("<br>");
                continue;
            }
            out.print("<font color=\"#888888\">");
            this.drawNodeType(nt);
            out.print("</font><br>");
        }
    }

    public void drawPropertyType(int pt) throws IOException {
        this.getOut().print("<img border=\"0\" align=\"middle\" src=\"" + this.docroot + JCRExplorerServlet.getPTIcon(pt) + "\">&nbsp;" + PropertyType.nameFromValue((int)pt).toUpperCase());
    }

    public void drawPropertyType(String pt) throws IOException {
        this.getOut().print("<img border=\"0\" align=\"middle\" src=\"" + this.docroot + JCRExplorerServlet.getPTIcon(pt) + "\">&nbsp;" + pt);
    }

    public void drawBegin() throws IOException {
        this.getOut().print("<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" width=\"100%\">");
    }

    public void drawEnd() throws IOException {
        this.getOut().print("</table>");
    }

    public JspWriter getOut() {
        return this.context.getOut();
    }

    public void drawGeneralProperties(NodeType nt) throws IOException {
        NodeType[] inherited;
        NodeType[] declaredSupertypes;
        JspWriter out = this.getOut();
        out.print("<tr><th class=\"listTitle\" colspan=\"1\">");
        out.print(this.dict.msg("crex.node_type_attributes.txt"));
        out.print("</th></tr>");
        out.print("<tr><th class=\"firstCol\">");
        out.print(this.dict.msg("crex.name.lab"));
        out.print("</th><th colspan=\"10\">Value</th></tr>");
        out.print("<tr><td class=\"firstCol\">");
        out.print(this.dict.msg("crex.node_type_name.txt"));
        out.print("</td><td class=\"lastCol\" colspan=\"10\">");
        out.print(StringEscapeUtils.escapeHtml4((String)nt.getName()));
        out.print("</td></tr>");
        out.print("<tr class=\"zebra\"><td class=\"firstCol\">");
        out.print(this.dict.msg("crex.mixin_node_type.txt"));
        out.print("</td><td class=\"lastCol\" colspan=\"10\">");
        out.print(nt.isMixin());
        out.print("</td></tr>");
        out.print("<tr><td class=\"firstCol\">");
        out.print(this.dict.msg("crex.orderable_child_nodes.txt.0"));
        out.print("</td><td class=\"lastCol\" colspan=\"10\">");
        out.print(nt.hasOrderableChildNodes());
        out.print("</td></tr>");
        out.print("<tr class=\"zebra\"><td class=\"firstCol\">");
        out.print(this.dict.msg("crex.primary_item_name.txt"));
        out.print("</td><td class=\"lastCol\" colspan=\"10\">");
        out.print(StringEscapeUtils.escapeHtml4((String)nt.getPrimaryItemName()));
        out.print("</td></tr>");
        out.print("<tr><td class=\"firstCol\">");
        out.print(this.dict.msg("crex.supertypes.lab"));
        out.print("</td><td class=\"lastCol\" colspan=\"10\">");
        HashSet<String> declared = new HashSet<String>();
        for (NodeType declaredSupertype : declaredSupertypes = nt.getDeclaredSupertypes()) {
            String sName = declaredSupertype.getName();
            declared.add(sName);
            this.drawNodeType(sName);
            out.print("<br>");
        }
        for (NodeType anInherited : inherited = nt.getSupertypes()) {
            String sName = anInherited.getName();
            if (declared.contains(sName)) continue;
            this.drawNodeType(sName);
            out.print("<br>");
        }
        out.print("</td></tr>");
        out.print("<tr><td class=\"listFooter\" colspan=\"11\">&nbsp;</td></tr>");
    }

    public static boolean canEdit(ServletContext ctx) {
        return true;
    }

    public static NodeDefinition[] getAgregatedNodeDefs(Node node) throws RepositoryException {
        NodeType[] mixins;
        TreeSet<ItemDefinition> cDefs = new TreeSet<ItemDefinition>(ITEM_DEFINITION_COMPARATOR);
        NodeDefinition[] nd = node.getPrimaryNodeType().getChildNodeDefinitions();
        cDefs.addAll(Arrays.asList(nd));
        for (NodeType mixin : mixins = node.getMixinNodeTypes()) {
            nd = mixin.getChildNodeDefinitions();
            cDefs.addAll(Arrays.asList(nd));
        }
        return cDefs.toArray(new NodeDefinition[cDefs.size()]);
    }

    public static PropertyDefinition[] getAgregatedPropertyDefs(Node node) throws RepositoryException {
        NodeType[] mixins;
        TreeSet<ItemDefinition> pDefs = new TreeSet<ItemDefinition>(ITEM_DEFINITION_COMPARATOR);
        PropertyDefinition[] pd = node.getPrimaryNodeType().getPropertyDefinitions();
        pDefs.addAll(Arrays.asList(pd));
        for (NodeType mixin : mixins = node.getMixinNodeTypes()) {
            pd = mixin.getPropertyDefinitions();
            pDefs.addAll(Arrays.asList(pd));
        }
        return pDefs.toArray(new PropertyDefinition[pDefs.size()]);
    }
}

