/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.ui;

import com.day.crx.explorer.impl.ui.MVControl;
import com.day.crx.explorer.impl.ui.NodeTypeView;
import com.day.crx.explorer.impl.util.Values;
import com.day.crx.i18n.Dictionary;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.jackrabbit.commons.JcrUtils;

public class PropertyDefView {
    public static final String[] PROPERTY_TYPES = JcrUtils.getPropertyTypeNames((boolean)true);
    private final NodeTypeView parent;
    private final Dictionary dict = Dictionary.getCurrent();

    public PropertyDefView(NodeTypeView parent) {
        this.parent = parent;
    }

    public void drawTableHeader() throws IOException {
        this.drawTableHeader(this.dict.msg("crex.property_definitions.tit"), "");
    }

    public void drawTableHeader(String title) throws IOException {
        this.drawTableHeader(title, "");
    }

    public void drawTableHeader(String title, String description) throws IOException {
        JspWriter out = this.parent.getOut();
        out.print("<tr><th title=\"" + description + "\" class=\"listTitle\" colspan=\"1\">" + StringEscapeUtils.escapeHtml4((String)title) + "</th></tr>\n" + "<tr><th class=\"firstCol\" title=\"" + this.dict.msg("crex.property_definition_name.txt") + "\">" + this.dict.msg("crex.name.lab") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.required_type.tit") + "\">" + this.dict.msg("crex.req_type.tit") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.default_value.tit") + "\">" + this.dict.msg("crex.default.lab") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.value_contraints.tit") + "\">" + this.dict.msg("crex.constraint.lab") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.onparentversion.lab") + "\">" + this.dict.msg("crex.opv.lab") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.autocreate.lab") + "\">" + this.dict.msg("crex.ac.lab") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.mandatory.lab") + "\">" + this.dict.msg("crex.man.lab") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.protected.lab") + "\">" + this.dict.msg("crex.prot.lab") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.multivalued.lab") + "\">" + this.dict.msg("crex.mul.lab") + "</th>\n" + "<th title=\"" + this.dict.msg("crex.declaring_nodetype.tit") + "\" >" + this.dict.msg("crex.decl_node_type.txt") + "</th>\n" + "</tr>");
    }

    public void drawPropertyDef(NodeType nt, PropertyDefinition pd, int count) throws IOException, RepositoryException {
        JspWriter out = this.parent.getOut();
        String name = pd.getName() == null ? "*" : pd.getName();
        String ntName = nt == null ? "" : nt.getName();
        String piName = nt == null ? "" : nt.getPrimaryItemName();
        String declNodeTypeName = pd.getDeclaringNodeType() == null ? null : pd.getDeclaringNodeType().getName();
        String style = "";
        if (!ntName.equals(declNodeTypeName)) {
            style = style + "color:#888888;";
        }
        if (name.equals(piName)) {
            style = style + "font-weight:bold;";
        }
        if (style.length() > 0) {
            style = " style=\"" + style + "\"";
        }
        Value[] defValues = pd.getDefaultValues();
        String defVal = "";
        if (defValues != null) {
            for (int j = 0; j < defValues.length; ++j) {
                defVal = defVal + (j > 0 ? "<br>" : "") + defValues[j].getString();
            }
        }
        if (count % 2 == 0) {
            out.print("<tr class=\"zebra\">");
        } else {
            out.print("<tr>");
        }
        out.print("<td class=\"firstCol\"" + style + ">");
        out.print(StringEscapeUtils.escapeHtml4((String)name));
        out.print("</td>");
        out.print("<td" + style + ">");
        this.parent.drawPropertyType(pd.getRequiredType());
        out.print("</td>");
        out.print("<td" + style + ">");
        out.print(defVal);
        out.print("</td>");
        out.print("<td" + style + ">");
        this.printValues(out, pd.getValueConstraints());
        out.print("</td>");
        out.print("<td" + style + ">");
        out.print(OnParentVersionAction.nameFromValue((int)pd.getOnParentVersion()));
        out.print("</td>");
        out.print("<td" + style + ">");
        out.print(pd.isAutoCreated() ? "X" : "-");
        out.print("</td>");
        out.print("<td" + style + ">");
        out.print(pd.isMandatory() ? "X" : "-");
        out.print("</td>");
        out.print("<td" + style + ">");
        out.print(pd.isProtected() ? "X" : "-");
        out.print("</td>");
        out.print("<td" + style + ">");
        out.print(pd.isMultiple() ? "X" : "-");
        out.print("</td>");
        out.print("<td class=\"lastCol\"" + style + ">");
        this.parent.drawNodeType(pd.getDeclaringNodeType());
        out.print("</td>");
        out.print("</tr>");
    }

    public void drawPropertyDef(Node node, String declaringNodeTypeName, int count) throws IOException, RepositoryException {
        MVControl mv;
        JspWriter out = this.parent.getOut();
        boolean edit = declaringNodeTypeName == null;
        String path = node == null ? "" : node.getPath();
        String style = "";
        String action = edit ? "" : " onClick=\"javascript:doAction('edit', '" + StringEscapeUtils.escapeHtml4((String)node.getPath()) + "')\"";
        boolean isAutoCreate = Values.getProperty(node, "jcr:autoCreated", false);
        boolean isMandatory = Values.getProperty(node, "jcr:mandatory", false);
        String piName = node == null ? "" : Values.getProperty(node.getParent(), "jcr:primaryItemName", "");
        boolean isProtected = Values.getProperty(node, "jcr:protected", false);
        boolean isMultiple = Values.getProperty(node, "jcr:multiple", false);
        String name = Values.getProperty(node, "jcr:name", "*");
        if (!edit && name.equals(piName)) {
            style = style + "font-weight:bold;";
        }
        if (style.length() > 0) {
            style = " style=\"" + style + "\"";
        }
        if (count % 2 == 0) {
            out.print("<tr" + action + " class=\"zebra\">");
        } else {
            out.print("<tr" + action + ">");
        }
        out.print("<td class=\"firstCol\"" + style + ">");
        if (edit) {
            out.print("<input title=\"");
            out.print(this.dict.msg("crex.property_definition_name.txt"));
            out.print("\" type=\"text\" name=\"pd_name\" value=\"" + StringEscapeUtils.escapeHtml4((String)name) + "\">");
        } else {
            out.print(StringEscapeUtils.escapeHtml4((String)name));
        }
        out.print("</td>");
        String type = Values.getProperty(node, "jcr:requiredType", "");
        out.print("<td" + style + ">");
        if (edit) {
            out.print("<select title=\"");
            out.print(this.dict.msg("crex.required_type.tit"));
            out.print("\" name=\"pd_type\">");
            for (String propertyType : PROPERTY_TYPES) {
                String selected = propertyType.equalsIgnoreCase(type) ? " selected" : "";
                out.print("<option value=\"" + propertyType.toUpperCase() + "\"" + selected + ">" + propertyType.toUpperCase());
            }
            out.print("</select>");
        } else {
            this.parent.drawPropertyType(type);
        }
        out.print("</td>");
        out.print("<td" + style + ">");
        if (edit) {
            mv = new MVControl("pd_defaultValue", "String", true);
            mv.setValues(Values.getProperty(node, "jcr:defaultValues", new String[0]));
            mv.setAllowEmpty(true);
            mv.setProperty("css_width", "100");
            mv.draw(this.parent.getPageContext());
        } else {
            this.printValues(out, Values.getProperty(node, "jcr:defaultValues", new String[0]));
        }
        out.print("</td>");
        out.print("<td" + style + ">");
        if (edit) {
            mv = new MVControl("pd_valueConstraint", "String", true);
            mv.setValues(Values.getProperty(node, "jcr:valueConstraints", new String[0]));
            mv.setProperty("css_width", "100");
            mv.setAllowEmpty(true);
            mv.draw(this.parent.getPageContext());
        } else {
            this.printValues(out, Values.getProperty(node, "jcr:valueConstraints", new String[0]));
        }
        out.print("</td>");
        String onVers = Values.getProperty(node, "jcr:onParentVersion", "");
        out.print("<td" + style + ">");
        if (edit) {
            out.print("<select title=\"");
            out.print(this.dict.msg("crex.onparentversion.lab"));
            out.print("\" name=\"pd_onParentVersion\">");
            for (int i = 0; i < NodeTypeView.ON_VERSION_ACTIONS.length; ++i) {
                String selected = NodeTypeView.ON_VERSION_ACTIONS[i].equals(onVers) ? " selected" : "";
                out.print("<option value=\"" + NodeTypeView.ON_VERSION_ACTIONS[i] + "\"" + selected + ">" + NodeTypeView.ON_VERSION_ACTIONS[i]);
            }
            out.print("</select>");
        } else {
            out.print(StringEscapeUtils.escapeHtml4((String)onVers));
        }
        out.print("</td>");
        out.print("<td" + style + ">");
        if (edit) {
            out.print("<input title=\"");
            out.print(this.dict.msg("crex.autocreate.lab"));
            out.print("\" type=\"checkbox\" name=\"pd_autoCreate\" value=\"true\" " + (isAutoCreate ? "checked" : "") + ">");
        } else {
            out.print(isAutoCreate ? "X" : "-");
        }
        out.print("</td>");
        out.print("<td" + style + ">");
        if (edit) {
            out.print("<input title=\"");
            out.print(this.dict.msg("crex.mandatory.lab"));
            out.print("\" type=\"checkbox\" name=\"pd_mandatory\" value=\"true\" " + (isMandatory ? "checked" : "") + ">");
        } else {
            out.print(isMandatory ? "X" : "-");
        }
        out.print("</td>");
        out.print("<td" + style + ">");
        if (edit) {
            out.print("<input title=\"");
            out.print(this.dict.msg("crex.protected.lab"));
            out.print("\" type=\"checkbox\" name=\"pd_protected\" value=\"true\" " + (isProtected ? "checked" : "") + ">");
        } else {
            out.print(isProtected ? "X" : "-");
        }
        out.print("</td>");
        out.print("<td" + style + ">");
        if (edit) {
            out.print("<input title=\"");
            out.print(this.dict.msg("crex.multi_valued.tit"));
            out.print("\" type=\"checkbox\" name=\"pd_multiple\" value=\"true\" " + (isMultiple ? "checked" : "") + ">");
        } else {
            out.print(isMultiple ? "X" : "-");
        }
        out.print("</td>");
        out.print("<td class=\"lastCol\"" + style + ">");
        if (edit) {
            out.print("<img class=\"button\" alt=\"Ok\" src=\"" + this.parent.getDocroot() + "/imgs/icons/check.gif\" onClick=\"doAction('setPropertyDef', '" + StringEscapeUtils.escapeEcmaScript((String)path) + "')\">");
            if (!path.equals("")) {
                out.print("<img class=\"button\" alt=\"Cancel\" src=\"" + this.parent.getDocroot() + "/imgs/icons/delete.gif\" onClick=\"resetForm()\">");
                out.print("<img class=\"button\" alt=\"Delete\" src=\"" + this.parent.getDocroot() + "/imgs/icons/garbage_empty.gif\" onClick=\"doAction('delete', '" + StringEscapeUtils.escapeEcmaScript((String)path) + "')\">");
            }
        } else {
            this.parent.drawNodeType(declaringNodeTypeName);
        }
        out.print("</td>");
        out.print("</tr>");
    }

    private void printValues(JspWriter out, String[] values) throws IOException {
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                out.print("<br>");
            }
            out.print(values[i]);
        }
    }

    public void drawTableFooter() throws IOException {
        JspWriter out = this.parent.getOut();
        out.print("<tr><td class=\"listFooter\" colspan=\"11\">&nbsp;</td></tr>");
    }
}

