/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.ui;

import com.day.crx.explorer.impl.j2ee.JCRExplorerServlet;
import com.day.crx.explorer.impl.ui.NodeTree;
import com.day.crx.explorer.impl.ui.NodeTreeHTMLProvider;
import java.io.IOException;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.jackrabbit.util.Text;

public class PropertyNodeTreeHTMLProvider
implements NodeTreeHTMLProvider {
    public void drawLevel(PageContext context, String treeName, Node parentNode, String openNode, String selectedNode) throws IOException, RepositoryException {
        PropertyIterator piter = parentNode.getProperties();
        while (piter.hasNext()) {
            this.drawProperty(context, treeName, piter.nextProperty(), selectedNode);
        }
        if (!parentNode.getPrimaryNodeType().hasOrderableChildNodes()) {
            NodeIterator children = parentNode.getNodes();
            TreeMap<String, Node> map = new TreeMap<String, Node>();
            while (children.hasNext()) {
                Node node = children.nextNode();
                map.put(node.getName(), node);
            }
            for (Node node : map.values()) {
                this.drawNode(context, treeName, node, openNode, selectedNode);
                this.drawSubNodes(context, treeName, node, openNode, selectedNode);
            }
        } else {
            NodeIterator children = parentNode.getNodes();
            while (children.hasNext()) {
                Node node = children.nextNode();
                this.drawNode(context, treeName, node, openNode, selectedNode);
                this.drawSubNodes(context, treeName, node, openNode, selectedNode);
            }
        }
    }

    public void drawProperty(PageContext context, String treeName, Property prop, String selectedProperty) throws IOException, RepositoryException {
        String docroot = JCRExplorerServlet.getDocrootPrefix((HttpServletRequest)context.getRequest());
        JspWriter out = context.getOut();
        String path = prop.getPath();
        String id = NodeTree.getIdFromPath(treeName, path);
        boolean isOpen = false;
        boolean isSelected = selectedProperty.equals(path);
        boolean hasChildren = false;
        String value = "";
        if (prop.getDefinition().isMultiple()) {
            String delim = "";
            Value[] values = prop.getValues();
            for (int i = 0; i < values.length; ++i) {
                value = value + delim + this.getDisplayValue(values[i]);
                delim = ", ";
            }
        } else {
            value = this.getDisplayValue(prop.getValue());
        }
        String imageSrc = prop.isModified() ? "/imgs/icons/folder_edit.gif" : (prop.isNew() ? "/imgs/icons/folder_new.gif" : JCRExplorerServlet.getPTIcon(prop.getDefinition().getRequiredType()));
        String tooltip = "";
        if (tooltip.equals("")) {
            tooltip = "Path: " + prop.getPath();
        }
        String title = prop.getName();
        if (path.equals("/")) {
            title = "/";
        }
        String nodeClass = "node " + (hasChildren ? (isOpen ? "nOpen" : "nClosed") : "nLeaf");
        String nameClass = "nodeName" + (isSelected ? " nnSelected" : "");
        out.write("<div id=\"" + id + "\" class=\"" + nodeClass + "\" onClick=\"NodeTree.toggleNode('" + Text.encodeIllegalXMLCharacters((String)treeName) + "', this, event)\">");
        out.write("<span class=\"nodeItem\" onClick=\"NodeTree.selectNode('" + Text.encodeIllegalXMLCharacters((String)treeName) + "', this, true, event)\">");
        out.write("<img class=\"nodeIcon\" src=\"" + docroot + imageSrc + "\" border=\"0\">");
        out.write("<span onMouseEnter=\"NodeTree.addClass(this, 'nnHover')\" onMouseLeave=\"NodeTree.removeClass(this, 'nnHover')\" class=\"" + nameClass + "\">" + Text.encodeIllegalXMLCharacters((String)title) + "</span>");
        out.write("</span>");
        out.write("<span class=\"nodeValue\">&nbsp;&nbsp;");
        out.write(Text.encodeIllegalXMLCharacters((String)value));
        out.write("</span>");
        out.write("</div>");
    }

    public void drawNode(PageContext context, String treeName, Node node, String openNode, String selectedNode) throws IOException, RepositoryException {
        String docroot = JCRExplorerServlet.getDocrootPrefix((HttpServletRequest)context.getRequest());
        JspWriter out = context.getOut();
        String path = node.getPath();
        String id = NodeTree.getIdFromPath(treeName, path);
        boolean isOpen = Text.isDescendantOrEqual((String)path, (String)openNode);
        boolean isSelected = selectedNode.equals(path);
        boolean hasChildren = true;
        String imageSrc = node.isModified() ? "/imgs/icons/folder_edit.gif" : (node.isNew() ? "/imgs/icons/folder_new.gif" : JCRExplorerServlet.getNTIcon(node.getPrimaryNodeType()));
        String tooltip = "";
        if (tooltip.equals("")) {
            tooltip = "Path: " + node.getPath();
        }
        String title = node.getName();
        if (path.equals("/")) {
            title = "/";
        }
        String nodeClass = "node " + (hasChildren ? (isOpen ? "nOpen" : "nClosed") : "nLeaf");
        String nameClass = "nodeName" + (isSelected ? " nnSelected" : "");
        out.write("<div id=\"" + id + "\" class=\"" + nodeClass + "\" onClick=\"NodeTree.toggleNode('" + Text.encodeIllegalXMLCharacters((String)treeName) + "', this, event)\">");
        out.write("<span class=\"nodeItem\" onClick=\"NodeTree.selectNode('" + Text.encodeIllegalXMLCharacters((String)treeName) + "', this, true, event)\">");
        out.write("<img class=\"nodeIcon\" src=\"" + docroot + imageSrc + "\" border=\"0\">");
        out.write("<span onMouseEnter=\"NodeTree.addClass(this, 'nnHover')\" onMouseLeave=\"NodeTree.removeClass(this, 'nnHover')\" class=\"" + nameClass + "\">" + Text.encodeIllegalXMLCharacters((String)title) + "</span>");
        out.write("</span>");
        out.write("</div>");
    }

    public void drawSubNodes(PageContext context, String treeName, Node node, String openNode, String selectedNode) throws IOException, RepositoryException {
        JspWriter out = context.getOut();
        String path = node.getPath();
        boolean isOpen = Text.isDescendantOrEqual((String)path, (String)openNode);
        if (isOpen) {
            out.write("<div class=\"subNodes snOpen\">");
            this.drawLevel(context, treeName, node, openNode, selectedNode);
            out.write("</div>");
        } else {
            out.write("<div class=\"subNodes snClosed\"></div>");
        }
    }

    private String getDisplayValue(Value val) throws RepositoryException {
        if (val.getType() != 2) {
            String str = val.getString();
            if (str.length() > 40) {
                str = str.substring(0, 37) + "...";
            }
            return str;
        }
        return "[binary]";
    }
}

