/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.jackrabbit.util.Text;

public class VersionGraph {
    HashSet nodes = new HashSet();
    GraphNode root;
    ArrayList rows = new ArrayList();
    HashSet merges = new HashSet();
    HashSet virtualPreds = new HashSet();
    GraphNode virtualNode;
    LinkedList edges = new LinkedList();
    String baseVersion = "";
    String onSelectVersion = "";

    public VersionGraph(Version rootVersion, Node node) throws RepositoryException {
        if (node.isCheckedOut()) {
            if (node.hasProperty("jcr:predecessors")) {
                Value[] preds = node.getProperty("jcr:predecessors").getValues();
                for (int i = 0; i < preds.length; ++i) {
                    this.virtualPreds.add(preds[i].getString());
                }
            } else {
                Version v = node.getBaseVersion();
                this.virtualPreds.add(v.getUUID());
            }
            this.virtualNode = new GraphNode("new");
            if (this.virtualPreds.size() > 1) {
                this.virtualNode.isMerge = true;
            }
        } else {
            this.baseVersion = node.getBaseVersion().getUUID();
        }
        this.root = this.copyGraph(rootVersion);
        Edge rootEdge = new Edge();
        this.edges.add(rootEdge);
        this.calcEdge(rootEdge, this.root, 0);
        this.adjustMerges();
        this.fillVersionGraph(rootEdge, 0, 0);
    }

    public void setOnSelectVersion(String onSelectVersion) {
        this.onSelectVersion = onSelectVersion;
    }

    public void draw(PageContext context) throws IOException {
        JspWriter out = context.getOut();
        out.print("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
        for (int i = 0; i < this.rows.size(); ++i) {
            GraphNode v;
            int j;
            out.print("<tr><td>&nbsp;</td>");
            ArrayList row = (ArrayList)this.rows.get(i);
            ArrayList nextRow = i + 1 < this.rows.size() ? (ArrayList)this.rows.get(i + 1) : null;
            int colspan = 1;
            GraphNode mergedNode = null;
            for (j = 0; j < row.size(); ++j) {
                String vclass;
                v = (GraphNode)row.get(j);
                if (v.isEmpty() && colspan == 1) {
                    out.print("<td colspan=\"3\">&nbsp;</td>");
                    continue;
                }
                if (v.isVLine()) {
                    out.print("<td style=\"border-right: solid 1px black;\">&nbsp;</td>");
                    out.print("<td>&nbsp;</td>");
                    out.print("<td>&nbsp;</td>");
                    continue;
                }
                if (v.isHLine()) {
                    out.print("<td colspan=\"3\" style=\"border-bottom: solid 1px black;\">&nbsp;</td>");
                    continue;
                }
                if (v.isCorner()) {
                    out.print("<td style=\"border-bottom: solid 1px black;\">&nbsp;</td>");
                    out.print("<td>&nbsp;</td>");
                    out.print("<td>&nbsp;</td>");
                    continue;
                }
                if (v.isMerge() && VersionGraph.hasSameLater(v, row, j)) {
                    mergedNode = v;
                    colspan += 3;
                    continue;
                }
                if (mergedNode != null && VersionGraph.hasSameLater(mergedNode, row, j)) {
                    if (v.isEmpty()) {
                        row.set(j, mergedNode);
                    }
                    colspan += 3;
                    continue;
                }
                if (mergedNode != null) {
                    v = mergedNode;
                    mergedNode = null;
                }
                String string = vclass = v.getUUID().equals(this.baseVersion) ? " vBase" : "";
                if (this.virtualPreds.contains(v.getUUID())) {
                    vclass = vclass + " vPred";
                }
                String event = " onClick=\"" + this.onSelectVersion + "(this, '" + v.getUUID() + "', '" + Text.encodeIllegalXMLCharacters((String)v.getName()) + "');\"";
                if (v.isNew()) {
                    vclass = vclass + " vNew";
                    event = "";
                }
                String title = v.getName();
                if (v.v != null) {
                    try {
                        String[] labels = ((VersionHistory)v.v.getParent()).getVersionLabels(v.v);
                        if (labels.length > 0) {
                            String delim = " (";
                            for (int k = 0; k < labels.length; ++k) {
                                title = title + delim + labels[k];
                                delim = ", ";
                            }
                            title = title + ")";
                        }
                    }
                    catch (RepositoryException e) {
                        // empty catch block
                    }
                }
                out.print("<td rowspan=\"2\" colspan=\"" + (1 + colspan) + "\" class=\"version" + vclass + "\"" + event + ">" + Text.encodeIllegalXMLCharacters((String)title) + "</td>");
                out.print("<td rowspan=\"2\">&nbsp;</td>");
                colspan = 1;
            }
            out.print("</tr>");
            out.print("<tr><td>&nbsp;</td>");
            for (j = 0; j < row.size(); ++j) {
                v = (GraphNode)row.get(j);
                if (v.isEmpty()) {
                    out.print("<td colspan=\"3\">&nbsp;</td>");
                    continue;
                }
                if (v.isCorner() || v.isVLine()) {
                    out.print("<td style=\"border-right: solid 1px black\">&nbsp;</td>");
                    out.print("<td>&nbsp;</td>");
                    out.print("<td>&nbsp;</td>");
                    continue;
                }
                if (!v.isHLine()) continue;
                out.print("<td colspan=\"3\">&nbsp;</td>");
            }
            out.print("</tr>");
            out.print("<tr><td>&nbsp;</td>");
            for (j = 0; j < row.size(); ++j) {
                GraphNode below;
                v = (GraphNode)row.get(j);
                GraphNode graphNode = below = nextRow == null || j >= nextRow.size() ? new GraphNode() : (GraphNode)nextRow.get(j);
                if (VersionGraph.isPredecessor(below, v) || v.isCorner() || v.isVLine() || below != null && below.isVLine()) {
                    out.print("<td style=\"border-right: solid 1px black;\">&nbsp;</td>");
                    out.print("<td>&nbsp;</td>");
                    out.print("<td>&nbsp;</td>");
                    continue;
                }
                out.print("<td colspan=\"3\">&nbsp;</td>");
            }
            out.print("</tr>");
        }
        out.print("</table>");
    }

    private void adjustMerges() {
        for (String uuid : this.merges) {
            GraphNode n;
            LinkedList<Edge> current = new LinkedList<Edge>();
            int height = -1;
            for (Edge e : this.edges) {
                n = e.getByUUID(uuid);
                if (n == null) continue;
                current.add(e);
                if (e.getHeight(n) <= height) continue;
                height = e.getHeight(n);
            }
            for (Edge e : current) {
                n = e.getByUUID(uuid);
                e.adjustHeight(n, height);
            }
        }
    }

    public ArrayList getRows() {
        return this.rows;
    }

    public void set(GraphNode node, int x, int y) {
        ArrayList row = this.getRow(y);
        for (int i = row.size(); i <= x; ++i) {
            row.add(new GraphNode());
        }
        row.set(x, node);
    }

    public void insert(GraphNode node, int x, int y) {
        ArrayList row = this.getRow(y);
        for (int i = row.size(); i <= x; ++i) {
            row.add(new GraphNode());
        }
        row.add(x, node);
    }

    public GraphNode get(int x, int y) {
        ArrayList row = this.getRow(y);
        for (int i = row.size(); i <= x; ++i) {
            row.add(new GraphNode());
        }
        return (GraphNode)row.get(x);
    }

    public ArrayList getRow(int y) {
        for (int i = this.rows.size(); i <= y; ++i) {
            this.rows.add(null);
        }
        ArrayList row = (ArrayList)this.rows.get(y);
        if (row == null) {
            row = new ArrayList();
            this.rows.set(y, row);
        }
        return row;
    }

    private GraphNode copyGraph(Version v) throws RepositoryException {
        GraphNode gr = new GraphNode(v);
        Version[] succ = v.getSuccessors();
        for (int i = 0; i < succ.length; ++i) {
            GraphNode suc = this.copyGraph(succ[i]);
            gr.addSuccessor(suc);
            suc.addPredecessor(gr);
        }
        if (this.virtualPreds.contains(gr.getUUID())) {
            gr.addSuccessor(this.virtualNode);
            if (this.virtualNode != null) {
                this.virtualNode.addPredecessor(gr);
            }
        }
        return gr;
    }

    private void fillVersionGraph(Edge e, int x, int y) {
        int i;
        boolean found = true;
        block0: do {
            found = true;
            for (i = 0; i < e.nodes.size(); ++i) {
                if (this.get(x + e.x, y + e.y + i).isEmpty()) continue;
                found = false;
                GraphNode hline = new GraphNode();
                hline.isHLine = true;
                if (this.get(x + e.x, y + e.y).isEmpty()) {
                    this.set(hline, x + e.x, y + e.y);
                }
                ++x;
                continue block0;
            }
        } while (!found);
        for (i = 0; i < e.nodes.size(); ++i) {
            this.set((GraphNode)e.nodes.get(i), x + e.x, y + e.y + i);
        }
        for (i = 0; i < e.children.size(); ++i) {
            this.fillVersionGraph((Edge)e.children.get(i), e.x + x, e.y + y);
        }
    }

    private void calcEdge(Edge e, GraphNode gr, int y) throws RepositoryException {
        e.nodes.add(gr);
        GraphNode[] suc = gr.getSuccessors();
        if (suc.length != 0 && !this.merges.contains(gr.getUUID())) {
            this.calcEdge(e, suc[0], y + 1);
            if (suc.length > 1) {
                for (int i = 1; i < suc.length; ++i) {
                    Edge e1 = new Edge();
                    this.edges.add(e1);
                    e1.y = y;
                    e1.x = 1;
                    GraphNode next = new GraphNode(gr);
                    next.isCorner = true;
                    if (i < suc.length - 1) {
                        next.isHLine = true;
                    }
                    e1.nodes.add(next);
                    this.calcEdge(e1, suc[i], 1);
                    e.addChild(e1);
                }
            }
        }
        if (gr.isMerge()) {
            this.merges.add(gr.getUUID());
        }
    }

    private static boolean isPredecessor(GraphNode v, GraphNode pred) {
        if (v == null || pred == null) {
            return false;
        }
        GraphNode[] preds = v.getPredecessors();
        for (int i = 0; i < preds.length; ++i) {
            if (preds[i] != pred) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSameLater(GraphNode node, ArrayList row, int i) {
        ++i;
        while (i < row.size()) {
            GraphNode n;
            if ((n = (GraphNode)row.get(i++)).isEmpty() || !n.equals(node)) continue;
            return true;
        }
        return false;
    }

    public static void drawCSS(PageContext context) throws IOException {
        JspWriter out = context.getOut();
        out.print("TD.version {\n\tborder: solid 1px black;\n\tpadding: 2px;\n\tmargin: 2px;\n}\nTD.vBase {\n\tbackground-color: #eeeeee;\n}\nTD.vNew {\n\tborder: dashed 1px #888888;\n\tcolor: #888888;\n}\nTD.vPred {\n\tbackground-color: #ccffcc;\n}\nTD.selected {\n\tborder: solid 2px black;\n}");
    }

    private static class GraphNode {
        LinkedList predecessors = new LinkedList();
        LinkedList successors = new LinkedList();
        Version v;
        String name;
        String uuid;
        boolean isLeaf;
        boolean isMerge;
        boolean isBranch;
        boolean isHLine;
        boolean isVLine;
        boolean isCorner;

        public GraphNode(Version v) throws RepositoryException {
            if (v != null) {
                this.v = v;
                this.name = v.getName();
                this.uuid = v.getUUID();
                this.isLeaf = v.getSuccessors().length == 0;
                this.isBranch = v.getSuccessors().length > 1;
                this.isMerge = v.getPredecessors().length > 1;
            }
        }

        public GraphNode(GraphNode node) throws RepositoryException {
            this(node.v);
        }

        public GraphNode(String name) {
            this.name = name;
            this.uuid = "dummy";
            this.isLeaf = true;
        }

        public GraphNode() {
            this.v = null;
        }

        public boolean isEmpty() {
            return this.name == null && !this.isHLine && !this.isVLine;
        }

        public boolean isNew() {
            return this.name != null && this.v == null;
        }

        public boolean isCorner() {
            return this.isCorner;
        }

        public void addPredecessor(GraphNode gr) {
            this.predecessors.add(gr);
        }

        public void addSuccessor(GraphNode gr) {
            this.successors.add(gr);
        }

        public GraphNode[] getPredecessors() {
            return this.predecessors.toArray(new GraphNode[this.predecessors.size()]);
        }

        public GraphNode[] getSuccessors() {
            return this.successors.toArray(new GraphNode[this.successors.size()]);
        }

        public String getName() {
            return this.name;
        }

        public String getUUID() {
            return this.uuid;
        }

        public int hashCode() {
            return this.v == null ? 0 : this.v.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof GraphNode) {
                GraphNode other = (GraphNode)obj;
                return other.uuid == this.uuid || this.uuid != null && this.uuid.equals(other.uuid);
            }
            return false;
        }

        public String toString() {
            return this.v == null ? null : this.v.toString();
        }

        public boolean isMerge() {
            return this.isMerge;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public boolean isBranch() {
            return this.isBranch;
        }

        public boolean isHLine() {
            return this.isHLine;
        }

        public boolean isVLine() {
            return this.isVLine;
        }
    }

    private static class Edge {
        int x;
        int y;
        private LinkedList nodes = new LinkedList();
        private LinkedList children = new LinkedList();
        Edge parent;

        private Edge() {
        }

        public void addChild(Edge e) {
            this.children.add(e);
            e.parent = this;
        }

        public int getHeight(GraphNode n) {
            int h = this.getY();
            for (GraphNode node : this.nodes) {
                if (node == n) {
                    return h;
                }
                ++h;
            }
            return -1;
        }

        public int getY() {
            return this.parent == null ? this.y : this.y + this.parent.getY();
        }

        public void adjustHeight(GraphNode n, int height) {
            GraphNode node;
            int h = this.getY();
            Iterator iter = this.nodes.iterator();
            int idx = 0;
            while (iter.hasNext() && (node = (GraphNode)iter.next()) != n) {
                ++idx;
                ++h;
            }
            while (h < height) {
                GraphNode next = new GraphNode();
                next.isVLine = true;
                this.nodes.add(idx, next);
                ++h;
            }
        }

        public GraphNode getByUUID(String uuid) {
            for (GraphNode node : this.nodes) {
                if (!uuid.equals(node.getUUID())) continue;
                return node;
            }
            return null;
        }
    }
}

