/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.util;

import java.util.HashMap;
import java.util.Map;

public class HttpHeader {
    private final String name;
    private final String header;
    private Map<String, String> parts;

    public HttpHeader(String headerline) {
        int pos = headerline.indexOf(58);
        if (pos < 0) {
            throw new IllegalArgumentException("header invalid, no colon:" + headerline);
        }
        this.name = headerline.substring(0, pos).trim();
        this.header = headerline.substring(pos + 1).trim();
        this.parse();
    }

    public HttpHeader(String name, String value) {
        this.name = name.trim();
        this.header = value.trim();
        this.parse();
    }

    public String getName() {
        return this.name;
    }

    public String getPart(String name) {
        return this.parts == null ? null : this.parts.get(name);
    }

    public String getPrimary() {
        return this.parts == null ? this.header : this.parts.get("");
    }

    public String toString() {
        return this.header;
    }

    protected String toString_test() {
        String ret = this.getPrimary();
        if (this.parts != null) {
            for (String key : this.parts.keySet()) {
                if (key.equals("")) continue;
                ret = ret + "; " + key + "=" + this.parts.get(key);
            }
        }
        return ret;
    }

    private void parse() {
        int pos = this.header.indexOf(59);
        if (pos < 0) {
            return;
        }
        this.parts = new HashMap<String, String>();
        this.parts.put("", this.header.substring(0, pos++));
        String parse = this.header + ";";
        String name = "";
        int start = pos;
        int state = 0;
        while (pos < parse.length()) {
            char c = parse.charAt(pos);
            switch (state) {
                case 0: {
                    if (c == ';' || c == ' ' || c == '\r' || c == '\n' || c == '\t') break;
                    start = pos;
                    state = 1;
                    break;
                }
                case 1: {
                    if (c != '=') break;
                    name = this.header.substring(start, pos);
                    start = pos + 1;
                    state = 2;
                    break;
                }
                case 2: {
                    if (c == '\"') {
                        state = 3;
                        start = pos + 1;
                        break;
                    }
                    if (c == '\'') {
                        state = 4;
                        start = pos + 1;
                        break;
                    }
                    if (c != ' ' && c != ';') break;
                    this.parts.put(name.toLowerCase(), this.header.substring(start, pos));
                    state = 0;
                    name = "";
                    break;
                }
                case 3: {
                    if (c != '\"') break;
                    this.parts.put(name.toLowerCase(), this.header.substring(start, pos));
                    state = 0;
                    name = "";
                    break;
                }
                case 4: {
                    if (c != '\'') break;
                    this.parts.put(name.toLowerCase(), this.header.substring(start, pos));
                    state = 0;
                    name = "";
                }
            }
            ++pos;
        }
    }
}

