/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.util;

import com.day.crx.explorer.impl.util.Blob;
import com.day.crx.explorer.impl.util.BlobFactory;
import com.day.crx.explorer.impl.util.BlobOutputStream;
import com.day.crx.explorer.impl.util.HttpHeader;
import com.day.crx.explorer.impl.util.RequestParameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMultipartPost {
    public static final String DEFAULT_ENCODING = "Cp1252";
    public static final String PARAMETER_FORMENCODING = "FormEncoding";
    public static final String PARAMETER_CHARSET = "_charset_";
    private static final Logger log = LoggerFactory.getLogger(HttpMultipartPost.class);
    private final LinkedHashMap<String, List<RequestParameter>> parameters = new LinkedHashMap();
    private final Set<String> fileParameters = new LinkedHashSet<String>();
    private String formEncoding = "Cp1252";
    private final BlobFactory blobFactory;

    private void decodeQuery(String query) throws IOException {
        if (query != null && query.length() > 0) {
            log.debug("HttpMultipartPost: Analyzing query {}", (Object)query);
            StringTokenizer nvpairs = new StringTokenizer(query, "&");
            while (nvpairs.hasMoreTokens()) {
                String nvpair = nvpairs.nextToken();
                int assign = nvpair.indexOf(61);
                if (assign <= 0) continue;
                String name = nvpair.substring(0, assign);
                StringBuffer b = new StringBuffer();
                BlobOutputStream bout = this.blobFactory.createOutputStream();
                for (int i = assign + 1; i < nvpair.length(); ++i) {
                    char c = nvpair.charAt(i);
                    if (c == '%') {
                        try {
                            if (nvpair.charAt(i + 1) == 'u') {
                                c = (char)Integer.parseInt(nvpair.substring(i + 2, i + 6), 16);
                                bout = null;
                                i += 5;
                            }
                            c = (char)Integer.parseInt(nvpair.substring(i + 1, i + 3), 16);
                            i += 2;
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException(e.toString());
                        }
                    } else if (c == '+') {
                        c = ' ';
                    }
                    b.append(c);
                    if (bout == null) continue;
                    bout.write(c);
                }
                if (bout == null) {
                    this.addParameter(new RequestParameter(this, name, b.toString()));
                    continue;
                }
                this.addParameter(new RequestParameter(this, name, bout.getBlob(), null));
            }
        } else {
            log.debug("HttpMultipartPost: No query string in request");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeMultipart(BlobFactory factory, HttpServletRequest request) throws IOException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return;
        }
        ServletFileUpload upload = new ServletFileUpload();
        try {
            FileItemIterator iter = upload.getItemIterator(request);
            while (iter.hasNext()) {
                RequestParameter param;
                FileItemStream item = iter.next();
                String name = item.getFieldName();
                InputStream stream = item.openStream();
                String contentType = item.getContentType();
                HttpHeader ct = contentType == null ? null : new HttpHeader("content-type", contentType);
                try {
                    param = null;
                    if (item.isFormField()) {
                        param = new RequestParameter(this, name, null, ct, factory.create(IOUtils.toByteArray((InputStream)stream)));
                    } else if (ct != null) {
                        BlobOutputStream out = factory.createOutputStream();
                        IOUtils.copy((InputStream)stream, (OutputStream)out);
                        param = new RequestParameter(this, name, item.getName(), ct, out.getBlob());
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)stream);
                }
                if (param == null) continue;
                this.addParameter(param);
            }
        }
        catch (FileUploadException e) {
            log.error("Error while processing multipart.", (Throwable)e);
            throw new IOException(e.toString());
        }
    }

    private void adjustFormEncoding() {
        String formEncodingParam = this.getParameter(PARAMETER_FORMENCODING);
        if (formEncodingParam == null || formEncodingParam.length() == 0) {
            formEncodingParam = this.getParameter(PARAMETER_CHARSET);
        }
        if (formEncodingParam != null && formEncodingParam.length() > 0) {
            try {
                "".getBytes(formEncodingParam);
                this.formEncoding = formEncodingParam;
            }
            catch (UnsupportedEncodingException e) {
                log.warn("HttpMulitpartPost: Character encoding {} is not supported, using default {}", (Object)formEncodingParam, (Object)DEFAULT_ENCODING);
            }
        } else {
            log.debug("HttpMulitpartPost: No {} parameter, using default {}", (Object)PARAMETER_FORMENCODING, (Object)DEFAULT_ENCODING);
        }
    }

    public String getFormEncoding() {
        return this.formEncoding;
    }

    public HttpMultipartPost(BlobFactory factory, HttpServletRequest request) {
        this.blobFactory = factory;
        try {
            this.decodeQuery(request.getQueryString());
            this.decodeMultipart(factory, request);
            this.adjustFormEncoding();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addParameter(RequestParameter param) {
        List<RequestParameter> list = this.parameters.get(param.name);
        if (list == null) {
            list = new ArrayList<RequestParameter>();
            this.parameters.put(param.name, list);
        }
        list.add(param);
        if (param.isFileParameter()) {
            this.fileParameters.add(param.name);
        }
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public Map<String, String[]> getParameterMap() {
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>();
        for (String key : this.parameters.keySet()) {
            map.put(key, this.getParameterValues(key));
        }
        return map;
    }

    public Blob[] getParameterValuesBlob(String name) {
        List<RequestParameter> list = this.parameters.get(name);
        if (list == null) {
            return null;
        }
        Blob[] ret = new Blob[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = list.get(i).getData();
        }
        return ret;
    }

    public Blob getParameterBlob(String name) {
        ArrayList list = (ArrayList)this.parameters.get(name);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return ((RequestParameter)list.get(0)).getData();
    }

    public String[] getParameterValues(String name) {
        List<RequestParameter> list = this.parameters.get(name);
        String[] ret = null;
        if (list != null) {
            ret = new String[list.size()];
            for (int i = 0; i < ret.length; ++i) {
                RequestParameter param = list.get(i);
                ret[i] = param.isFileParameter() ? param.getFilename() : list.get(i).getString();
            }
        }
        return ret;
    }

    public String[] getParameterValues(String name, String enc) throws IOException {
        List<RequestParameter> list = this.parameters.get(name);
        String[] ret = null;
        if (list != null) {
            ret = new String[list.size()];
            for (int i = 0; i < ret.length; ++i) {
                RequestParameter param = list.get(i);
                ret[i] = param.isFileParameter() ? param.getFilename() : new String(param.getData().getBytes(), enc);
            }
        }
        return ret;
    }

    public String getParameter(String name) {
        List<RequestParameter> list = this.parameters.get(name);
        if (list == null || list.isEmpty()) {
            return null;
        }
        RequestParameter p = list.get(0);
        if (p.isFileParameter()) {
            return p.getFilename();
        }
        return p.getString();
    }

    public RequestParameter getRequestParameter(String name) {
        List<RequestParameter> list = this.parameters.get(name);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public String getParameter(String name, String enc) throws IOException {
        List<RequestParameter> list = this.parameters.get(name);
        if (list == null || list.isEmpty()) {
            return null;
        }
        RequestParameter p = list.get(0);
        if (p.isFileParameter()) {
            return p.getFilename();
        }
        return new String(p.getData().getBytes(), enc);
    }

    public String getParameterType(String name) {
        List<RequestParameter> list = this.parameters.get(name);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0).getContentType();
    }

    public String[] getParameterTypes(String name) {
        List<RequestParameter> list = this.parameters.get(name);
        String[] ret = new String[list == null ? 0 : list.size()];
        if (list != null) {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = list.get(i).getContentType();
            }
        }
        return ret;
    }

    public Iterator<String> getFileParameterNames() {
        return this.fileParameters.iterator();
    }

    public File[] getFileParameterValues(String name) throws IOException {
        if (!this.fileParameters.contains(name)) {
            return null;
        }
        List<RequestParameter> list = this.parameters.get(name);
        if (list == null || list.isEmpty()) {
            return null;
        }
        File[] ret = new File[list.size()];
        int pos = 0;
        for (RequestParameter param : list) {
            ret[pos] = param.getData().getFile();
            if (ret[pos] == null) continue;
            ++pos;
        }
        if (pos < list.size()) {
            File[] ret1 = new File[pos];
            System.arraycopy(ret, 0, ret1, 0, pos);
            ret = ret1;
        }
        return ret;
    }

    public File getFileParameter(String name) throws IOException {
        if (!this.fileParameters.contains(name)) {
            return null;
        }
        List<RequestParameter> list = this.parameters.get(name);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0).getData().getFile();
    }

    public boolean isFileParameter(String name) {
        return this.fileParameters.contains(name);
    }
}

