/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.util;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JSR283Helper {
    private static final String NS_SV_URI = "http://www.jcp.org/jcr/sv/1.0";

    public static Node getNode(Session session, String path) throws RepositoryException {
        Node root = session.getRootNode();
        if (path.equals("") || path.equals("/")) {
            return root;
        }
        path = path.endsWith("/") ? path.substring(1, path.length() - 1) : path.substring(1);
        return root.getNode(path);
    }

    public static Property getProperty(Session session, String path) throws RepositoryException {
        return session.getRootNode().getProperty(path.substring(1));
    }

    public static String getExtendedPath(Property property) throws RepositoryException {
        Node parent = property.getParent();
        StringBuffer path = new StringBuffer();
        if (parent.getDepth() > 0) {
            path.append(parent.getPath());
        }
        path.append("/./");
        path.append(property.getName());
        return path.toString();
    }

    public static Item getItem(Session session, String path) throws RepositoryException {
        String relPath;
        Node root = session.getRootNode();
        if (path.equals("/")) {
            return root;
        }
        if (path.endsWith("/") && root.hasNode(relPath = path.substring(1, path.length() - 1))) {
            return root.getNode(relPath);
        }
        if (JSR283Helper.addressesProperty(path) && root.hasProperty(relPath = path.substring(1))) {
            return root.getProperty(relPath);
        }
        return session.getItem(path);
    }

    public static boolean addressesProperty(String path) {
        if (path == null || path.equals("") || path.equals("/")) {
            return false;
        }
        String parent = Text.getRelativeParent((String)path, (int)1);
        return Text.getName((String)parent).equals(".");
    }

    public static boolean addressesNode(String path) {
        return path != null && (path.equals("") || path.endsWith("/"));
    }

    public static Node setPrimaryType(Node node, String type) throws RepositoryException {
        if (node.getPrimaryNodeType().getName().equals(type)) {
            return node;
        }
        Session session = node.getSession();
        String uuid = node.isNodeType("mix:referenceable") ? node.getUUID() : null;
        String name = node.getName();
        Node parent = node.getParent();
        NodeType[] mix = node.getMixinNodeTypes();
        Node tmpNode = session.getRootNode().addNode("tmp" + System.currentTimeMillis(), "nt:unstructured");
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            session.move(child.getPath(), tmpNode.getPath() + "/" + child.getName());
        }
        PropertyIterator piter = node.getProperties();
        while (piter.hasNext()) {
            Property p = piter.nextProperty();
            if (p.getDefinition().isProtected()) continue;
            if (p.getDefinition().isMultiple()) {
                tmpNode.setProperty(p.getName(), p.getValues());
                continue;
            }
            tmpNode.setProperty(p.getName(), p.getValue());
        }
        node.remove();
        node = uuid == null ? parent.addNode(name, type) : JSR283Helper.addNode(parent, name, type, uuid);
        for (int i = 0; i < mix.length; ++i) {
            node.addMixin(mix[i].getName());
        }
        iter = tmpNode.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            session.move(child.getPath(), node.getPath() + "/" + child.getName());
        }
        piter = tmpNode.getProperties();
        while (piter.hasNext()) {
            Property p = piter.nextProperty();
            if (p.getDefinition().isProtected()) continue;
            if (p.getDefinition().isMultiple()) {
                node.setProperty(p.getName(), p.getValues());
                continue;
            }
            node.setProperty(p.getName(), p.getValue());
        }
        tmpNode.remove();
        return node;
    }

    public static Node addNode(Node parent, String name, String type, String uuid) throws RepositoryException {
        try {
            Session session = parent.getSession();
            ContentHandler handler = session.getImportContentHandler(parent.getPath(), 3);
            String[] prefixes = session.getNamespacePrefixes();
            handler.startDocument();
            for (int i = 0; i < prefixes.length; ++i) {
                String prefix = prefixes[i];
                handler.startPrefixMapping(prefix, session.getNamespaceURI(prefix));
            }
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(NS_SV_URI, "name", "sv:name", "CDATA", name);
            handler.startElement(NS_SV_URI, "node", "sv:node", attrs);
            attrs = new AttributesImpl();
            attrs.addAttribute(NS_SV_URI, "name", "sv:name", "CDATA", "jcr:primaryType");
            attrs.addAttribute(NS_SV_URI, "type", "sv:type", "CDATA", "Name");
            handler.startElement(NS_SV_URI, "property", "sv:property", attrs);
            handler.startElement(NS_SV_URI, "value", "sv:value", null);
            handler.characters(type.toCharArray(), 0, type.length());
            handler.endElement(NS_SV_URI, "value", "sv:value");
            handler.endElement(NS_SV_URI, "property", "sv:property");
            if (uuid != null) {
                attrs = new AttributesImpl();
                attrs.addAttribute(NS_SV_URI, "name", "sv:name", "CDATA", "jcr:uuid");
                attrs.addAttribute(NS_SV_URI, "type", "sv:type", "CDATA", "String");
                handler.startElement(NS_SV_URI, "property", "sv:property", attrs);
                handler.startElement(NS_SV_URI, "value", "sv:value", null);
                handler.characters(uuid.toCharArray(), 0, uuid.length());
                handler.endElement(NS_SV_URI, "value", "sv:value");
                handler.endElement(NS_SV_URI, "property", "sv:property");
            }
            handler.endElement(NS_SV_URI, "node", "sv:node");
            handler.endDocument();
            return parent.getNode(name);
        }
        catch (SAXException e) {
            Exception root = e.getException();
            if (root instanceof RepositoryException) {
                throw (RepositoryException)((Object)root);
            }
            if (root instanceof RuntimeException) {
                throw (RuntimeException)root;
            }
            throw new RepositoryException("Error while creating node", (Throwable)root);
        }
    }

    public static int getPropertyTypeFromName(String name) {
        return JcrUtils.getPropertyType((String)name);
    }
}

