/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.util;

import com.day.crx.explorer.impl.util.BlobFactory;
import com.day.crx.explorer.impl.util.BlobFactoryImpl;
import com.day.crx.explorer.impl.util.HttpMultipartPost;
import com.day.crx.explorer.impl.util.RequestParameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestData {
    private final HttpServletRequest request;
    private HttpMultipartPost mpReq;
    private BlobFactory blobFactory;

    public RequestData(HttpServletRequest request, File tmpDirectory) {
        this.request = request;
        this.blobFactory = new BlobFactoryImpl(tmpDirectory);
        this.mpReq = new HttpMultipartPost(this.blobFactory, request);
    }

    public void close() throws IOException {
        this.blobFactory.close();
        this.blobFactory = null;
    }

    public String getParameter(String name) {
        String ret = this.mpReq.getParameter(name);
        return ret == null ? this.request.getParameter(name) : ret;
    }

    public String getParameter(String name, String def) {
        String ret = this.mpReq.getParameter(name);
        if (ret == null) {
            ret = this.request.getParameter(name);
        }
        return ret == null ? def : ret;
    }

    public Enumeration<String> getParameterNames() {
        LinkedHashSet names = new LinkedHashSet(this.request.getParameterMap().keySet());
        names.addAll(this.mpReq.getParameterNames());
        return Collections.enumeration(names);
    }

    public Map<String, String[]> getParameterMap() {
        LinkedHashMap<String, String[]> map = new LinkedHashMap<String, String[]>(this.request.getParameterMap());
        map.putAll(this.mpReq.getParameterMap());
        return map;
    }

    public String[] getParameterValues(String name) {
        String[] ret = this.mpReq.getParameterValues(name);
        return ret == null ? this.request.getParameterValues(name) : ret;
    }

    public String[] getParameterTypes(String name) {
        String[] types = this.mpReq.getParameterTypes(name);
        return types == null ? null : types;
    }

    public File getFileParameter(String name) throws IOException {
        return this.mpReq.getFileParameter(name);
    }

    public RequestParameter getRequestParameter(String name) throws IOException {
        return this.mpReq.getRequestParameter(name);
    }

    public File[] getFileParameters(String name) throws IOException {
        return this.mpReq.getFileParameterValues(name);
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }
}

