/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.explorer.impl.util;

import com.day.crx.explorer.impl.util.Blob;
import com.day.crx.explorer.impl.util.HttpHeader;
import com.day.crx.explorer.impl.util.HttpMultipartPost;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class RequestParameter {
    final String name;
    private final String contentType;
    private final String filename;
    private final String defaultEncoding;
    private final Blob data;
    private String value;
    private HttpMultipartPost httpMultipartPost;

    protected RequestParameter(HttpMultipartPost httpMultipartPost, String name, String value) {
        this.httpMultipartPost = httpMultipartPost;
        this.name = name;
        this.value = value;
        this.contentType = null;
        this.defaultEncoding = null;
        this.filename = null;
        this.data = null;
    }

    protected RequestParameter(HttpMultipartPost httpMultipartPost, String name, Blob data, String defaultEncoding) {
        this.httpMultipartPost = httpMultipartPost;
        this.name = name;
        this.value = null;
        this.contentType = null;
        this.defaultEncoding = defaultEncoding;
        this.filename = null;
        this.data = data;
    }

    protected RequestParameter(HttpMultipartPost httpMultipartPost, String name, String fileName, HttpHeader contentType, Blob data) {
        this.httpMultipartPost = httpMultipartPost;
        this.name = name;
        this.filename = fileName;
        this.value = null;
        this.contentType = contentType == null ? null : contentType.getPrimary();
        this.defaultEncoding = contentType == null ? null : contentType.getPart("charset");
        this.data = data;
    }

    public boolean isFileParameter() {
        return this.filename != null;
    }

    public String getName() {
        return this.name;
    }

    public Blob getData() {
        return this.data;
    }

    public String getEncoding() {
        return this.defaultEncoding;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getString() {
        try {
            if (this.value == null) {
                this.value = new String(this.data.getBytes(), this.defaultEncoding == null ? this.httpMultipartPost.getFormEncoding() : this.defaultEncoding);
            }
            return this.value;
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("Encoding not supported.");
        }
        catch (IOException e) {
            throw new InternalError("Unexpected error: " + e);
        }
    }
}

