/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
/**
 * The <code>Rjax</code> class provides AJAX access to JCR repository.
 * @class
 * @author uncled
 */

var Rjax = new Object();

/**
 * HTTP GET XHR Helper
 * @param {String} url The URL
 * @return The response body
 * @type String
 */
Rjax.httpGet = function(url) {
    var httpcon = document.all ? new ActiveXObject("Microsoft.XMLHTTP") : new XMLHttpRequest();
    if (httpcon) {
	httpcon.open('GET', url, false);
	httpcon.send(null);
	return httpcon.responseText;
    } else {
	return "";
    }
}
/**
 * Produces a "sort-of-json" string representation of a object
 * for debugging purposes only
 * @param {Object} obj The object
 * @param {int} level The indentation level
 * @return The result
 * @type String
 */
Rjax.dumpObj = function(obj, level) {
	var res="";
	for (var a in obj) {
		if (typeof(obj[a])!="object") {
			res+=a+":"+obj[a]+"  ";
		} else {
			res+=a+": { ";
			res+=dumpObj(obj[a])+"} ";
		}
	}
	return (res);
}

/** Produces an aggregate of get all the property names used
 * in a tree as a helper for table oriented display
 * @param {Object} obj The Content Tree object
 * @param {Object} names internal object used for collecting all
 *  the names during the recursion
 * @return An Array of names of properties that exist in a tree
 * @type Array
 */
Rjax.getAllPropNames = function(obj, names) {
	var root=false;
    if (!names) {
        names=new Object();
        root=true;
    }
    for (var a in obj) {
		if (typeof(obj[a])!="object") {
            names[a]="1";
		} else {
			getAllPropNames(obj[a], names);
		}
    }
    if (root) {
        var ar=new Array();
        var i=0;
        for (var a in ar) {
            ar[i]=a;
            i++;
        }
        names=ar;
    }
    return (names);
}

/** Reads a tree of items given a maxlevel from the repository as JSON
 * @param {String} path Path into the current workspace
 * @param {int} maxlevel maximum depth to traverse to
 * @param {Array} filters filter only these properties
 * @return An Object tree of content nodes and properties
 * @type Object
 */
Rjax.getItems = function(path, maxlevels) {
    /** TODO: automatically find the rjax URI without hardcoding, possibly based on
     * the assumption that the rjax servlet is deployed relative to the servlet.
     */
    var res=Rjax.httpGet(Rjax.baseurl+"?Path="+path+(maxlevels?"&maxlevels="+maxlevels:""));
    var obj;
    //alert (res);
    eval("obj={"+res+"}");
    return (obj);
    }

/** Get "session info" from repository. Mainly answers the question: "Who am I"
 *  and "Which workspace am I logged into.
 * @return An Object tree containing the session information
 * @type Object
 */
Rjax.getSessionInfo = function(){
    /** TODO: automatically find the rjax URI without hardcoding, possibly based on
    * the assumption that the rjax servlet is deployed relative to the servlet.
    */
    var res=Rjax.httpGet(Rjax.baseurl+"?Action=session");
    var obj;
    //alert (res);
    eval("obj={"+res+"}");
    //alert ("evalled");
    return (obj);
    }

/** Set form elements based on the tree of items passed into the method
 * @param {String} path passes a string specifying the path If none is supplied the
 * currentPath and finally the "Path" element in the form is used to populate the form.
 * @param {Object} tree optionally pass the content that you want the
 * form to be populated with. This assumes an item tree as returned by
 * getItems().
 *
 */
Rjax.setFormValues = function(path, tree) {
    /** TODO: deal with abolute paths?
     *  TODO: deal with @ValueFrom
     *  TODO: allow explicit form specification
     */
    var lastform=document.forms[document.forms.length-1];
    if (!path) {
        if (!Rjax.currentPath) {
            path=lastform.Path.value;
        } else {
            path=Rjax.currentPath;
        }
    }

    if (!path || path.indexOf("/*")>=0) return;

    if (!tree) {
        tree=Rjax.getItems(path,1);
    }

    var elems=lastform.elements;
    var i=0;
    while (elems.length > i) {
        var elem=elems[i];
        var a=elem.name;
        if (a.indexOf("./")==0 && tree[a.substring(2)]) {
            if (elem.type == "checkbox") {
                var vals;
                if (typeof(tree[a.substring(2)])=="object") vals=tree[a.substring(2)];
                else {
                    vals=new Array();
                    vals[0]=tree[a.substring(2)];
                }
                var j=0;
                while (vals.length > j) {
                    if (vals[j] == elem.value) elem.checked=true;
                    j++;
                }
            } else {
                elem.value=tree[a.substring(2)];
            }
        } else if (a=="Path") {
             elem.value = path;
        }
        i++;
    }
}

/** return Path as specified as the URL Parameter
 *  @param URL
 *  @return The Path parameter isolated from the URL
 *  @type String
 */
Rjax.isolatePathFromUrl = function(url) {
  var pattern = "[\\?&]Path=([^&#]*)";
  var regex = new RegExp( pattern );
  var results = regex.exec( url );
  if( results == null )
        // none found
        return "";
  else
        // found
        return unescape(results[1]);
}

// optain the base_url to communicate with rjax on the server
var scripts = document.getElementsByTagName("SCRIPT")
var script = scripts[scripts.length-1].src
Rjax.baseurl = script.substring(0,script.length-3);
Rjax.currentPath = Rjax.isolatePathFromUrl(document.location.href);