/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
 function startDrag(idx, elem, evt)
  {
  var drag = getDragElement(elem, evt);
  if (drag)
  	{
	window.targetTable = elem;
	while(window.targetTable.tagName != "TABLE" && window.targetTable.tagName != "BODY")
	  {
	  window.targetTable = window.targetTable.parentNode;
	  }
	window.srcTable = drag;
	window.srcTable.srcId = elem.id;
	window.srcTable.title = elem.title;
        window.targetTable.evtPos = (evt) ? Util.getMousePosY(evt) : Util.getMousePosY(event);
	if (window.targetTable.tagName == "TABLE")
	  {
           var rowIdx = new Object();
	   for (var i=0; i<window.targetTable.rows.length;i++)
	  	{
		if(i<1) continue; //skip header
		var row = window.targetTable.rows[i];
	        var start = Util.getPosY(row);
                rowIdx[start] = new Object();
		rowIdx[start].row = row;
		rowIdx[start].start = start;
		rowIdx[start].end = parseInt(row.offsetHeight) + start;
		var div = Util.createElem("div");
		div.zIndex=1;
		div.className="dragMask";
		div.style.width = row.offsetWidth;
		div.style.height = row.offsetHeight;
		div.style.top = Util.getPosY(row);
		div.style.left = Util.getPosX(row);
		rowIdx[start].heighLight = div;
		}
	  rowIdx.length = window.targetTable.rows.length-2;
	  window.targetTable.rowIdx = rowIdx;
	  }
        Util.addEvent(drag, "onmousemove", dragAround);
	Util.addEvent(drag, "onmouseup", cancelDrag)
	Util.addEvent(drag, "onmouseout", cancelDrag);;
	Util.addEvent(drag, "mousemove", dragAround);
	Util.addEvent(drag, "mouseup", cancelDrag);
	Util.addEvent(drag, "mouseout", cancelDrag);
        drag.style.display = (document.all) ? "inline" : "table";
	}
  }

  function dragAround(evt)
     {
     if (!evt) evt = event;
     var dist = Util.getMousePosY(evt)- window.targetTable.evtPos;
     window.targetTable.evtPos = Util.getMousePosY(evt);
     var newPos = parseInt(window.srcTable.style.top)+dist
     var droppable = "";
     var idx = window.targetTable.rowIdx;
     for(var i in idx)
     	{
	var elem = idx[i];
	if (elem.end >= newPos && elem.start<=newPos)
	    {
	    droppable = elem;
	    break;
	    }
	}

    if (droppable)
     	{
	if (window.targetTable.selected)
		{
		window.targetTable.selected.heighLight.style.display="none";
		}

	droppable.heighLight.style.display = "inline";
	window.targetTable.selected = droppable;
	window.srcTable.style.top = newPos;
	}
     }

    function cancelDrag(evt)
  	{
	if (!evt) evt = event;
	if (window.targetTable.selected)
	   {
	    var idx = window.targetTable.rowIdx;
	    if (idx)
	    	{
		for (var i in idx)
		  {
		   if (idx[i].heighLight) document.body.removeChild(idx[i].heighLight);
		   }
		}
            var drag = Util.getElem("DragTable");
	    if (drag)
	      {
	      for(var i=0;i<drag.rows.length;i++)
	        {
		drag.deleteRow(i);
	        }
	      }
	    Util.removeEvent(drag, "onmousemove", dragAround);
	    Util.removeEvent(drag, "onmouseup", cancelDrag)
	    Util.removeEvent(drag, "onmouseout", cancelDrag);;
	    Util.removeEvent(drag, "mousemove", dragAround);
	    Util.removeEvent(drag, "mouseup", cancelDrag);
	    Util.removeEvent(drag, "mouseout", cancelDrag);
	    var src = window.srcTable.srcId;
	    var dst = window.targetTable.selected.row.id;
	    var dstTitle = window.targetTable.selected.row.title;
	    if (!dstTitle) dstTtile = "end";
	    if (src!=dst && !(dst==-1 && src==window.targetTable.rowIdx.length-1)) {
	    	order(src, dst, window.srcTable.title, dstTitle);
	    }
	  }
	}

  function getDragElement(elem, evt)
   {
      var offset = -4;
      var tab = Util.getElem("DragTable");
      if(tab.rows.length>0)
      	{
	for(var i in tab.rows)
	 {
	 tab.deleteRow(i);
	 }
	}
      var row = tab.insertRow(tab.rows.length);
      for (var i=0;i<elem.cells.length;i++)
	  {
	  var c = row.insertCell(i);
	  c.innerHTML = elem.cells[i].innerHTML;
	  }
     tab.style.position = "absolute";
     tab.style.left =Util.getPosX(elem) - 3*offset;
     tab.style.top = Util.getPosY(elem) + offset;
     return tab;
   }

