/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
/**
 * VersionBrowse constructor.
 */
function Dialog(/*string*/name) {
	this.name = name;
}

//-----------------------------------------------------------------------------
// static members
Dialog.docroot = "";

/** map containing all the registred browse controls */
Dialog.controls = new Object();

/**
 * Creates a new NodeTree and puts it into the control registry
 * @param name     name of new node tree
 * @param provider the html provider
 * @param levelURI the location to fetch level data
 *
 * @return newly created node tree instance
 */
/*NodeTree*/ Dialog.create = function(/*string*/ name) {
	return this.controls[name] = new Dialog(name);
}

/**
 * Returns the tree control with the given name
 * @param name the name of the control to return
 *
 * @return the tree control with the given name
 */
/*NodeTree*/ Dialog.getControl = function(/*String*/ name) {
	return this.controls[name];
}



//-----------------------------------------------------------------------------
// static functions

/*void*/ Dialog.setDocroot = function(/*String*/ docroot) {
    this.docroot = docroot;
}

/**
 */
/* void */ Dialog.prototype.browse = function(/*string*/path, /* dialog page */ page, /*function */ callback) {
    this.callback = callback;
    this.value = path;
    var uri = Dialog.docroot + page;
    uri+= "?ck=" + new Date().valueOf();
    uri+= "&Path=" + encodeURIComponent(path);
    uri+="&Callback=" + (callback ? callback : "");
    //var feat = "scroll:no, resizable:yes, status:no, windowheight:250px, windowwidth: 600px,dialog";
    var feat = "scroll=no, height=400, width=300, dialog, resizable=yes, modal";
    var w = window.open(uri, "nodebrowser", feat);
}

/*void*/Dialog.prototype.close = function(/*String*/value) {
    this.value = value;
    if (this.callback) {
    	this.callback(this);
    }
}


