/*
 * $URL $
 * $Id $
 *
 * Copyright (c) 1997-2006 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

/** All possible hex digits */
var HEX_DIGITS = "0123456789ABCDEFabcdef";

/** All allowed characters */
var CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_.:";

/**
 * Encodes <code>name</code> as specified in ISO 9075.
 * @param name the <code>String</code> to encode.
 * @return the encoded <code>String</code>.
 */
/* String */function encodeIso9075(/* String */name) {
    var encoded = "";
    var k = 0;
    var t = 0; // tolerance
    for (var i = 0; i < name.length; i++) {
    	var c = name.charAt(i);
    	if (c == "/") {
    		// start new name
    		k = 0;
    		t = 10;
    		encoded += c;
    		continue;
    	}
    	if (needsEscaping(name, i, t)) {
    		// encode character
			var enc = name.charCodeAt(i).toString(16);
		  	var l = enc.length;
			if (l < 4) {
				for (var j=0; j < 4-l; j++) {
					enc = "0"+enc;
				}
			}
			encoded += "_x"+enc+"_";
    	} else {
    		encoded += c;
    	}
        t = 0; // reset tolerance
        k++;
    }
    return encoded;
}


/**
 * Checks if <code>name.charAt(location)</code> needs to be encoded.
 * @param name the name to check.
 * @param location the location to look at.
 * @return <code>true</code> if either <code>name.charAt(location)</code> 
 *         needs escaping, or it is the underscore character and the 
 *         following character sequence is 'xHHHH_' (H being a hex digit), 
 *         <code>false</code> otherwise.
 */
/* boolean */function needsEscaping(/* String */name, /* int */location, /* int */ tolerance) {
    if (name.charAt(location) == '_' && name.length >= location + 6) {
        return name.charAt(location + 1) == 'x'
            && HEX_DIGITS.indexOf(name.charAt(location + 2)) != -1
            && HEX_DIGITS.indexOf(name.charAt(location + 3)) != -1
            && HEX_DIGITS.indexOf(name.charAt(location + 4)) != -1
            && HEX_DIGITS.indexOf(name.charAt(location + 5)) != -1;
    } else if (CHARS.indexOf(name.charAt(location)) < tolerance) {
    	return true;
    } else {
        return false;
    }
}
