/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
/**
 * VersionBrowse constructor.
 */
function MixinBrowse(/*string*/name) {
	this.name = name;
}

//-----------------------------------------------------------------------------
// static members
MixinBrowse.docroot = "";

/** map containing all the registred browse controls */
MixinBrowse.controls = new Object();

/**
 * Creates a new NodeTree and puts it into the control registry
 * @param name     name of new node tree
 * @param provider the html provider
 * @param levelURI the location to fetch level data
 *
 * @return newly created node tree instance
 */
/*NodeTree*/ MixinBrowse.create = function(/*string*/ name) {
	return this.controls[name] = new MixinBrowse(name);
}

/**
 * Returns the tree control with the given name
 * @param name the name of the control to return
 *
 * @return the tree control with the given name
 */
/*NodeTree*/ MixinBrowse.getControl = function(/*String*/ name) {
	return this.controls[name];
}



//-----------------------------------------------------------------------------
// static functions

/*void*/ MixinBrowse.setDocroot = function(/*String*/ docroot) {
    this.docroot = docroot;
}

/**
 */
/* void */ MixinBrowse.prototype.browse = function(/*string*/path, /*function */ callback) {
    this.callback = callback;
    this.value = path;
    var uri = MixinBrowse.docroot + "/ui/mixin_browse.jsp";
    uri+= "?ck=" + new Date().valueOf();
    uri+= "&Path=" + encodeURIComponent(path);
    uri+= "&_charset_=utf-8";
    uri+="&Callback=" + (callback ? callback : "");
    //var feat = "scroll:no, resizable:yes, status:no, windowheight:250px, windowwidth: 600px,dialog";
    var feat = "scroll=no, height=400, width=300, dialog, resizable=yes, modal";
    var w = window.open(uri, "nodebrowser", feat);
}

/*void*/MixinBrowse.prototype.close = function(/*String*/value) {
    this.value = value;
    if (this.callback) {
    	this.callback(this);
    }
}


