/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
/**
 * NodeBrowse constructor.
 */
function NodeBrowse() {
}

//-----------------------------------------------------------------------------
// static members
NodeBrowse.docroot = "";

//-----------------------------------------------------------------------------
// static functions

/*void*/ NodeBrowse.setDocroot = function(/*String*/ docroot) {
    this.docroot = docroot;
}

/**
 * Creates a new NodeTree and puts it into the control registry
 * @param name     name of new node tree
 * @param provider the html provider
 * @param levelURI the location to fetch level data
 *
 * @return newly created node tree instance
 */
/*void*/ NodeBrowse.browseNode = function(frm, targetCtl, features, callback, title) {
    var uri = this.docroot + "/ui/nodebrowse.jsp";
    uri+= "?_charset_=utf-8&ck=" + new Date().valueOf();
    if (frm && targetCtl!="") {
        uri+= "&SelectedPath=" + encodeURIComponent(frm[targetCtl].value);
    } else {
        uri+= "&SelectedPath=" + encodeURIComponent(targetCtl);
        targetCtl="";
    }
    if (!title) {
        title="Node Browser";
    }
    if (features.indexOf("ShowProps")>=0) {
    	uri+="&ShowProperties=yes";
    }
    if (features.indexOf("ShowNodes")>=0) {
    	uri+="&ShowNodes=yes";
    }
    if (features.indexOf("Editable")>=0) {
    	uri+="&Editable=yes";
    }
    if (window.showModalDialog) {
    	// IE only
	var feat = "scroll:No; resizable:Yes; status:No; dialogHeight:450px; dialogWidth: 600px;";
    	var ret = window.showModalDialog(uri, title, feat);
	if (ret) {
	    if (frm && targetCtl!="") {
	        frm[targetCtl].value = ret;
            }
	    if (callback) {
	        window[callback](ret);
	    }
	}
    } else {
	//var feat = "scroll:no, resizable:yes, status:no, windowheight:250px, windowwidth: 600px,dialog";
	var feat = "scroll=no, height=450, width=600, dialog, resizable=yes, modal";
    	uri+="&TargetFormId=" + (frm.name ? frm.name : "");
    	uri+="&TargetControlId=" + targetCtl;
    	uri+="&Callback=" + (callback ? callback : "");
    	uri+="&Title=" + encodeURIComponent(title);
    	var w = window.open(uri, "nodebrowser", feat);
    }

}

