/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
/**
 * Search constructor.
 */
function Search(/*string*/name) {
	this.name = name;
        this.fields = new Array();
}

//-----------------------------------------------------------------------------
// static members
Search.docroot = "";

/** map containing all the registered browse controls */
Search.controls = new Object();

/**
 * Creates a new control and puts it into the control registry
 * @param name     name of new control
 *
 * @return newly created control
 */
/*Search*/ Search.create = function(/*string*/ name) {
	return this.controls[name] = new Search(name);
};

/**
 * Returns the control with the given name
 * @param name the name of the control to return
 *
 * @return the control with the given name
 */
/*Search*/ Search.getControl = function(/*String*/ name) {
	return this.controls[name];
};



//-----------------------------------------------------------------------------
// static functions

/*void*/ Search.setDocroot = function(/*String*/ docroot) {
    this.docroot = docroot;
};

/*void*/Search.selectNode = function(/*String*/tree,/*HTMLElement*/nodeItem,/*Event*/event) {
    var path = nodeItem.id.substring(nodeItem.id.indexOf(':')+1);
    var win = parent.opener;
    try {
        win.gotoPath(path);
        win.focus();
    } catch (e) {
        alert("Lost original window... Please close and reopen search dialog.");
    }
};

Search.prototype.addField = function(/*InputField*/field) {
    this.fields.push(field);
};

/**
 */
/* void */ Search.prototype.browse = function(/*string*/path, /*function */ callback) {
    this.callback = callback;
    this.value = path;
    var uri = VersionBrowse.docroot + "/ui/search.jsp";
    uri+= "?ck=" + new Date().valueOf();
    uri+= "&Name=" + encodeURIComponent(this.name);
    uri+= "&Path=" + encodeURIComponent(path);
    uri+= "&_charset_=utf-8";
    var feat = "scroll=no, height=460, width=400, resizable=yes, status=no";
    var w = window.open(uri, "search", feat);
    w.focus();
};

/*void*/Search.prototype.close = function(/*String*/value) {
    this.value = value;
    if (this.callback) {
    	this.callback(this);
    }
};

/**
 * InputField constructor.
 */
function InputField(/*String*/title,/*String*/name,/*String*/value) {
    this.name = name;
    this.value = value ? value : "";
    this.title = title ? title : "";
    this.className = "";
}

// static members
InputField.TEXT = "text";
InputField.HIDDEN = "hidden";
InputField.CHECKBOX = "checkbox";
InputField.RADIO = "radio";
InputField.PASSWORD = "password";

/*String*/InputField.prototype.toString = function() {
    var nameAtt =  ' name="'+this.name+'"';
    var valueAtt = this.value     ? ' value="'+this.value+'"' : '';
    var classAtt = this.className ? ' class="'+this.className+'"' : '';
    var styleAtt = this.style     ? ' style="'+this.style+'"' : '';
    var typeAtt  = this.type      ? ' type="'+this.type+'"' : ' type="'+InputField.TEXT+'"';
    var sizeAtt  = this.size      ? ' size="'+this.size+'"' : '';
    return '<input'+nameAtt+valueAtt+typeAtt+sizeAtt+classAtt+styleAtt+'>';
};
