/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
/**
 * Dynamic HTML Utility Methods
 *
 * This is a collection of common, useful Dynamic HTML operations.
 */

/*
 * Static container for the methods.
 */
var Util = new Object();

/**
 * Finds an HTML element by its ID.
 * @param id    The ID of the HTML element
 * @return      A reference to the HTML element
 */
/*Object*/Util.getElem = function(/*String*/ id)
	{
	return document.getElementById(id);
	}

/**
 * Creates a new HTML element of a specific type and appends it
 * to the parent element.
 * @param type    The type of HTML element to create
 * @param parent  The HTML element to append the new element to
 *                (Default: document.body)
 * @return        A reference to the new HTML element
 */
/*Object*/Util.createElem = function(/*String*/type,/*Object*/parent)
	{
	var elem = document.createElement(type);
	if (!parent || !parent.appendChild)
		{
		parent = document.body;
		}
	parent.appendChild(elem);
	return elem;
	}

/**
 * Gets a specific style property of an HTML element.
 * @param elem    The HTML element
 * @param prop    The name of the style property
 * @return        The value of the style property
 */
/*String*/Util.getProp = function(/*Object*/elem,/*String*/prop)
	{
	//alert("get "+elem+":"+prop);
	if (elem.style)
		{
		return elem.style[prop];
		}
	else
		{
		return null;
		}
	}

/**
 * Changes a specific style property of an HTML element.
 * @param elem    The HTML element
 * @param prop    The name of the style property
 * @param value   The value of the style property
 */
/*void*/Util.setProp = function(/*Object*/elem,/*String*/prop,/*String*/value)
	{
	//alert("set "+elem+":"+prop+"="+value);
	if (elem.style)
		{
		//alert(elem.id+":"+prop+":"+value);
		elem.style[prop] = value;
		}
	}

/**
 * Gets the style property <code>width</code> of an HTML element.
 * @param elem    The HTML element
 * @return        The width of the HTML element
 */
/*String*/Util.getWidth = function(/*Object*/elem)
	{
	return this.getProp(elem,"width");
	}

/**
 * Changes the style property <code>width</code> of an HTML element.
 * @param elem    The HTML element
 * @param w       The width of the HTML element
 */
/*void*/Util.setWidth = function(/*Object*/elem,/*String*/w)
	{
	this.setProp(elem,"width",w);
	}

/**
 * Gets the style property <code>height</code> of an HTML element.
 * @param elem    The HTML element
 * @return        The height of the HTML element
 */
/*String*/Util.getHeight = function(/*Object*/elem)
	{
	return this.getProp(elem,"height");
	}

/**
 * Changes the style property <code>height</code> of an HTML element.
 * @param elem    The HTML element
 * @param h       The height of the HTML element
 */
/*void*/Util.setHeight = function(/*Object*/elem,/*int*/h)
	{
	this.setProp(elem,"height",h);
	}

/**
 * Determines the absolute horizontal position of an HTML element.
 * @param obj    The HTML element
 * @return       The horizontal position
 */
/*int*/Util.getPosX = function(/*Object*/obj)
	{
	if (!obj) return 0;
		{
		var x=0;
		while (obj.offsetParent)
			{
			x+=obj.offsetLeft;
			obj=obj.offsetParent;
			}
		return x;
		}
	}

/**
 * Determines the absolute vertical position of an HTML element.
 * @param obj    The HTML element
 * @return       The vertical position
 */
/*int*/Util.getPosY = function(/*Object*/obj)
	{
	if (!obj) return 0;
		{
		var y=0;
		while (obj.offsetParent) 
			{
			y+=obj.offsetTop;
			obj=obj.offsetParent;
			}
		return y;
		}
	}

/**
 * Determines the current horizontal position of the mouse.
 * @param myEvent    The mouse event
 * @return           The horizontal position
 */
/*int*/Util.getMousePosX = function(/*Event*/ myEvent)
	{
	return (typeof(myEvent.pageX) == "undefined" ? myEvent.clientX : myEvent.pageX);
	}

/**
 * Determines the current vertical position of the mouse.
 * @param myEvent    The mouse event
 * @return           The vertical position
 */
/*int*/Util.getMousePosY = function(/*Event*/ myEvent)
	{
	return (typeof(myEvent.pageY) == "undefined" ? myEvent.clientY : myEvent.pageY);
	}
	
/**
 * Prevents further propagation of an event.
 * @param myEvent    The mouse event
 */
/*void*/Util.stopEventBubble = function(/*Event*/ myEvent)
	{
	if (typeof(event) == "undefined")
		{
		myEvent.stopPropagation();
		}
	else
		{
                myEvent.cancelBubble = true;
		}
	}

/**
 * Changes the return value of an event.
 * @param myEvent    The mouse event
 * @param value      The return value
 */
/*void*/Util.setEventReturnValue = function(/*Event*/ myEvent,/*boolean*/ value)
	{
	if (typeof(event) == "undefined" && !value)
		{
		myEvent.preventDefault();
		}
	else
		{
		event.returnValue = value;
		}
	}

/**
 * Adds an event listener to a specific HTML element.
 * @param elem    The HTML element
 * @param name    The event name
 * @param func    The function to execute
 */
/*void*/Util.addEvent = function(/*Object*/elem,/*String*/name,/*Function*/func)
	{
	if (typeof(event) == "undefined")
		{
		elem.addEventListener(name,func,true);
		}
	else
		{
		elem[name] = func;
		}	
	}

/**
 * Removes an event listener from a specific HTML element.
 * @param elem    The HTML element
 * @param name    The event name
 * @param func    The function to execute
 */
/*void*/Util.removeEvent = function(/*Object*/elem,/*String*/name,/*Function*/func)
	{
	if (typeof(event) == "undefined")
		{
		elem.removeEventListener(name,func,true);
		}
	else
		{
		elem[name] = null;
		}	
	}

/**
 * Retrieves a specific cookie from the document.
 * @param name    The name of the cookie
 * @return        The value of the cookie
 */
/*String*/Util.getCookie = function(/*String*/name)
	{
	var cname = name + "=";               
	var dc = document.cookie;             
	if (dc.length > 0)
		{              
		begin = dc.indexOf(cname);       
		if (begin != -1)
			{           
			begin += cname.length;       
			end = dc.indexOf(";", begin);
			if (end == -1) end = dc.length;
			return decodeURIComponent(dc.substring(begin, end));
			} 
		}
	return null;
	}

/**
 * Stores a specific cookie with the document.
 * @param name    The name of the cookie
 * @param value   The value of the cookie
 * @param host    The name of the server the cookie is for
 * @param path    The path on the server the cookie is for
 * @param exp     The expiration date in GMT format
 */
/*void*/Util.setCookie = function(/*String*/name,/*String*/value,/*String*/host,
                          /*String*/path,/*String*/exp)
	{
	document.cookie = name + "=" + value + "; host="+host+"; path="+path+"; expires="+exp;
	}


/**
 * Determines the width of a specific frame or the whole window.
 * @param frame    The frame to measure
 *                 (Default: window)
 * @return         The width of the frame or window
 *                 (Default: 800)
 */
/*int*/Util.getWindowWidth = function(/*Object*/frame)
	{
	if (frame)
		{
		var frameWidth = Util.getWidth(frame);
		if (typeof(frameWidth) != "undefined" && parseInt(frameWidth))
		    {
		    return parseInt(frameWidth);
		    }
		if (frame.contentWindow && frame.contentWindow.innerWidth)
			{
			return frame.contentWindow.innerWidth;
			}
		else if (frame.contentWindow && frame.contentWindow.document && frame.contentWindow.document.documentElement && frame.contentWindow.document.documentElement.clientWidth)
			{
			return frame.contentWindow.document.documentElement.clientWidth;
			}
		else if (frame.contentWindow && frame.contentWindow.document && frame.contentWindow.document.body && frame.contentWindow.document.body.clientWidth)
			{
			return frame.contentWindow.document.body.clientWidth;
			}
		}
	else
		{
		if (window.innerWidth)
			{
			return window.innerWidth;
			}
		else if (window.document && window.document.documentElement && window.document.documentElement.clientWidth)
			{
			return window.document.documentElement.clientWidth;
			}
		else if (window.document && window.document.body && window.document.body.clientWidth)
			{
			return window.document.body.clientWidth;
			}
		}
	return 800;
	}

/**
 * Determines the height of a specific frame or the whole window.
 * @param frame    The frame to measure
 *                 (Default: window)
 * @return         The height of the frame or window
 *                 (Default: 600)
 */
/*int*/Util.getWindowHeight = function(/*Object*/frame)
	{
	if (frame)
		{
		var frameHeight = Util.getHeight(frame);
		if (typeof(frameHeight) != "undefined" && parseInt(frameHeight))
		    {
		    return parseInt(frameHeight);
		    }
		if (frame.contentWindow && frame.contentWindow.innerHeight)
			{
			return frame.contentWindow.innerHeight;
			}
		else if (frame.contentWindow && frame.contentWindow.document && frame.contentWindow.document.documentElement && frame.contentWindow.document.documentElement.clientHeight)
			{
			return frame.contentWindow.document.documentElement.clientHeight;
			}
		else if (frame.contentWindow && frame.contentWindow.document && frame.contentWindow.document.body && frame.contentWindow.document.body.clientHeight)
			{
			return frame.contentWindow.document.body.clientHeight;
			}
		}
	else
		{
		if (window.innerHeight)
			{
			return window.innerHeight;
			}
		else if (window.document && window.document.documentElement && window.document.documentElement.clientHeight)
			{
			return window.document.documentElement.clientHeight;
			}
		else if (window.document && window.document.body && window.document.body.clientHeight)
			{
			return window.document.body.clientHeight;
			}
		}
	return 600;
	}


/**
 * Creates an ID consisting of four concatenated random integers.
 * @return    The random ID
 */
/*String*/Util.createRandomId = function()
	{
	return ""+Math.round(Math.random()*999);
	}

/**
 * removes a CSS class from the DHTMLObject
 * @param elem the DHTML object
 * @param cssClass the className
 */
Util.removeClass = function(/*DHTMLObject*/ elem, /*string*/ cssClass) {
    if (elem.className.indexOf(" " + cssClass)>=0) {
    	elem.className = elem.className.replace(" " + cssClass, "");
    } else if (elem.className.indexOf(cssClass)>=0) {
    	elem.className = elem.className.replace(cssClass, "");
    }
}

/**
 * formats a string by replacing {0} by the respective additional arugments
 */
Util.fmt = function(/* String */ fmt /*, args.... */) {
    for (var i=1; i<arguments.length; i++) {
        var r = new RegExp("\\{"+(i-1)+"\\}", "g");
        fmt = fmt.replace(r, arguments[i]);
    }
    return fmt;
};

//------------------------------------------------------------------------------