/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crypto.internal;

import com.adobe.granite.crypto.internal.CryptoSupportImpl;
import com.adobe.granite.crypto.internal.SecureDataWebConsolePlugin;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    static final String WEB_CONSOLE_LABEL = "crypto";
    private static final String JAR_FILE_PATTERN = "*.jar";
    private static final String JAR_FILE_BUNDLE_PATH = "META-INF/lib";
    private static final String JAR_FILE_TARGET = "lib";
    private static final String JSAFE_CRYPTO_SUPPORT = "com.adobe.granite.crypto.internal.jsafe.JSafeCryptoSupport";
    private static final String keyPath = "/etc/key";
    private static final String keyProperty = "master";
    private static final String keyPropertyPath = "/etc/key/master";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private BundleContext bundleContext;
    private CryptoSupportImpl cryptoSupportImpl;
    private ServiceRegistration configurationPlugin;
    private ServiceRegistration webConsolePlugin;
    private ServiceTracker repositoryTracker;
    private ServiceRegistration cryptoSupportService;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.repositoryTracker = new ServiceTracker(context, "org.apache.sling.jcr.api.SlingRepository", null){

            public Object addingService(ServiceReference reference) {
                if (Activator.this.cryptoSupportImpl == null) {
                    SlingRepository repo = (SlingRepository)super.addingService(reference);
                    Activator.this.setupCryptoSupport(repo);
                    return repo;
                }
                return null;
            }
        };
        this.repositoryTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.webConsolePlugin != null) {
            this.webConsolePlugin.unregister();
            this.webConsolePlugin = null;
        }
        if (this.configurationPlugin != null) {
            this.configurationPlugin.unregister();
            this.configurationPlugin = null;
        }
        if (this.cryptoSupportService != null) {
            this.cryptoSupportService.unregister();
            this.cryptoSupportService = null;
        }
        if (this.repositoryTracker != null) {
            this.repositoryTracker.close();
            this.repositoryTracker = null;
        }
        if (this.cryptoSupportImpl != null) {
            this.cryptoSupportImpl.dispose();
            this.cryptoSupportImpl = null;
        }
        this.bundleContext = null;
    }

    void setupCryptoSupport(SlingRepository repository) {
        try {
            CryptoSupportImpl cryptoSupportImpl = this.createCryptoSupport();
            this.loadOrCreateKey(repository, cryptoSupportImpl);
            this.cryptoSupportImpl = cryptoSupportImpl;
            this.cryptoSupportService = this.bundleContext.registerService("com.adobe.granite.crypto.CryptoSupport", (Object)this.cryptoSupportImpl, null);
            SecureDataWebConsolePluginFactory consoleFactory = new SecureDataWebConsolePluginFactory();
            Hashtable<String, String> consoleProps = new Hashtable<String, String>();
            consoleProps.put("felix.webconsole.label", WEB_CONSOLE_LABEL);
            this.webConsolePlugin = this.bundleContext.registerService("javax.servlet.Servlet", (Object)consoleFactory, consoleProps);
        }
        catch (Exception e) {
            this.log.error("setupCryptSupport: Failed creating CryptoSupport Implementation: ", (Throwable)e);
        }
    }

    private CryptoSupportImpl createCryptoSupport() throws Exception {
        ClassLoader classLoader = this.createClassLoader();
        Class<?> cryptoImplClass = classLoader.loadClass(JSAFE_CRYPTO_SUPPORT);
        Constructor<?> cryptoImplConstructor = cryptoImplClass.getDeclaredConstructor(null);
        return (CryptoSupportImpl)cryptoImplConstructor.newInstance(null);
    }

    private ClassLoader createClassLoader() throws IOException {
        File target = this.bundleContext.getDataFile(JAR_FILE_TARGET);
        target.mkdirs();
        long bundleLastModified = this.bundleContext.getBundle().getLastModified();
        Enumeration entries = this.bundleContext.getBundle().findEntries(JAR_FILE_BUNDLE_PATH, JAR_FILE_PATTERN, false);
        ArrayList<URL> classPathUrls = new ArrayList<URL>();
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                URL classPathUrl = Activator.copy(url, target, bundleLastModified);
                classPathUrls.add(classPathUrl);
            }
        }
        URL[] urls = classPathUrls.toArray(new URL[classPathUrls.size()]);
        return new URLClassLoader(urls, this.getClass().getClassLoader());
    }

    private static URL copy(URL src, File target, long bundleLastModified) throws IOException {
        File targetFile = new File(target, Activator.toName(src, bundleLastModified));
        if (!targetFile.exists()) {
            FileOutputStream dstStream = new FileOutputStream(targetFile);
            InputStream srcStream = src.openStream();
            byte[] buf = new byte[8192];
            int rd = 0;
            while ((rd = srcStream.read(buf)) > 0) {
                ((OutputStream)dstStream).write(buf, 0, rd);
            }
            srcStream.close();
            ((OutputStream)dstStream).close();
        }
        return new URL("jar:" + targetFile.toURI() + "!/");
    }

    private static String toName(URL url, long bundleLastModified) {
        String path = url.getPath();
        int lastSlash = path.lastIndexOf(47);
        String name = lastSlash < 0 ? path : path.substring(lastSlash);
        return name + "." + bundleLastModified + ".jar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOrCreateKey(SlingRepository repository, CryptoSupportImpl cryptoSupport) throws Exception {
        Session session = null;
        try {
            session = repository.loginAdministrative(null);
            byte[] key = this.readKey(session);
            if (key == null) {
                key = cryptoSupport.generateSecretKey();
                this.writeKey(session, cryptoSupport.obfuscate(key));
            } else {
                key = cryptoSupport.deObfuscate(key);
            }
            cryptoSupport.init(key);
        }
        finally {
            if (session != null) {
                try {
                    session.logout();
                }
                catch (Exception e) {}
            }
        }
    }

    private static Node getOrCreateKeyNode(Session session) throws RepositoryException {
        if (session.nodeExists(keyPath)) {
            return session.getNode(keyPath);
        }
        return session.getRootNode().addNode(keyPath.substring(1), "sling:Folder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readKey(Session session) throws Exception {
        if (session.propertyExists(keyPropertyPath)) {
            Binary keyBinary = session.getProperty(keyPropertyPath).getBinary();
            try {
                long size = keyBinary.getSize();
                if (size < Integer.MAX_VALUE) {
                    byte[] bytes = new byte[(int)size];
                    keyBinary.read(bytes, 0L);
                    byte[] byArray = bytes;
                    return byArray;
                }
                this.log.error("loadOrCreateKey: Cannot handle key property larger than Integer.MAX_SIZE bytes!");
            }
            finally {
                keyBinary.dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeKey(Session session, byte[] key) throws Exception {
        Node keyNode = Activator.getOrCreateKeyNode(session);
        ByteArrayInputStream bin = new ByteArrayInputStream(key);
        Binary keyBinary = keyNode.getSession().getValueFactory().createBinary((InputStream)bin);
        try {
            keyNode.setProperty(keyProperty, keyBinary);
        }
        finally {
            keyBinary.dispose();
        }
        Activator.limitAccess(session);
        session.save();
    }

    private static void limitAccess(Session session) throws RepositoryException {
        AccessControlManager acm = session.getAccessControlManager();
        AccessControlPolicyIterator acpi = acm.getApplicablePolicies(keyPath);
        while (acpi.hasNext()) {
            AccessControlPolicy acp = acpi.nextAccessControlPolicy();
            if (!(acp instanceof JackrabbitAccessControlList)) continue;
            JackrabbitAccessControlList acl = (JackrabbitAccessControlList)acp;
            AccessControlEntry[] aces = acl.getAccessControlEntries();
            if (aces != null) {
                for (AccessControlEntry ace : aces) {
                    acl.removeAccessControlEntry(ace);
                }
            }
            Principal adminPrincipal = Activator.getPrincipal(session, session.getUserID());
            acl.addEntry(adminPrincipal, new Privilege[]{acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")}, true);
            Principal everyonePrincipal = Activator.getPrincipal(session, "everyone");
            acl.addEntry(everyonePrincipal, new Privilege[]{acm.privilegeFromName("{http://www.jcp.org/jcr/1.0}all")}, false);
            acm.setPolicy(keyPath, (AccessControlPolicy)acl);
        }
    }

    private static Principal getPrincipal(Session session, String principalName) throws RepositoryException {
        JackrabbitSession jrSession = (JackrabbitSession)session;
        return jrSession.getPrincipalManager().getPrincipal(principalName);
    }

    public class SecureDataWebConsolePluginFactory
    implements ServiceFactory {
        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return new SecureDataWebConsolePlugin(Activator.this.cryptoSupportImpl);
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

