/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crypto.internal;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import java.util.Arrays;

public abstract class CryptoSupportImpl
implements CryptoSupport {
    private static final String CHARACTER_SET = "UTF-8";
    private byte[] key;

    protected CryptoSupportImpl() {
    }

    void init(byte[] key) {
        this.key = key;
    }

    void dispose() {
        if (this.key != null) {
            CryptoSupportImpl.clear(this.key);
            this.key = null;
        }
    }

    public byte[] encrypt(byte[] plainText) throws CryptoException {
        byte[] key = this.key;
        if (key != null) {
            try {
                return this.getCipherText(key, plainText);
            }
            catch (Exception e) {
                throw new CryptoException("Failed encrypting plain text", e);
            }
        }
        throw new IllegalStateException("MasterKey not available yet");
    }

    public byte[] decrypt(byte[] cipherText) throws CryptoException {
        byte[] key = this.key;
        if (key != null) {
            try {
                return this.getPlainText(key, cipherText);
            }
            catch (Exception e) {
                throw new CryptoException("Failed dewcrypting cipher text", e);
            }
        }
        throw new IllegalStateException("MasterKey not available yet");
    }

    public boolean isProtected(String text) {
        return text != null && text.length() > 2 && text.charAt(0) == '{' && text.charAt(text.length() - 1) == '}' && text.length() % 2 == 0;
    }

    public String protect(String plainText) throws CryptoException {
        String string;
        byte[] datumBytes = null;
        byte[] cipherBytes = null;
        try {
            datumBytes = plainText.getBytes(CHARACTER_SET);
            cipherBytes = this.encrypt(datumBytes);
            string = CryptoSupportImpl.toString(cipherBytes);
        }
        catch (Exception e) {
            try {
                throw new CryptoException("Cannot encrypt plain text", e);
            }
            catch (Throwable throwable) {
                CryptoSupportImpl.clear(datumBytes);
                CryptoSupportImpl.clear(cipherBytes);
                throw throwable;
            }
        }
        CryptoSupportImpl.clear(datumBytes);
        CryptoSupportImpl.clear(cipherBytes);
        return string;
    }

    public String unprotect(String cipherText) throws CryptoException {
        String string;
        byte[] datumBytes = null;
        byte[] cipherBytes = null;
        try {
            cipherBytes = this.toByteArray(cipherText);
            datumBytes = this.decrypt(cipherBytes);
            string = new String(datumBytes, CHARACTER_SET);
        }
        catch (Exception e) {
            try {
                throw new CryptoException("Cannot convert byte data", e);
            }
            catch (Throwable throwable) {
                CryptoSupportImpl.clear(datumBytes);
                CryptoSupportImpl.clear(cipherBytes);
                throw throwable;
            }
        }
        CryptoSupportImpl.clear(datumBytes);
        CryptoSupportImpl.clear(cipherBytes);
        return string;
    }

    protected abstract byte[] generateSecretKey() throws Exception;

    protected abstract byte[] getCipherText(byte[] var1, byte[] var2) throws Exception;

    protected abstract byte[] getPlainText(byte[] var1, byte[] var2) throws Exception;

    protected abstract byte[] obfuscate(byte[] var1) throws Exception;

    protected abstract byte[] deObfuscate(byte[] var1) throws Exception;

    private static String toString(byte[] binaryData) {
        StringBuilder res = new StringBuilder(binaryData.length * 2 + 2);
        res.append('{');
        for (int i = 0; i < binaryData.length; ++i) {
            String hex = Integer.toHexString(binaryData[i] & 0xFF);
            if (hex.length() < 2) {
                res.append('0');
            }
            res.append(hex);
        }
        res.append('}');
        return res.toString();
    }

    private byte[] toByteArray(String text) {
        if (!this.isProtected(text)) {
            throw new IllegalArgumentException("Cannot decrypt obviously unprotected data");
        }
        byte[] data = new byte[text.length() / 2 - 1];
        for (int i = 1; i < text.length() - 1; i += 2) {
            String hex = text.substring(i, i + 2);
            int val = Integer.parseInt(hex, 16);
            data[i / 2] = (byte)val;
        }
        return data;
    }

    private static void clear(byte[] data) {
        if (data != null) {
            Arrays.fill(data, (byte)0);
        }
    }
}

