/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crypto.internal;

import java.security.Principal;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ACLUtils.class);

    public static Principal getPrincipal(Session session, String principalName) throws RepositoryException {
        JackrabbitSession jrSession = (JackrabbitSession)session;
        return jrSession.getPrincipalManager().getPrincipal(principalName);
    }

    public static void addACLEntry(Session session, String path, String principalName, String[] privileges, boolean allow) throws RepositoryException {
        AccessControlManager acm = session.getAccessControlManager();
        JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)path);
        if (acl != null) {
            Principal principal = ACLUtils.getPrincipal(session, principalName);
            Privilege[] privilegesArray = new Privilege[privileges.length];
            for (int i = 0; i < privilegesArray.length; ++i) {
                privilegesArray[i] = acm.privilegeFromName(privileges[i]);
            }
            LOG.debug("Adding ACE on {} for principal {} with {} privileges {}", new Object[]{path, principal, allow ? "allow" : "deny", privileges});
            acl.addEntry(principal, privilegesArray, allow);
            acm.setPolicy(path, (AccessControlPolicy)acl);
        }
    }

    public static void removeAllACLEntries(Session session, String path) throws RepositoryException {
        AccessControlManager acm = session.getAccessControlManager();
        JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)path);
        if (acl != null) {
            for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                LOG.debug("Removing ACE on {} for principal {} with privileges {}", new Object[]{path, ace.getPrincipal().getName(), ace.getPrivileges()});
                acl.removeAccessControlEntry(ace);
            }
            acm.setPolicy(path, (AccessControlPolicy)acl);
        }
    }
}

