/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crypto.internal;

import com.adobe.granite.crypto.internal.ACLUtils;
import com.adobe.granite.crypto.internal.CryptoSupportImpl;
import com.adobe.granite.crypto.internal.InternalClassLoaderWrapper;
import com.adobe.granite.crypto.internal.SecureDataWebConsolePlugin;
import com.adobe.granite.keystore.internal.GraniteSecurityProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.Security;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    static final String WEB_CONSOLE_LABEL = "crypto";
    private static final String JSAFE_CRYPTO_SUPPORT = "com.adobe.granite.crypto.internal.jsafe.JSafeCryptoSupport";
    private static final String REPO_SERVICE = "org.apache.sling.jcr.api.SlingRepository";
    private static final String keyPathParent = "/etc";
    private static final String keyPath = "/etc/key";
    private static final String keyProperty = "master";
    private static final String hmac_keyProperty = "hmac";
    private static final String keyPropertyPath = "/etc/key/master";
    private static final String hmac_keyPropertyPath = "/etc/key/hmac";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private BundleContext bundleContext;
    private CryptoSupportImpl cryptoSupportImpl;
    private ServiceRegistration configurationPlugin;
    private ServiceRegistration webConsolePlugin;
    private ServiceRegistration cryptoSupportService;
    private ClassLoader classLoader;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.log.info("Starting Crypto Support ({}, {})", new Object[]{context.getBundle().getSymbolicName(), context.getBundle().getHeaders().get("Bundle-Version")});
        InternalClassLoaderWrapper.init(this.bundleContext);
        this.classLoader = InternalClassLoaderWrapper.getInstance().getClassLoader();
        this.registerGraniteSecurityProvider();
        System.setProperty("com.rsa.crypto.default.random", "FIPS186PRNG");
        System.setProperty("com.rsa.cryptoj.jce.kat.strategy", "on.demand");
        ServiceListener listener = new ServiceListener(){
            private final AtomicInteger repositoryCounter = new AtomicInteger(0);

            public void serviceChanged(ServiceEvent event) {
                if (event.getType() == 1 && this.repositoryCounter.getAndIncrement() == 0) {
                    Activator.this.startCryptoSupport(event.getServiceReference());
                } else if (event.getType() == 4) {
                    this.repositoryCounter.decrementAndGet();
                }
            }
        };
        this.bundleContext.addServiceListener(listener, "(objectClass=org.apache.sling.jcr.api.SlingRepository)");
        ServiceReference repoService = this.bundleContext.getServiceReference(REPO_SERVICE);
        if (repoService != null) {
            listener.serviceChanged(new ServiceEvent(1, repoService));
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.configurationPlugin != null) {
            this.configurationPlugin.unregister();
            this.configurationPlugin = null;
        }
        this.stopCryptoSupport();
        this.bundleContext = null;
        this.unregisterGraniteSecurityProvider();
        System.clearProperty("com.rsa.crypto.default.random");
        System.clearProperty("com.rsa.cryptoj.jce.kat.strategy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCryptoSupport(ServiceReference repositoryRef) {
        SlingRepository repository = (SlingRepository)this.bundleContext.getService(repositoryRef);
        if (repository != null) {
            try {
                CryptoSupportImpl cryptoSupportImpl = this.getOrCreateCryptoSupport();
                this.loadOrCreateKey(repository, cryptoSupportImpl);
                this.moveTrustStoreIfNeeded(repository);
                if (this.cryptoSupportService == null) {
                    this.cryptoSupportService = this.bundleContext.registerService("com.adobe.granite.crypto.CryptoSupport", (Object)this.cryptoSupportImpl, null);
                }
                if (this.webConsolePlugin == null) {
                    SecureDataWebConsolePluginFactory consoleFactory = new SecureDataWebConsolePluginFactory();
                    Hashtable<String, String> consoleProps = new Hashtable<String, String>();
                    consoleProps.put("felix.webconsole.label", WEB_CONSOLE_LABEL);
                    this.webConsolePlugin = this.bundleContext.registerService("javax.servlet.Servlet", (Object)consoleFactory, consoleProps);
                }
            }
            catch (Exception e) {
                this.log.error("setupCryptoSupport: Failed creating CryptoSupport Implementation: ", (Throwable)e);
            }
            finally {
                this.bundleContext.ungetService(repositoryRef);
            }
        }
    }

    private void stopCryptoSupport() {
        if (this.webConsolePlugin != null) {
            this.webConsolePlugin.unregister();
            this.webConsolePlugin = null;
        }
        if (this.cryptoSupportImpl != null) {
            this.cryptoSupportImpl.dispose();
            this.cryptoSupportImpl = null;
        }
        if (this.cryptoSupportService != null) {
            this.cryptoSupportService.unregister();
            this.cryptoSupportService = null;
        }
    }

    private CryptoSupportImpl getOrCreateCryptoSupport() throws Exception {
        if (this.cryptoSupportImpl == null) {
            Class<?> cryptoImplClass = this.classLoader.loadClass(JSAFE_CRYPTO_SUPPORT);
            Constructor<?> cryptoImplConstructor = cryptoImplClass.getDeclaredConstructor(null);
            this.cryptoSupportImpl = (CryptoSupportImpl)cryptoImplConstructor.newInstance(null);
        }
        return this.cryptoSupportImpl;
    }

    private void registerGraniteSecurityProvider() throws Exception {
        this.unregisterGraniteSecurityProvider();
        int position = Security.insertProviderAt(GraniteSecurityProvider.getInstance(), 1);
        if (position != 1) {
            throw new Exception("Cannot add the Adobe Granite Security Provider at first position.");
        }
    }

    private void unregisterGraniteSecurityProvider() {
        Security.removeProvider("AdobeGraniteSecurityProvider");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOrCreateKey(SlingRepository repository, CryptoSupportImpl cryptoSupport) throws Exception {
        Session session = null;
        try {
            session = repository.loginAdministrative(null);
            byte[] key = this.readKey(session, keyPropertyPath);
            if (key == null) {
                key = cryptoSupport.init();
                this.writeKey(session, key, keyProperty);
            } else {
                cryptoSupport.init(key);
            }
            byte[] hmac_key = this.readKey(session, hmac_keyPropertyPath);
            if (hmac_key == null) {
                hmac_key = cryptoSupport.init_hmac();
                this.writeKey(session, hmac_key, hmac_keyProperty);
            } else {
                cryptoSupport.init_hmac(hmac_key);
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private static Node getOrCreateKeyNode(Session session) throws RepositoryException {
        if (session.nodeExists(keyPath)) {
            return session.getNode(keyPath);
        }
        if (!session.nodeExists(keyPathParent)) {
            session.getRootNode().addNode(keyPathParent.substring(1), "sling:Folder");
        }
        Node keyNode = session.getRootNode().addNode(keyPath.substring(1), "sling:Folder");
        keyNode.setProperty("hidden", true);
        return keyNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readKey(Session session, String propertyPath) throws Exception {
        if (session.propertyExists(propertyPath)) {
            Binary keyBinary = session.getProperty(propertyPath).getBinary();
            try {
                long size = keyBinary.getSize();
                if (size < Integer.MAX_VALUE) {
                    byte[] bytes = new byte[(int)size];
                    keyBinary.read(bytes, 0L);
                    byte[] byArray = bytes;
                    return byArray;
                }
                this.log.error("loadOrCreateKey: Cannot handle key property larger than Integer.MAX_SIZE bytes!");
            }
            finally {
                keyBinary.dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeKey(Session session, byte[] key, String property) throws Exception {
        Node keyNode = Activator.getOrCreateKeyNode(session);
        ByteArrayInputStream bin = new ByteArrayInputStream(key);
        Binary keyBinary = keyNode.getSession().getValueFactory().createBinary((InputStream)bin);
        try {
            keyNode.setProperty(property, keyBinary);
        }
        finally {
            keyBinary.dispose();
        }
        this.limitKeyAccess(session);
        session.save();
    }

    private void limitKeyAccess(Session session) throws RepositoryException {
        ACLUtils.removeAllACLEntries(session, keyPath);
        ACLUtils.addACLEntry(session, keyPath, "everyone", new String[]{"{http://www.jcp.org/jcr/1.0}all"}, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTrustStoreIfNeeded(SlingRepository repository) throws Exception {
        String oldLocation = "/etc/key/truststore.p12";
        String newLocation = "/etc/security/truststore.p12";
        Session session = null;
        try {
            session = repository.loginAdministrative(null);
            if (session.nodeExists(oldLocation)) {
                this.log.info("Detected truststore at {}", (Object)oldLocation);
                if (!session.nodeExists("/etc/security")) {
                    session.getNode(keyPathParent).addNode("security", "sling:Folder");
                }
                session.move(oldLocation, newLocation);
                this.log.info("Moved truststore to {}", (Object)newLocation);
                ACLUtils.removeAllACLEntries(session, newLocation);
                ACLUtils.addACLEntry(session, newLocation, "everyone", new String[]{"{http://www.jcp.org/jcr/1.0}all"}, false);
                ACLUtils.addACLEntry(session, newLocation, "administrators", new String[]{"{http://www.jcp.org/jcr/1.0}all"}, true);
                ACLUtils.addACLEntry(session, newLocation, "everyone", new String[]{"{http://www.jcp.org/jcr/1.0}read"}, true);
                this.limitKeyAccess(session);
                session.save();
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public class SecureDataWebConsolePluginFactory
    implements ServiceFactory {
        public Object getService(Bundle bundle, ServiceRegistration registration) {
            return new SecureDataWebConsolePlugin(Activator.this.cryptoSupportImpl);
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

