/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crypto.internal;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.ModificationType;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(specVersion="1.1")
@Service
public class EncryptionPostProcessor
implements SlingPostProcessor {
    private static final String SUFFIX_ENCRYPTED = "@Encrypted";
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    @Reference
    private CryptoSupport cryptoSupport;

    void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        String basePath = this.getBasePath(request, changes);
        Set<String> propsToEncrypt = this.getPropertiesWithSuffix(request, basePath, SUFFIX_ENCRYPTED);
        if (propsToEncrypt.isEmpty()) {
            return;
        }
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        ArrayList<Modification> modsToRemove = new ArrayList<Modification>();
        for (Modification mod : changes) {
            switch (mod.getType()) {
                case ORDER: 
                case MOVE: 
                case COPY: 
                case CREATE: 
                case MODIFY: {
                    String source = mod.getSource();
                    if (source.endsWith(SUFFIX_ENCRYPTED)) {
                        if (!session.propertyExists(source)) break;
                        session.getProperty(source).remove();
                        modsToRemove.add(mod);
                        break;
                    }
                    if (!propsToEncrypt.contains(source) || !session.propertyExists(source)) break;
                    this.encryptProperty(session.getProperty(source));
                }
            }
        }
        changes.removeAll(modsToRemove);
    }

    private void encryptProperty(Property property) throws RepositoryException {
        String propVal = property.getString();
        if (!this.cryptoSupport.isProtected(propVal)) {
            try {
                property.setValue(this.cryptoSupport.protect(propVal));
            }
            catch (CryptoException e) {
                this.log.error("Error on protecting property value", (Throwable)e);
            }
        }
    }

    private String getBasePath(SlingHttpServletRequest request, List<Modification> changes) {
        Resource resource = request.getResource();
        String basePath = resource.getPath();
        if (basePath.endsWith("/*")) {
            basePath = StringUtils.removeEnd((String)basePath, (String)"/*");
        }
        if (this.isNewResource(request)) {
            for (Modification mod : changes) {
                if (mod.getType() != ModificationType.CREATE) continue;
                String source = mod.getSource();
                if (source == null || !source.startsWith(basePath)) break;
                basePath = mod.getSource();
                break;
            }
        }
        return basePath;
    }

    private boolean isNewResource(SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        String suffix = ResourceUtil.isSyntheticResource((Resource)resource) ? resource.getPath() : request.getRequestPathInfo().getSuffix();
        if (suffix == null) {
            return false;
        }
        return suffix.endsWith("/") || suffix.endsWith("/*");
    }

    private Set<String> getPropertiesWithSuffix(SlingHttpServletRequest request, String basePath, String suffix) {
        HashSet<String> props = new HashSet<String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String property;
            String param = (String)e.nextElement();
            if (!param.endsWith(suffix) || request.getParameter(property = StringUtils.removeEnd((String)param, (String)suffix)) == null) continue;
            props.add(this.toAbsolutePath(basePath, property));
        }
        return props;
    }

    private String toAbsolutePath(String basePath, String path) {
        if (path.startsWith("/")) {
            return ResourceUtil.normalize((String)path);
        }
        return ResourceUtil.normalize((String)(basePath + '/' + path));
    }
}

