/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crypto.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyClassLoader
extends ClassLoader {
    private static final String PACKAGE_COM_RSA = "com.rsa";
    private static final String PREFIX_CLASS_COM_RSA = "com.rsa.";
    private static final String PREFIX_RESOURCE_COM_RSA = "com.rsa.".replace('.', '/');
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ClassLoader delegatee;

    public ProxyClassLoader(ClassLoader delegatee) {
        this.delegatee = delegatee;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.isRsaClass(name)) {
            this.log.debug("loadClass: Not loading class {} through parent class loader", (Object)name);
            throw new ClassNotFoundException(name);
        }
        try {
            Class<?> c = this.delegatee.loadClass(name);
            this.log.debug("loadClass: Loaded class {} through parent class loader", (Object)name);
            return c;
        }
        catch (ClassNotFoundException cnfe) {
            this.log.debug("loadClass: Class {} not found through parent class loader", (Object)name);
            throw cnfe;
        }
        catch (Throwable t) {
            this.log.debug("loadClass: Error loading class " + name + " through parent class loader", t);
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IllegalStateException("Unexpected failure: " + t, t);
        }
    }

    @Override
    public URL getResource(String name) {
        if (this.isRsaResource(name)) {
            this.log.debug("getResource({}) --> null (forced from internal)", (Object)name);
            return null;
        }
        URL res = super.getResource(name);
        this.log.debug("getResource({}) --> {}", (Object)name, (Object)res);
        return res;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isRsaResource(name)) {
            this.log.debug("getResources({}) --> empty (forced from internal)", (Object)name);
            return Collections.enumeration(Collections.emptyList());
        }
        Enumeration<URL> res = super.getResources(name);
        this.log.debug("getResources({}) --> {} ({})", new Object[]{name, res, res.hasMoreElements() ? "has resources" : "empty"});
        return res;
    }

    @Override
    protected Package getPackage(String name) {
        if (this.isRsaPackage(name)) {
            this.log.debug("getPackage({}) --> null (forced from internal)", (Object)name);
            return null;
        }
        Package res = super.getPackage(name);
        this.log.debug("getPackage({}) --> {}", new Object[]{name, res});
        return res;
    }

    @Override
    protected Package[] getPackages() {
        Package[] res = super.getPackages();
        this.log.debug("getPackages() --> {} packages", (Object)res.length);
        for (Package tstPkg : res) {
            if (!this.isRsaPackage(tstPkg.getName())) continue;
            ArrayList<Package> pkgList = new ArrayList<Package>(res.length);
            for (Package pkg : pkgList) {
                if (!this.isRsaPackage(pkg.getName())) {
                    this.log.debug("getPackages() --> add {}", (Object)pkg);
                    pkgList.add(pkg);
                    continue;
                }
                this.log.debug("getPackages() --> remove {}", (Object)pkg);
            }
            res = pkgList.toArray(new Package[pkgList.size()]);
            break;
        }
        this.log.debug("getPackages() --> {} packages", (Object)res.length);
        return res;
    }

    private boolean isRsaClass(String className) {
        return className.startsWith(PREFIX_CLASS_COM_RSA);
    }

    private boolean isRsaResource(String resName) {
        return resName.startsWith(PREFIX_RESOURCE_COM_RSA);
    }

    private boolean isRsaPackage(String pkgName) {
        return pkgName.startsWith(PREFIX_CLASS_COM_RSA) || pkgName.equals(PACKAGE_COM_RSA);
    }
}

