/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crypto.internal;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.internal.CryptoSupportImpl;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.VariableResolver;
import org.apache.felix.webconsole.WebConsoleUtil;

public class SecureDataWebConsolePlugin
extends AbstractWebConsolePlugin {
    private static final long serialVersionUID = 1L;
    private static final String PAR_PLAIN = "datum";
    private static final String PAR_PROTECTED = "protected";
    private final CryptoSupportImpl cryptoSupport;

    SecureDataWebConsolePlugin(CryptoSupportImpl cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    public String getLabel() {
        return "crypto";
    }

    public String getTitle() {
        return "Crypto Support";
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws IOException {
        PrintWriter pw = res.getWriter();
        pw.println("<p class=\"statline ui-state-highlight\">Use this form to prepare protection of sensitive data in configurations</p>");
        pw.println("<form method=\"POST\">");
        pw.println("<table class=\"nicetable ui-widget\">");
        pw.println("<tr>");
        pw.println("<th colspan=\"3\" class=\"ui-widget-header\">Protect Plain Text Strings</td>");
        pw.println("</tr>");
        pw.println("<tr>");
        pw.println("<td>Plain&nbsp;Text</td>");
        pw.println("<td style=\"width:100%;\">");
        pw.println("<input style=\"width:100%;\" type=\"password\" name=\"datum\" value=\"${datum}\">");
        pw.println("</td>");
        pw.println("<td><input type=\"submit\" value=\"Protect\"></td>");
        pw.println("</tr>");
        pw.println("<tr>");
        pw.println("<td>Protected&nbsp;Text</td>");
        pw.println("<td style=\"width:100%;\" colspan=\"2\">");
        pw.println("<input style=\"width:100%;\" type=\"text\" value=\"${protected}\" readOnly>");
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("</table>");
        pw.println("</form>");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String datum = WebConsoleUtil.getParameter((HttpServletRequest)req, (String)PAR_PLAIN);
        String protectedDatum = "";
        if (datum != null) {
            try {
                protectedDatum = this.cryptoSupport.protect(datum);
            }
            catch (CryptoException ce) {
                protectedDatum = "Cannot protect plain text: " + ce;
            }
        }
        if (req.getRequestURI().endsWith(".json")) {
            resp.setContentType("application/json");
            resp.setCharacterEncoding("UTF-8");
            resp.getWriter().printf("{\"%s\": \"%s\"}", PAR_PROTECTED, protectedDatum);
        } else {
            VariableResolver vr = WebConsoleUtil.getVariableResolver((ServletRequest)req);
            if (vr instanceof DefaultVariableResolver) {
                DefaultVariableResolver dvr = (DefaultVariableResolver)vr;
                dvr.put((Object)PAR_PLAIN, (Object)datum);
                dvr.put((Object)PAR_PROTECTED, (Object)protectedDatum);
            }
            this.doGet(req, resp);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        VariableResolver vr = WebConsoleUtil.getVariableResolver((ServletRequest)req);
        if (vr instanceof DefaultVariableResolver) {
            DefaultVariableResolver dvr = (DefaultVariableResolver)vr;
            dvr.put((Object)PAR_PLAIN, (Object)"");
            dvr.put((Object)PAR_PROTECTED, (Object)"");
        }
        super.service(req, resp);
    }
}

