/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.keystore.internal;

import com.adobe.granite.crypto.internal.InternalClassLoaderWrapper;
import java.lang.reflect.Constructor;
import java.security.Provider;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraniteSecurityProvider
extends Provider {
    public static final String BASE_PROVIDER_NAME = "AdobeGraniteSecurityProvider";
    public static final String PROVIDER_INFO = "Adobe Granite Security Provider";
    public static final String PKCS12 = "PKCS12";
    public static final String X509 = "X.509";
    public static final String RSA = "RSA";
    private static final Logger LOG = LoggerFactory.getLogger(GraniteSecurityProvider.class);
    private static final Set<String> jsafeServices = new HashSet<String>(197);
    private static final String JSAFE_PROVIDER = "com.rsa.jsafe.provider.JsafeJCE";
    private Provider jsafeJCEProvider;
    private static volatile GraniteSecurityProvider instance;

    private GraniteSecurityProvider() {
        super(BASE_PROVIDER_NAME, 1.0, PROVIDER_INFO);
        this.putService(new Provider.Service(this, "CertPathValidator", "PKIX", "PKIX", null, null));
        this.putService(new Provider.Service(this, "KeyStore", PKCS12, PKCS12, null, null));
        this.putService(new Provider.Service(this, "CertificateFactory", X509, X509, null, null));
        this.putService(new Provider.Service(this, "KeyFactory", RSA, RSA, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GraniteSecurityProvider getInstance() {
        if (instance != null) return instance;
        Class<GraniteSecurityProvider> clazz = GraniteSecurityProvider.class;
        synchronized (GraniteSecurityProvider.class) {
            if (instance != null) return instance;
            instance = new GraniteSecurityProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public synchronized Provider.Service getService(String type, String algorithm) {
        Provider.Service service = null;
        if (type != null && algorithm != null && jsafeServices.contains(type + "|" + algorithm) && ("CertPathValidator".equals(type) && "PKIX".equals(algorithm) || "KeyStore".equals(type) && PKCS12.equals(algorithm) || "CertificateFactory".equals(type) && X509.equals(algorithm))) {
            if (this.jsafeJCEProvider == null) {
                try {
                    ClassLoader classLoader = InternalClassLoaderWrapper.getInstance().getClassLoader();
                    Class<?> jsafeJCEProviderClass = classLoader.loadClass(JSAFE_PROVIDER);
                    Constructor<?> jsafeJCEProviderConstructor = jsafeJCEProviderClass.getDeclaredConstructor(null);
                    this.jsafeJCEProvider = (Provider)jsafeJCEProviderConstructor.newInstance(null);
                }
                catch (Exception E) {
                    LOG.error("Cannot access com.rsa.jsafe.provider.JsafeJCE");
                }
            }
            service = this.jsafeJCEProvider.getService(type, algorithm);
        }
        return service;
    }

    static {
        jsafeServices.add("MessageDigest|MD5");
        jsafeServices.add("MessageDigest|MD2");
        jsafeServices.add("MessageDigest|RIPEMD160");
        jsafeServices.add("MessageDigest|SHA1");
        jsafeServices.add("MessageDigest|SHA224");
        jsafeServices.add("MessageDigest|SHA256");
        jsafeServices.add("MessageDigest|SHA384");
        jsafeServices.add("MessageDigest|SHA512");
        jsafeServices.add("KeyAgreement|DiffieHellman");
        jsafeServices.add("KeyAgreement|ECDH");
        jsafeServices.add("KeyAgreement|ECDHC");
        jsafeServices.add("KeyFactory|RSA");
        jsafeServices.add("KeyFactory|DSA");
        jsafeServices.add("KeyFactory|DiffieHellman");
        jsafeServices.add("KeyFactory|EC");
        jsafeServices.add("KeyPairGenerator|RSA");
        jsafeServices.add("KeyPairGenerator|DiffieHellman");
        jsafeServices.add("KeyPairGenerator|DSA");
        jsafeServices.add("KeyPairGenerator|EC");
        jsafeServices.add("KeyGenerator|AES");
        jsafeServices.add("KeyGenerator|DES");
        jsafeServices.add("KeyGenerator|DESX");
        jsafeServices.add("KeyGenerator|DESede");
        jsafeServices.add("KeyGenerator|HmacMD5");
        jsafeServices.add("KeyGenerator|HmacSHA1");
        jsafeServices.add("KeyGenerator|HmacSHA224");
        jsafeServices.add("KeyGenerator|HmacSHA256");
        jsafeServices.add("KeyGenerator|HmacSHA384");
        jsafeServices.add("KeyGenerator|HmacSHA512");
        jsafeServices.add("KeyGenerator|RC2");
        jsafeServices.add("KeyGenerator|RC4");
        jsafeServices.add("KeyGenerator|RC5");
        jsafeServices.add("KeyGenerator|SunTlsPrf");
        jsafeServices.add("KeyGenerator|SunTlsRsaPremasterSecret");
        jsafeServices.add("KeyGenerator|SunTlsMasterSecret");
        jsafeServices.add("KeyGenerator|SunTlsKeyMaterial");
        jsafeServices.add("SecretKeyFactory|AES");
        jsafeServices.add("SecretKeyFactory|DES");
        jsafeServices.add("SecretKeyFactory|DESX");
        jsafeServices.add("SecretKeyFactory|DESede");
        jsafeServices.add("SecretKeyFactory|HmacMD5");
        jsafeServices.add("SecretKeyFactory|HmacSHA1");
        jsafeServices.add("SecretKeyFactory|HmacSHA224");
        jsafeServices.add("SecretKeyFactory|HmacSHA256");
        jsafeServices.add("SecretKeyFactory|HmacSHA384");
        jsafeServices.add("SecretKeyFactory|HmacSHA512");
        jsafeServices.add("SecretKeyFactory|Hmac");
        jsafeServices.add("SecretKeyFactory|RC2");
        jsafeServices.add("SecretKeyFactory|RC4");
        jsafeServices.add("SecretKeyFactory|RC5");
        jsafeServices.add("SecretKeyFactory|PBEWithMD5AndDES");
        jsafeServices.add("SecretKeyFactory|PBEWithSHA1AndRC2");
        jsafeServices.add("SecretKeyFactory|PKCS12PBE");
        jsafeServices.add("SecretKeyFactory|PBM");
        jsafeServices.add("SecretKeyFactory|PKCS12PBEWithSHA1AndRC2");
        jsafeServices.add("SecretKeyFactory|PBEWithSHA1AndDES");
        jsafeServices.add("SecretKeyFactory|PBEWithHmacSHA1AndDESede");
        jsafeServices.add("SecretKeyFactory|PBKDF2WithSHA1");
        jsafeServices.add("SecretKeyFactory|PBKDF2WithSHA224");
        jsafeServices.add("SecretKeyFactory|PBKDF2WithSHA256");
        jsafeServices.add("SecretKeyFactory|PBKDF2WithSHA384");
        jsafeServices.add("SecretKeyFactory|PBKDF2WithSHA512");
        jsafeServices.add("AlgorithmParameters|AES");
        jsafeServices.add("AlgorithmParameters|RC2");
        jsafeServices.add("AlgorithmParameters|RC5");
        jsafeServices.add("AlgorithmParameters|PBE");
        jsafeServices.add("AlgorithmParameters|PSS");
        jsafeServices.add("AlgorithmParameters|IV");
        jsafeServices.add("AlgorithmParameters|GCM");
        jsafeServices.add("AlgorithmParameters|CCM");
        jsafeServices.add("AlgorithmParameters|XTS");
        jsafeServices.add("AlgorithmParameters|DiffieHellman");
        jsafeServices.add("AlgorithmParameters|X942DH");
        jsafeServices.add("AlgorithmParameters|ECIES");
        jsafeServices.add("AlgorithmParameters|DSA");
        jsafeServices.add("AlgorithmParameters|EC");
        jsafeServices.add("AlgorithmParameterGenerator|DiffieHellman");
        jsafeServices.add("AlgorithmParameterGenerator|X942DiffieHellman");
        jsafeServices.add("AlgorithmParameterGenerator|DSA");
        jsafeServices.add("AlgorithmParameterGenerator|EC");
        jsafeServices.add("Cipher|AES");
        jsafeServices.add("Cipher|AESKeyWrapRFC3394");
        jsafeServices.add("Cipher|AESKeyWrapRFC5649");
        jsafeServices.add("Cipher|DES");
        jsafeServices.add("Cipher|DESX");
        jsafeServices.add("Cipher|DESede");
        jsafeServices.add("Cipher|RC2");
        jsafeServices.add("Cipher|RC4");
        jsafeServices.add("Cipher|RC5");
        jsafeServices.add("Cipher|PBEWithMD5AndDES");
        jsafeServices.add("Cipher|PBEWithSHA1AndDES");
        jsafeServices.add("Cipher|PBEWithSHA1AndRC2");
        jsafeServices.add("Cipher|PBEWithHmacSHA1AndDESede");
        jsafeServices.add("Cipher|PKCS12PBEWithSHA1AndRC2");
        jsafeServices.add("Cipher|PKCS12PBEWithSHA1And2keyDESede");
        jsafeServices.add("Cipher|PKCS12PBEWithSHA1And3keyDESede");
        jsafeServices.add("Cipher|PKCS12PBEWithSHA1AndRC2_128");
        jsafeServices.add("Cipher|PKCS12PBEWithSHA1AndRC2_40");
        jsafeServices.add("Cipher|PKCS12PBEWithSHA1AndRC4_128");
        jsafeServices.add("Cipher|PKCS12PBEWithSHA1AndRC4_40");
        jsafeServices.add("Cipher|RSA/ECB/OAEPWithSHA1AndMGF1Padding");
        jsafeServices.add("Cipher|RSA/ECB/OAEPWithSHA224AndMGF1Padding");
        jsafeServices.add("Cipher|RSA/ECB/OAEPWithSHA256AndMGF1Padding");
        jsafeServices.add("Cipher|RSA/ECB/OAEPWithSHA384AndMGF1Padding");
        jsafeServices.add("Cipher|RSA/ECB/OAEPWithSHA512AndMGF1Padding");
        jsafeServices.add("Cipher|RSA");
        jsafeServices.add("Cipher|RSAWithNoPad");
        jsafeServices.add("Cipher|RSAWithPKCS1BlockSSLPad");
        jsafeServices.add("Cipher|RSA/NONE/NoPadding");
        jsafeServices.add("Cipher|RSA/ECB/NoPadding");
        jsafeServices.add("Cipher|RSA/NONE/PKCS1Padding");
        jsafeServices.add("Cipher|RSA/ECB/PKCS1Padding");
        jsafeServices.add("Cipher|ECIESwithXOR");
        jsafeServices.add("Cipher|ECIESwithAES128");
        jsafeServices.add("Cipher|ECIESwithAES192");
        jsafeServices.add("Cipher|ECIESwithAES256");
        jsafeServices.add("Cipher|ECIESwithDESede");
        jsafeServices.add("Mac|HmacMD5");
        jsafeServices.add("Mac|HmacSHA1");
        jsafeServices.add("Mac|HmacSHA224");
        jsafeServices.add("Mac|HmacSHA256");
        jsafeServices.add("Mac|HmacSHA384");
        jsafeServices.add("Mac|HmacSHA512");
        jsafeServices.add("Mac|HmacRIPEMD160");
        jsafeServices.add("Mac|HmacPKCS12PBESHA1");
        jsafeServices.add("Mac|PBMHmacSHA1");
        jsafeServices.add("Mac|SslMacMD5");
        jsafeServices.add("Mac|SslMacSHA1");
        jsafeServices.add("Signature|NONEwithRSA");
        jsafeServices.add("Signature|MD2/RSA");
        jsafeServices.add("Signature|MD5/RSA");
        jsafeServices.add("Signature|SHA1/RSA");
        jsafeServices.add("Signature|SHA1withX931RSA");
        jsafeServices.add("Signature|MD5andSHA1withRSA");
        jsafeServices.add("Signature|SHA1withRSAandMGF1");
        jsafeServices.add("Signature|SHA224withRSAandMGF1");
        jsafeServices.add("Signature|SHA256withRSAandMGF1");
        jsafeServices.add("Signature|SHA384withRSAandMGF1");
        jsafeServices.add("Signature|SHA512withRSAandMGF1");
        jsafeServices.add("Signature|NONEwithRSAPSSwithSHA1");
        jsafeServices.add("Signature|NONEwithRSAPSSwithSHA224");
        jsafeServices.add("Signature|NONEwithRSAPSSwithSHA256");
        jsafeServices.add("Signature|NONEwithRSAPSSwithSHA384");
        jsafeServices.add("Signature|NONEwithRSAPSSwithSHA512");
        jsafeServices.add("Signature|SHA224/RSA");
        jsafeServices.add("Signature|SHA256/RSA");
        jsafeServices.add("Signature|SHA384/RSA");
        jsafeServices.add("Signature|SHA512/RSA");
        jsafeServices.add("Signature|NONEwithDSA");
        jsafeServices.add("Signature|SHA1/DSA");
        jsafeServices.add("Signature|SHA224/DSA");
        jsafeServices.add("Signature|SHA256/DSA");
        jsafeServices.add("Signature|SHA384/DSA");
        jsafeServices.add("Signature|SHA512/DSA");
        jsafeServices.add("Signature|NONEwithECDSA");
        jsafeServices.add("Signature|RawWithECDSA");
        jsafeServices.add("Signature|SHA1/ECDSA");
        jsafeServices.add("Signature|SHA224/ECDSA");
        jsafeServices.add("Signature|SHA256/ECDSA");
        jsafeServices.add("Signature|SHA384/ECDSA");
        jsafeServices.add("Signature|SHA512/ECDSA");
        jsafeServices.add("SecureRandom|FIPS186PRNG");
        jsafeServices.add("SecureRandom|FIPS186PRNGXChangeNotice");
        jsafeServices.add("SecureRandom|FIPS186PRNGXChangeNoticeGeneral");
        jsafeServices.add("SecureRandom|FIPS186_PRNG");
        jsafeServices.add("SecureRandom|MD5PRNG");
        jsafeServices.add("SecureRandom|SHA1PRNG");
        jsafeServices.add("SecureRandom|OBFPRNG");
        jsafeServices.add("SecureRandom|HMACDRBG");
        jsafeServices.add("SecureRandom|HMACDRBG128");
        jsafeServices.add("SecureRandom|HMACDRBG192");
        jsafeServices.add("SecureRandom|HMACDRBG256");
        jsafeServices.add("SecureRandom|ECDRBG");
        jsafeServices.add("SecureRandom|ECDRBG128");
        jsafeServices.add("SecureRandom|ECDRBG192");
        jsafeServices.add("SecureRandom|ECDRBG256");
        jsafeServices.add("SecureRandom|SeederPRNG");
        jsafeServices.add("KeyPairGenerator|DSAWithPKCS11");
        jsafeServices.add("KeyPairGenerator|RSAWithPKCS11");
        jsafeServices.add("Cipher|RSAWithPKCS11");
        jsafeServices.add("Signature|SHA1withRSAandPKCS11");
        jsafeServices.add("Signature|NONEwithRSAandPKCS11");
        jsafeServices.add("Signature|SHA1withDSAandPKCS11");
        jsafeServices.add("KeyStore|PKCS12");
        jsafeServices.add("KeyStore|PKCS12Compat");
        jsafeServices.add("KeyStore|PKCS15");
        jsafeServices.add("CertificateFactory|X.509");
        jsafeServices.add("CertStore|Collection");
        jsafeServices.add("CertStore|LDAP");
        jsafeServices.add("CertPathValidator|PKIX");
        jsafeServices.add("CertPathValidator|PKIX-SuiteB");
        jsafeServices.add("CertPathValidator|PKIX-SuiteBTLS");
        jsafeServices.add("CertPathValidator|X.509V1");
        jsafeServices.add("CertPathBuilder|PKIX");
        jsafeServices.add("CertPathBuilder|PKIX-SuiteB");
        jsafeServices.add("CertPathBuilder|PKIX-SuiteBTLS");
        jsafeServices.add("CertPathBuilder|X.509V1");
    }
}

