/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.keystore.internal;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.adobe.granite.crypto.internal.ACLUtils;
import com.adobe.granite.keystore.KeyStoreNotInitialisedException;
import com.adobe.granite.keystore.KeyStoreService;
import com.adobe.granite.keystore.internal.GraniteKeyStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Enumeration;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.x500.X500Principal;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.SlingIOException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

@Component(metatype=true)
@Service(value={KeyStoreService.class})
public class KeyStoreServiceImpl
implements KeyStoreService {
    public static final String USER_KEYSTORE_FOLDER = "keystore";
    public static final String USER_KEYSTORE = "store.p12";
    public static final String TEMP_USER_KEYSTORE = "store.p12.tmp";
    public static final String TRUST_STORE = "/etc/security/truststore.p12";
    public static final String TEMP_TRUSTSTORE = "/etc/security/truststore.p12.tmp";
    public static final String JCR_PROP_KEYSTORE_PASSWORD = "keystorePassword";
    private static final char CHAR_DEFAULT = '\u0000';
    @Reference
    private CryptoSupport cryptoSupport = null;

    @Override
    public KeyManager getKeyManager(ResourceResolver resolver) throws SlingIOException, SecurityException, KeyStoreNotInitialisedException {
        KeyManager keyManager;
        block4: {
            keyManager = null;
            KeyStore keyStore = this.getKeyStore(resolver);
            try {
                KeyManager[] keyManagers;
                User user = (User)resolver.adaptTo(User.class);
                if (user == null) break block4;
                String keyStorePath = KeyStoreServiceImpl.getKeyStorePathForUser(user, USER_KEYSTORE);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keyStore, KeyStoreServiceImpl.extractStorePassword(resolver, keyStorePath, this.cryptoSupport));
                for (KeyManager km : keyManagers = kmf.getKeyManagers()) {
                    if (!(km instanceof X509KeyManager)) continue;
                    keyManager = km;
                    break;
                }
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SecurityException(e);
            }
        }
        return keyManager;
    }

    @Override
    public KeyStore getKeyStore(ResourceResolver resolver) throws SlingIOException, SecurityException, KeyStoreNotInitialisedException {
        return this.getKeyStore(resolver, resolver.getUserID());
    }

    @Override
    public KeyStore getKeyStore(ResourceResolver resolver, String userId) throws SlingIOException, SecurityException, KeyStoreNotInitialisedException {
        return this.internalGetKeyStore((ResourceResolver)resolver, (String)userId).keyStore;
    }

    @Override
    public TrustManager getTrustManager(ResourceResolver resolver) throws SlingIOException, SecurityException, KeyStoreNotInitialisedException {
        TrustManager trustManager = null;
        KeyStore trustStore = this.getTrustStore(resolver);
        if (trustStore != null) {
            try {
                TrustManager[] trustManagers;
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(trustStore);
                for (TrustManager tm : trustManagers = tmf.getTrustManagers()) {
                    if (!(tm instanceof X509TrustManager)) continue;
                    trustManager = tm;
                    break;
                }
            }
            catch (Exception e) {
                throw new SecurityException(e);
            }
        }
        return trustManager;
    }

    @Override
    public KeyStore getTrustStore(ResourceResolver resolver) throws SlingIOException, SecurityException, IllegalArgumentException, KeyStoreNotInitialisedException {
        return this.internalGetTrustStore((ResourceResolver)resolver).keyStore;
    }

    @Override
    public void changeKeyStorePassword(ResourceResolver resolver, String userId, char[] currentPassword, char[] newPassword) throws SlingIOException, SecurityException, KeyStoreNotInitialisedException {
        block12: {
            User user = KeyStoreServiceImpl.retrieveUser(resolver, userId);
            String keyStorePath = KeyStoreServiceImpl.getKeyStorePathForUser(user, USER_KEYSTORE);
            Resource storeResource = resolver.getResource(keyStorePath);
            if (storeResource != null) {
                char[] storePassword = KeyStoreServiceImpl.extractStorePassword(resolver, keyStorePath, this.cryptoSupport);
                try {
                    if (Arrays.equals(currentPassword, storePassword)) {
                        KeyStore keyStore = this.getKeyStore(resolver, userId);
                        String tmpKeyStorePath = KeyStoreServiceImpl.getKeyStorePathForUser(user, TEMP_USER_KEYSTORE);
                        Resource tmpStoreResource = this.createKeyStoreResource(resolver, tmpKeyStorePath, newPassword);
                        if (tmpStoreResource != null) {
                            Node tmpStoreParent = (Node)tmpStoreResource.getParent().adaptTo(Node.class);
                            tmpStoreParent.setProperty(JCR_PROP_KEYSTORE_PASSWORD, this.cryptoSupport.protect(new String(newPassword)));
                            GraniteKeyStore newKeyStore = new GraniteKeyStore(tmpStoreResource, KeyStore.getInstance("PKCS12", "AdobeGraniteSecurityProvider"), this.cryptoSupport.protect(new String(newPassword)), this.cryptoSupport);
                            Enumeration<String> aliases = keyStore.aliases();
                            while (aliases.hasMoreElements()) {
                                String alias = aliases.nextElement();
                                KeyStore.Entry entry = keyStore.getEntry(alias, new KeyStore.PasswordProtection(currentPassword));
                                if (entry instanceof KeyStore.PrivateKeyEntry) {
                                    KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)entry;
                                    Certificate[] chain = pkEntry.getCertificateChain();
                                    newKeyStore.setKeyEntry(alias, pkEntry.getPrivateKey(), newPassword, chain);
                                    continue;
                                }
                                if (!(entry instanceof KeyStore.TrustedCertificateEntry)) continue;
                                newKeyStore.setCertificateEntry(alias, ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate());
                            }
                            Session session = (Session)resolver.adaptTo(Session.class);
                            session.removeItem(keyStorePath);
                            session.save();
                            session.move(tmpKeyStorePath, keyStorePath);
                            session.save();
                        }
                        break block12;
                    }
                    throw new SecurityException("The provided current password does not match the keystore's password.");
                }
                catch (AccessDeniedException e) {
                    throw new SecurityException(e);
                }
                catch (RepositoryException e) {
                    throw new SlingIOException(new IOException(e));
                }
                catch (Exception e) {
                    throw new SecurityException(e);
                }
                finally {
                    KeyStoreServiceImpl.reset(storePassword);
                }
            }
        }
    }

    @Override
    public void changeTrustStorePassword(ResourceResolver resolver, char[] currentPassword, char[] newPassword) throws KeyStoreNotInitialisedException {
        block11: {
            Resource storeResource = resolver.getResource(TRUST_STORE);
            if (storeResource != null) {
                char[] storePassword = KeyStoreServiceImpl.extractStorePassword(resolver, TRUST_STORE, this.cryptoSupport);
                try {
                    if (Arrays.equals(currentPassword, storePassword)) {
                        KeyStore trustStore = this.getTrustStore(resolver);
                        Resource tmpStoreResource = this.createKeyStoreResource(resolver, TEMP_TRUSTSTORE, newPassword);
                        if (tmpStoreResource != null) {
                            Node tmpStoreParent = (Node)tmpStoreResource.getParent().adaptTo(Node.class);
                            tmpStoreParent.setProperty(JCR_PROP_KEYSTORE_PASSWORD, this.cryptoSupport.protect(new String(newPassword)));
                            GraniteKeyStore newTrustStore = new GraniteKeyStore(tmpStoreResource, KeyStore.getInstance("PKCS12", "AdobeGraniteSecurityProvider"), this.cryptoSupport.protect(new String(newPassword)), this.cryptoSupport);
                            Enumeration<String> aliases = trustStore.aliases();
                            while (aliases.hasMoreElements()) {
                                String alias = aliases.nextElement();
                                KeyStore.Entry entry = trustStore.getEntry(alias, new KeyStore.PasswordProtection(currentPassword));
                                if (!(entry instanceof KeyStore.TrustedCertificateEntry)) continue;
                                newTrustStore.setCertificateEntry(alias, ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate());
                            }
                            Session session = (Session)resolver.adaptTo(Session.class);
                            session.removeItem(TRUST_STORE);
                            session.save();
                            session.move(TEMP_TRUSTSTORE, TRUST_STORE);
                            session.save();
                        }
                        break block11;
                    }
                    throw new SecurityException("The provided current password does not match the truststore's password.");
                }
                catch (AccessDeniedException e) {
                    throw new SecurityException(e);
                }
                catch (RepositoryException e) {
                    throw new SlingIOException(new IOException(e));
                }
                catch (Exception e) {
                    throw new SecurityException(e);
                }
                finally {
                    KeyStoreServiceImpl.reset(storePassword);
                }
            }
        }
    }

    @Override
    public void addKeyStoreKeyPair(ResourceResolver resolver, String userId, KeyPair keyPair, String alias) throws SlingIOException, SecurityException, KeyStoreNotInitialisedException {
        if (resolver == null || userId == null || keyPair == null || alias == null) {
            throw new IllegalArgumentException();
        }
        KeyStoreTuple keyStoreTuple = this.internalGetKeyStore(resolver, userId);
        try {
            this.setKeyPair(keyStoreTuple.keyStore, keyPair, alias, keyStoreTuple.password);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
        finally {
            keyStoreTuple.clear();
        }
    }

    @Override
    public KeyPair getKeyStoreKeyPair(ResourceResolver resolver, String userId, String alias) throws SlingIOException, SecurityException, KeyStoreNotInitialisedException {
        if (resolver == null || userId == null || alias == null) {
            throw new IllegalArgumentException();
        }
        KeyStoreTuple keyStoreTuple = this.internalGetKeyStore(resolver, userId);
        try {
            KeyPair keyPair = this.getKeyPair(keyStoreTuple.keyStore, alias, keyStoreTuple.getPasswordProtection());
            return keyPair;
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
        finally {
            keyStoreTuple.clear();
        }
    }

    @Override
    public KeyStore createKeyStore(ResourceResolver resolver, String userId, char[] password) throws SlingIOException, SecurityException, IllegalArgumentException {
        if (resolver == null) {
            throw new IllegalArgumentException("Cannot create a key store with a null resource resolver.");
        }
        if (userId == null || userId.length() == 0) {
            throw new IllegalArgumentException("Cannot create a key store for an empty userId.");
        }
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException("Cannot create a key store with an empty password.");
        }
        User user = KeyStoreServiceImpl.retrieveUser(resolver, userId);
        String expectedKeyStorePath = KeyStoreServiceImpl.getKeyStorePathForUser(user, USER_KEYSTORE);
        try {
            Resource keyStoreResource = this.createKeyStoreResource(resolver, expectedKeyStorePath, password);
            if (keyStoreResource == null) {
                throw new IOException("Cannot create key store for user " + userId);
            }
            return new GraniteKeyStore(keyStoreResource, KeyStore.getInstance("PKCS12", "AdobeGraniteSecurityProvider"), this.cryptoSupport.protect(new String(password)), this.cryptoSupport);
        }
        catch (UnsupportedEncodingException e) {
            throw new SlingIOException((IOException)e);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public KeyStore createKeyStore(ResourceResolver resolver, char[] password) throws SlingIOException, SecurityException, IllegalArgumentException {
        if (resolver == null) {
            throw new IllegalArgumentException("Cannot create a key store with a null resource resolver.");
        }
        return this.createKeyStore(resolver, resolver.getUserID(), password);
    }

    @Override
    public KeyStore createTrustStore(ResourceResolver resolver, char[] password) throws SlingIOException, SecurityException, IllegalArgumentException {
        try {
            Resource trustStoreResource = this.createKeyStoreResource(resolver, TRUST_STORE, password);
            if (trustStoreResource == null) {
                throw new IOException("Uninitialised system trust store.");
            }
            return new GraniteKeyStore(trustStoreResource, KeyStore.getInstance("PKCS12", "AdobeGraniteSecurityProvider"), this.cryptoSupport.protect(new String(password)), this.cryptoSupport);
        }
        catch (IOException e) {
            throw new SlingIOException(e);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public boolean keyStoreExists(ResourceResolver resolver, String userId) {
        User user = KeyStoreServiceImpl.retrieveUser(resolver, userId);
        String expectedKeyStorePath = KeyStoreServiceImpl.getKeyStorePathForUser(user, USER_KEYSTORE);
        return resolver.getResource(expectedKeyStorePath) != null;
    }

    @Override
    public boolean trustStoreExists(ResourceResolver resolver) {
        return resolver.getResource(TRUST_STORE) != null;
    }

    @Override
    public void addKeyStoreKeyEntry(ResourceResolver resolver, String userId, String alias, Key key, Certificate[] chain) throws SecurityException, KeyStoreNotInitialisedException {
        KeyStoreTuple keyStoreTuple = null;
        try {
            keyStoreTuple = this.internalGetKeyStore(resolver, userId);
            keyStoreTuple.keyStore.setKeyEntry(alias, key, keyStoreTuple.password, chain);
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e);
        }
        finally {
            if (keyStoreTuple != null) {
                keyStoreTuple.clear();
            }
        }
    }

    @Override
    public KeyStore.Entry getKeyStoreEntry(ResourceResolver resolver, String userId, String alias) throws SecurityException, KeyStoreNotInitialisedException {
        KeyStoreTuple keyStoreTuple = null;
        try {
            keyStoreTuple = this.internalGetKeyStore(resolver, userId);
            KeyStore.Entry entry = keyStoreTuple.keyStore.getEntry(alias, keyStoreTuple.getPasswordProtection());
            return entry;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        catch (UnrecoverableEntryException e) {
            throw new SecurityException(e);
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e);
        }
        finally {
            if (keyStoreTuple != null) {
                keyStoreTuple.clear();
            }
        }
    }

    private KeyStoreTuple internalGetKeyStore(ResourceResolver resolver, String userId) throws SlingIOException, SecurityException, KeyStoreNotInitialisedException {
        if (resolver == null) {
            throw new IllegalArgumentException("The resource resolver cannot be null");
        }
        if (userId == null) {
            throw new IllegalArgumentException("The userId cannot be null");
        }
        User user = KeyStoreServiceImpl.retrieveUser(resolver, userId);
        String expectedKeyStorePath = KeyStoreServiceImpl.getKeyStorePathForUser(user, USER_KEYSTORE);
        try {
            Resource keyStoreResource = resolver.getResource(expectedKeyStorePath);
            if (keyStoreResource == null) {
                throw new KeyStoreNotInitialisedException("Uninitialised key store for user " + userId);
            }
            char[] password = KeyStoreServiceImpl.extractStorePassword(resolver, expectedKeyStorePath, this.cryptoSupport);
            GraniteKeyStore keyStore = new GraniteKeyStore(keyStoreResource, KeyStore.getInstance("PKCS12", "AdobeGraniteSecurityProvider"), this.cryptoSupport.protect(new String(password)), this.cryptoSupport);
            return new KeyStoreTuple(keyStore, password);
        }
        catch (UnsupportedEncodingException e) {
            throw new SlingIOException((IOException)e);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException(e);
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        catch (CertificateException e) {
            throw new SecurityException(e);
        }
        catch (IOException e) {
            throw new SlingIOException(e);
        }
        catch (CryptoException e) {
            throw new SecurityException(e);
        }
    }

    private KeyStoreTuple internalGetTrustStore(ResourceResolver resolver) throws SlingIOException, SecurityException, IllegalArgumentException, KeyStoreNotInitialisedException {
        if (resolver == null) {
            throw new IllegalArgumentException("The resource resolver cannot be null.");
        }
        try {
            Resource trustStoreResource = resolver.getResource(TRUST_STORE);
            if (trustStoreResource == null) {
                throw new KeyStoreNotInitialisedException("Uninitialised system trust store.");
            }
            char[] password = KeyStoreServiceImpl.extractStorePassword(resolver, TRUST_STORE, this.cryptoSupport);
            GraniteKeyStore trustStore = new GraniteKeyStore(trustStoreResource, KeyStore.getInstance("PKCS12", "AdobeGraniteSecurityProvider"), this.cryptoSupport.protect(new String(password)), this.cryptoSupport);
            return new KeyStoreTuple(trustStore, password);
        }
        catch (IOException e) {
            throw new SlingIOException(e);
        }
        catch (KeyStoreException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        catch (CertificateException e) {
            throw new SecurityException(e);
        }
        catch (CryptoException e) {
            throw new SecurityException(e);
        }
    }

    private Resource createKeyStoreResource(ResourceResolver resolver, String path, char[] password) throws SecurityException, SlingIOException {
        block8: {
            try {
                Resource keyStoreResource = resolver.getResource(path);
                if (keyStoreResource == null) {
                    String keyStoreFolder = path.substring(0, path.lastIndexOf(47));
                    String keyStoreFile = path.substring(path.lastIndexOf(47) + 1, path.length());
                    Session session = (Session)resolver.adaptTo(Session.class);
                    Resource firstAccessibleResource = this.getFirstAccessibleResource(resolver, keyStoreFolder);
                    if (firstAccessibleResource != null) {
                        String firstAccessiblePath = firstAccessibleResource.getPath();
                        Node keyStoreFolderNode = !keyStoreFolder.equals(firstAccessiblePath) ? JcrUtils.getOrCreateByPath((Node)((Node)firstAccessibleResource.adaptTo(Node.class)), (String)keyStoreFolder.substring(firstAccessiblePath.length() + 1, keyStoreFolder.length()), (boolean)false, (String)"sling:Folder", (String)"sling:Folder", (boolean)false) : (Node)firstAccessibleResource.adaptTo(Node.class);
                        Node keyStoreFileNode = JcrUtils.getOrAddNode((Node)keyStoreFolderNode, (String)keyStoreFile, (String)"nt:file");
                        Node keyStoreFileNodeContent = JcrUtils.getOrAddNode((Node)keyStoreFileNode, (String)"jcr:content", (String)"nt:resource");
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        KeyStore keyStore = KeyStore.getInstance("PKCS12", "AdobeGraniteSecurityProvider");
                        keyStore.load(null, null);
                        keyStore.store(baos, password);
                        keyStoreFileNodeContent.setProperty("jcr:data", session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream(baos.toByteArray())));
                        if (TRUST_STORE.equals(path)) {
                            ACLUtils.removeAllACLEntries(session, path);
                            ACLUtils.addACLEntry(session, path, "everyone", new String[]{"{http://www.jcp.org/jcr/1.0}all"}, false);
                            ACLUtils.addACLEntry(session, path, "administrators", new String[]{"{http://www.jcp.org/jcr/1.0}all"}, true);
                            ACLUtils.addACLEntry(session, path, "everyone", new String[]{"{http://www.jcp.org/jcr/1.0}read"}, true);
                        }
                        keyStoreFolderNode.setProperty(JCR_PROP_KEYSTORE_PASSWORD, this.cryptoSupport.protect(new String(password)));
                        session.save();
                        return resolver.getResource(path);
                    }
                    break block8;
                }
                return keyStoreResource;
            }
            catch (IOException e) {
                throw new SlingIOException(e);
            }
            catch (AccessDeniedException e) {
                throw new SecurityException(e);
            }
            catch (RepositoryException e) {
                throw new SlingIOException(new IOException(e));
            }
            catch (Exception e) {
                throw new SecurityException(e);
            }
        }
        return null;
    }

    private Resource getFirstAccessibleResource(ResourceResolver resolver, String path) {
        Resource resource = null;
        while (resource == null && !"/".equals(path)) {
            resource = resolver.getResource(path);
            path = ResourceUtil.getParent((String)path);
        }
        if (resource == null && "/".equals(path)) {
            resource = resolver.getResource("/");
        }
        return resource;
    }

    private static String getKeyStorePathForUser(User user, String keyStoreFileName) throws SlingIOException {
        String userHome;
        try {
            userHome = user.getPath();
        }
        catch (RepositoryException e) {
            throw new SlingIOException(new IOException(e));
        }
        return userHome + "/" + USER_KEYSTORE_FOLDER + "/" + keyStoreFileName;
    }

    private static char[] extractStorePassword(ResourceResolver resolver, String storePath, CryptoSupport cryptoSupport) throws SecurityException {
        Resource storeResource = resolver.getResource(storePath);
        if (storeResource != null) {
            Node storeParentNode = (Node)storeResource.getParent().adaptTo(Node.class);
            try {
                Property passwordProperty = storeParentNode.getProperty(JCR_PROP_KEYSTORE_PASSWORD);
                if (passwordProperty != null) {
                    return cryptoSupport.unprotect(passwordProperty.getString()).toCharArray();
                }
                throw new SecurityException("Missing 'keystorePassword' property on " + ResourceUtil.getParent((String)storePath));
            }
            catch (RepositoryException e) {
                throw new SecurityException(e);
            }
            catch (CryptoException e) {
                throw new SecurityException(e);
            }
        }
        return null;
    }

    private static User retrieveUser(ResourceResolver resolver, String userId) throws IllegalArgumentException, SlingIOException {
        Authorizable authorizable;
        UserManager userManager = (UserManager)resolver.adaptTo(UserManager.class);
        if (userManager != null) {
            try {
                authorizable = userManager.getAuthorizable(userId);
            }
            catch (RepositoryException e) {
                throw new SlingIOException(new IOException(e));
            }
            if (authorizable == null || authorizable.isGroup()) {
                throw new IllegalArgumentException("The provided userId does not identify an existing user.");
            }
        } else {
            throw new IllegalArgumentException("Cannot obtain a UserManager for the given resource resolver.");
        }
        User user = (User)authorizable;
        return user;
    }

    protected KeyPair getKeyPair(KeyStore store, String alias, KeyStore.ProtectionParameter protection) throws KeyStoreException, UnrecoverableEntryException, NoSuchAlgorithmException {
        if (store.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
            KeyStore.PrivateKeyEntry pke = (KeyStore.PrivateKeyEntry)store.getEntry(alias, protection);
            Certificate cert = pke.getCertificate();
            return new KeyPair(cert.getPublicKey(), pke.getPrivateKey());
        }
        return null;
    }

    protected void setKeyPair(KeyStore store, KeyPair keyPair, String alias, char[] password) throws CryptoException, KeyStoreException {
        X500Principal subject = this.getPrincipal(alias);
        Certificate certificate = this.cryptoSupport.sign(null, keyPair, subject, 0L, 1L);
        store.setKeyEntry(alias, keyPair.getPrivate(), password, new Certificate[]{certificate});
    }

    private X500Principal getPrincipal(String alias) {
        String name = String.format("O=INTERNAL,CN=%s", alias);
        return new X500Principal(name);
    }

    private static void reset(char[] array) {
        if (array != null) {
            Arrays.fill(array, '\u0000');
        }
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }

    private class KeyStoreTuple {
        final KeyStore keyStore;
        final char[] password;
        KeyStore.PasswordProtection protection;

        KeyStoreTuple(KeyStore keyStore, char[] password) {
            this.keyStore = keyStore;
            this.password = password;
        }

        KeyStore.PasswordProtection getPasswordProtection() {
            if (this.protection == null) {
                this.protection = new KeyStore.PasswordProtection(this.password);
            }
            return this.protection;
        }

        void clear() {
            KeyStoreServiceImpl.reset(this.password);
            if (this.protection != null) {
                try {
                    this.protection.destroy();
                }
                catch (DestroyFailedException e) {
                    throw new SecurityException(e);
                }
            }
        }
    }
}

