/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.gibson;

import com.adobe.fontengine.font.Base14;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.fontmanagement.FontResolutionPriority;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.RandomAccessFileByteReader;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.readingorder.ReadingOrderTextExtractor;
import com.adobe.internal.pdftoolkit.services.textextraction.ParagraphIterator;
import com.adobe.internal.pdftoolkit.services.textextraction.Word;
import com.adobe.internal.pdftoolkit.services.xmp.DocumentMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.XMPService;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOExceptionWithCause;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PagedText;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GibsonParser
extends AbstractParser {
    private static final long serialVersionUID = 1776775061856503811L;
    private static final Font[] mBase14Fonts = new Font[]{Base14.courierBold, Base14.courierBoldOblique, Base14.courierOblique, Base14.courierRegular, Base14.helveticaBold, Base14.helveticaBoldOblique, Base14.helveticaOblique, Base14.helveticaRegular, Base14.symbol, Base14.timesBold, Base14.timesBoldItalic, Base14.timesItalic, Base14.timesRegular, Base14.zapfDingbats};
    private static final PDFFontSet pdfFontSet = GibsonParser.getBase14FontSet();
    private static final MediaType PDF = MediaType.application((String)"pdf");
    private boolean extractAnnotationText = true;

    private static PDFFontSet getBase14FontSet() {
        try {
            PDFFontSetImpl pdfFontSet = new PDFFontSetImpl();
            pdfFontSet.setResolutionPriority(FontResolutionPriority.LAST);
            for (int idxFont = 0; idxFont < mBase14Fonts.length; ++idxFont) {
                pdfFontSet.addFont(mBase14Fonts[idxFont]);
            }
            if (!pdfFontSet.hasRootFallback()) {
                pdfFontSet.addFallbackFont(PDFDocument.ROOT_LOCALE, Base14.courierRegular);
            }
            return pdfFontSet;
        }
        catch (Exception e) {
            throw new IllegalStateException("Internal error with built-in base 14 fonts", e);
        }
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return Collections.singleton(PDF);
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TemporaryResources tmp = new TemporaryResources();
        try {
            TikaInputStream tis = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmp);
            RandomAccessFile file = new RandomAccessFile(tis.getFile(), "r");
            tmp.addResource((Closeable)file);
            RandomAccessFileByteReader reader = new RandomAccessFileByteReader(file);
            tmp.addResource(new Closeable((ByteReader)reader){
                final /* synthetic */ ByteReader val$reader;
                {
                    this.val$reader = byteReader;
                }

                public void close() throws IOException {
                    this.val$reader.close();
                }
            });
            final PDFDocument document = PDFDocument.newInstance((ByteReader)reader, (PDFOpenOptions)PDFOpenOptions.newInstance());
            tmp.addResource(new Closeable(){

                public void close() throws IOException {
                    try {
                        document.close();
                    }
                    catch (PDFException e) {
                        throw new IOExceptionWithCause((Throwable)e);
                    }
                }
            });
            metadata.set("Content-Type", PDF.toString());
            this.extractMetadata(document, metadata);
            ReadingOrderTextExtractor extractor = ReadingOrderTextExtractor.newInstance((PDFDocument)document, (PDFFontSet)pdfFontSet);
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            for (PDFPage page : document.requirePages()) {
                xhtml.startElement("div", "class", "page");
                xhtml.startElement("p");
                ParagraphIterator iterator = extractor.getParagraphIterator(page, page.getIndex());
                while (iterator.hasNext()) {
                    xhtml.startElement("p");
                    List lines = iterator.next();
                    for (List line : lines) {
                        for (Word word : line) {
                            xhtml.characters(word.toString());
                        }
                        xhtml.characters("\n");
                    }
                    xhtml.endElement("p");
                }
                xhtml.endElement("p");
                if (this.extractAnnotationText) {
                    xhtml.startElement("div", "class", "annotation");
                    PDFAnnotationIterator annotsIterator = page.getAnnotationsIterator();
                    while (annotsIterator.hasNext()) {
                        String contents;
                        String subject;
                        PDFAnnotation annot = annotsIterator.next();
                        if (!(annot instanceof PDFAnnotationMarkup)) continue;
                        PDFAnnotationMarkup markupAnnot = (PDFAnnotationMarkup)annot;
                        String title = markupAnnot.getTitle();
                        if (title != null) {
                            xhtml.startElement("p", "class", "annotationTitle");
                            xhtml.characters(title);
                            xhtml.endElement("p");
                        }
                        if ((subject = markupAnnot.getSubject()) != null) {
                            xhtml.startElement("p", "class", "annotationSubject");
                            xhtml.characters(subject);
                            xhtml.endElement("p");
                        }
                        if ((contents = markupAnnot.getContents()) == null) continue;
                        xhtml.startElement("p", "class", "annotationContents");
                        xhtml.characters(contents);
                        xhtml.endElement("p");
                    }
                    xhtml.endElement("div");
                }
                xhtml.endElement("div");
            }
            xhtml.endDocument();
        }
        catch (PDFException e) {
            throw new TikaException("PDF parse error", (Throwable)e);
        }
        finally {
            tmp.close();
        }
    }

    private void extractMetadata(PDFDocument document, Metadata metadata) {
        try {
            DocumentMetadata info = XMPService.getDocumentMetadata((PDFDocument)document);
            metadata.set(PagedText.N_PAGES, document.requirePages().getCount());
            metadata.set(Metadata.CREATION_DATE, info.getCreationDate());
            metadata.set(Metadata.LAST_MODIFIED, info.getModificationDate());
            this.addMetadata(metadata, "title", info.getTitle());
            this.addMetadata(metadata, "Author", info.getAuthor());
            this.addMetadata(metadata, "creator", info.getCreator());
            this.addMetadata(metadata, "Keywords", info.getKeywordsAsString());
            this.addMetadata(metadata, "producer", info.getProducer());
            this.addMetadata(metadata, "subject", info.getSubject());
            this.addMetadata(metadata, "trapped", info.getTrapped());
            List<String> handledMetadata = Arrays.asList("Author", "Creator", "CreationDate", "ModDate", "Keywords", "Producer", "Subject", "Title", "Trapped");
            List customPropertyNames = info.getCustomPropertyNames();
            if (customPropertyNames != null && customPropertyNames.size() > 0) {
                for (String name : info.getCustomPropertyNames()) {
                    if (handledMetadata.contains(name)) continue;
                    this.addMetadata(metadata, name, info.getCustomProperty(name));
                }
            }
        }
        catch (PDFException pDFException) {
            // empty catch block
        }
    }

    private void addMetadata(Metadata metadata, String name, String value) {
        if (value != null) {
            metadata.add(name, value);
        }
    }
}

