/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.i18n.impl;

import com.adobe.granite.i18n.impl.dict.XliffDictHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.framework.BundleContext;

@Component
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.description", value={"I18n Dictionary Import/Export Servlet"}), @Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.selectors", value={"dict"}), @Property(name="sling.servlet.methods", value={"GET", "POST"})})
public class DictImportExportServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -7329439205765482666L;
    private Map<String, XliffDictHelper> helpers = new HashMap<String, XliffDictHelper>();
    private XliffDictHelper defaultHelper;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String path = request.getRequestPathInfo().getResourcePath();
        String format = request.getRequestPathInfo().getExtension();
        XliffDictHelper helper = format == null ? this.defaultHelper : this.helpers.get(format);
        if (helper != null) {
            helper.exportDict(path, request, response);
        } else {
            response.sendError(501, "Format " + format + " not supported");
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String path = request.getRequestPathInfo().getResourcePath();
        String format = request.getRequestPathInfo().getExtension();
        XliffDictHelper helper = format == null ? this.defaultHelper : this.helpers.get(format);
        if (helper != null) {
            RequestParameter fileParam = request.getRequestParameter("file");
            if (fileParam != null) {
                helper.importDict(path, request, response, fileParam.getInputStream());
            } else {
                response.sendError(400, "Request parameter 'file' is missing");
            }
        } else {
            response.sendError(501, "Format " + format + " not supported");
        }
    }

    @Activate
    protected void activate(BundleContext context) {
        this.defaultHelper = new XliffDictHelper(context.getBundle());
        this.helpers.put("xliff", this.defaultHelper);
        this.helpers.put("xlf", this.defaultHelper);
    }

    @Deactivate
    protected void deactivate() {
        this.helpers.clear();
    }
}

