/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.i18n.impl;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETagHelper {
    private static final Logger log = LoggerFactory.getLogger(ETagHelper.class);

    public static boolean handleETag(HttpServletRequest request, HttpServletResponse response, String etag) {
        if (etag != null) {
            response.setHeader("ETag", new EntityTag(etag).toString());
            EntityTag[] entityTags = EntityTag.parseHeader(request.getHeader("If-None-Match"));
            if (entityTags != null) {
                for (EntityTag tag : entityTags) {
                    if (!tag.isWildcard() && !etag.equals(tag.getValue())) continue;
                    response.setStatus(304);
                    return true;
                }
            }
        }
        return false;
    }

    public static class EntityTag {
        private StringBuilder value = new StringBuilder();
        private boolean weak = false;
        private boolean wildcard = false;

        public EntityTag() {
        }

        public EntityTag(String value) {
            this.value.append(value);
        }

        public EntityTag(String value, boolean weak) {
            this.value.append(value);
            this.weak = weak;
        }

        public String getValue() {
            return this.value.toString();
        }

        public boolean isWeak() {
            return this.weak;
        }

        public boolean isWildcard() {
            return this.wildcard;
        }

        public String toString() {
            if (this.isWeak()) {
                return "W/\"" + this.getValue() + '\"';
            }
            return '\"' + this.getValue() + '\"';
        }

        public static EntityTag[] parseHeader(String header) {
            if (header == null) {
                return null;
            }
            ArrayList<EntityTag> tags = new ArrayList<EntityTag>();
            EntityTag tag = new EntityTag();
            boolean parseQuotedString = false;
            for (int i = 0; i < header.length(); ++i) {
                char c = header.charAt(i);
                if (parseQuotedString) {
                    if (c == '\"') {
                        tags.add(tag);
                        tag = new EntityTag();
                        parseQuotedString = false;
                        continue;
                    }
                    tag.value.append(c);
                    continue;
                }
                if (c == ' ') continue;
                if (c == '*' && tags.size() == 0) {
                    tag.value.append('*');
                    tag.wildcard = true;
                    return new EntityTag[]{tag};
                }
                if (c == 'W') {
                    if (i + 2 >= header.length() || header.charAt(i + 1) != '/' || header.charAt(i + 2) != '\"') {
                        log.warn("Could not parse http entity-tag header, incorrect weak marker: " + header);
                        return null;
                    }
                    i += 2;
                    parseQuotedString = true;
                    continue;
                }
                if (c == '\"') {
                    parseQuotedString = true;
                    continue;
                }
                if (c == ',') continue;
                log.warn("Could not parse http entity-tag header, contains unquoted string: " + header);
                return null;
            }
            if (parseQuotedString) {
                log.warn("Could not parse http entity-tag header, unclosed quoted string: " + header);
                return null;
            }
            return tags.toArray(new EntityTag[tags.size()]);
        }
    }
}

