/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.i18n.impl;

import com.adobe.granite.i18n.LocaleUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.i18n.RequestLocaleResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(label="%localeresolver.name", description="%localeresolver.description", metatype=true)
@Service(value={RequestLocaleResolver.class})
public class PreferencesLocaleResolverService
implements RequestLocaleResolver {
    private static final String DEFAULT_PREF_NAME = "language";
    @Property(value={"language"}, label="%localeresolver.preference.name", description="%localeresolver.preference.desc")
    private static final String LANGUAGE_PREFERENCE = "security.preferences.name";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String preferenceName;
    private static final String REQUEST_ATTRIBUTE_RESOLVER = "org.apache.sling.auth.core.ResourceResolver";

    @Activate
    protected void activate(Map<String, Object> properties) {
        String value = (String)properties.get(LANGUAGE_PREFERENCE);
        if (value != null && value.length() > 0) {
            this.preferenceName = "preferences/" + value;
        } else {
            this.preferenceName = null;
            this.logger.info("Preferences locale resolver is disabled!");
        }
    }

    public List<Locale> resolveLocale(HttpServletRequest request) {
        Session session;
        if (this.preferenceName == null) {
            return null;
        }
        ResourceResolver resolver = (ResourceResolver)request.getAttribute(REQUEST_ATTRIBUTE_RESOLVER);
        Session session2 = session = resolver != null ? (Session)resolver.adaptTo(Session.class) : null;
        if (session instanceof JackrabbitSession) {
            String userId = session.getUserID();
            try {
                Value[] property;
                JackrabbitSession s = (JackrabbitSession)session;
                Authorizable user = s.getUserManager().getAuthorizable(userId);
                if (user != null && user.hasProperty(this.preferenceName) && (property = user.getProperty(this.preferenceName)) != null && property.length > 0) {
                    LinkedList<Locale> ret = new LinkedList<Locale>();
                    for (Value v : property) {
                        ret.add(LocaleUtil.parseLocale(v.getString()));
                    }
                    this.logger.debug("Resolved language for {} to {}", (Object)userId, ret);
                    return ret;
                }
                this.logger.debug("Unable to retrieve preferences language for user {}", (Object)userId);
            }
            catch (RepositoryException e) {
                this.logger.warn("Error occur resolving locale.", (Throwable)e);
            }
        } else {
            this.logger.debug("No session available -> select default");
        }
        return null;
    }
}

