/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.i18n.impl.bundle;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.i18n.ResourceBundleProvider;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="%pseudo.name", description="%pseudo.description")
@Service(value={ResourceBundleProvider.class})
@Property(name="service.ranking", intValue={1000})
public class PseudoTranslations
implements ResourceBundleProvider {
    private static final Logger log = LoggerFactory.getLogger(PseudoTranslations.class);
    private static final String DELIMITER = " ((";
    private static final String DELIMITER_END = " ))";
    private static final String PATTERN_KEY = "_pseudoPattern_";
    private static final List<String> keys = Arrays.asList("_pseudoPattern_");
    private static final String LANGUAGE = "zz";
    private static final String DEFAULT_PATTERN = "zz USR_{string}_\u5c20";
    private static final String DEFAULT_PAGE_PATTERN = "pg PAGE_{string}_\u5c20";
    private static final String[] DEFAULT_PATTERNS = new String[]{"zz USR_{string}_\u5c20", "pg PAGE_{string}_\u5c20"};
    @Property(value={"zz USR_{string}_\u5c20", "pg PAGE_{string}_\u5c20"})
    private static final String PATTERNS = "pseudo.patterns";
    private Map<Locale, PseudoBundle> bundles;

    public Locale getDefaultLocale() {
        return null;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        if (locale != null && LANGUAGE.equals(locale.getLanguage().toLowerCase())) {
            return this.bundles.get(locale);
        }
        return null;
    }

    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        if (locale != null && LANGUAGE.equals(locale.getLanguage().toLowerCase())) {
            return this.bundles.get(locale);
        }
        return null;
    }

    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        String[] patterns = PropertiesUtil.toStringArray(props.get(PATTERNS), (String[])DEFAULT_PATTERNS);
        this.bundles = new HashMap<Locale, PseudoBundle>();
        for (String pattern : patterns) {
            int pos = pattern.indexOf(" ");
            if (pos < 0) continue;
            String country = pattern.substring(0, pos).toUpperCase();
            pattern = pattern.substring(pos + 1);
            this.bundles.put(new Locale(LANGUAGE, country), new PseudoBundle(pattern));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PseudoBundle
    extends ResourceBundle {
        private String pattern;

        public PseudoBundle(String pattern) {
            this.pattern = pattern;
        }

        @Override
        protected Object handleGetObject(String key) {
            String comment;
            String str;
            if (key == null) {
                return null;
            }
            if (PseudoTranslations.PATTERN_KEY.equals(key)) {
                return this.pattern;
            }
            int pos = key.indexOf(PseudoTranslations.DELIMITER);
            if (pos >= 0) {
                str = key.substring(0, pos);
                comment = key.substring(pos + PseudoTranslations.DELIMITER.length());
                comment = StringUtils.removeEnd((String)comment, (String)PseudoTranslations.DELIMITER_END);
            } else {
                str = key;
                comment = "";
            }
            try {
                return this.pattern.replace("{string}", str).replace("{comment}", comment);
            }
            catch (Exception e) {
                String msg = "invalid pseudo translation pattern: '" + this.pattern + "': " + e.getMessage();
                log.error(msg);
                return "ERROR: " + msg;
            }
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(keys);
        }

        private String parseString(String key) {
            int pos = key.indexOf(PseudoTranslations.DELIMITER);
            if (pos >= 0) {
                return key.substring(0, pos);
            }
            return key;
        }
    }
}

