/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.i18n.impl.bundle;

import com.adobe.granite.i18n.impl.bundle.ResourceBundleExporter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.sling.api.SlingHttpServletResponse;

public class TextExporter
implements ResourceBundleExporter {
    private static final String CONTENT_TYPE_TEXT = "text/plain";

    public void export(ResourceBundle bundle, SlingHttpServletResponse response) throws IOException {
        response.setContentType(CONTENT_TYPE_TEXT);
        response.setCharacterEncoding("utf-8");
        PrintWriter w = response.getWriter();
        String title = bundle.getString("Resources for Locale %s");
        w.printf(title, bundle.getLocale());
        w.println();
        w.println();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object resource = bundle.getObject(key);
            if (resource == null) continue;
            w.print(key);
            w.print(" = ");
            if (resource.getClass().isArray()) {
                Object[] arrResource;
                w.println('[');
                for (Object res : arrResource = (Object[])resource) {
                    w.print("   ");
                    w.println(res);
                }
                w.print(']');
            } else {
                w.println(resource);
            }
            w.println();
        }
    }
}

