/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.i18n.impl.bundle;

import com.adobe.granite.i18n.impl.bundle.ResourceBundleExporter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.sling.api.SlingHttpServletResponse;
import org.osgi.framework.Bundle;

public class XliffExporter
implements ResourceBundleExporter {
    private static final String CONTENT_TYPE_XML = "text/xml";
    private final String toolName;
    private final String toolId;
    private final String toolVersion;
    private final String toolCompany;

    public XliffExporter(Bundle bundle) {
        this.toolId = bundle.getSymbolicName();
        Dictionary headers = bundle.getHeaders();
        this.toolVersion = String.valueOf(headers.get("Bundle-Version"));
        this.toolName = String.valueOf(headers.get("Bundle-Name"));
        this.toolCompany = String.valueOf(headers.get("Bundle-Vendor"));
    }

    public void export(ResourceBundle bundle, SlingHttpServletResponse response) throws IOException {
        response.setContentType(CONTENT_TYPE_XML);
        response.setCharacterEncoding("utf-8");
        String lang = bundle.getLocale().toString();
        PrintWriter w = response.getWriter();
        w.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        w.println("<xliff version=\"1.1\">");
        w.println("  <file");
        w.println("    original=\"/libs/cq/i18n/" + lang + "\"");
        w.println("    source-language=\"en\"");
        w.println("    target-language=\"" + lang + "\"");
        w.println("    datatype=\"x-javaresourcebundle\"");
        w.println("    tool-id=\"" + this.toolId + "\"");
        w.println("    date=\"" + new Date() + "\"");
        w.println("  >");
        w.println("    <header>");
        w.println("      <tool");
        w.println("        tool-id=\"" + this.toolId + "\"");
        w.println("        tool-name=\"" + this.toolName + "\"");
        w.println("        tool-version=\"" + this.toolVersion + "\"");
        w.println("        tool-company=\"" + this.toolCompany + "\"");
        w.println("      />");
        w.println("    </header>");
        w.println("    <body>");
        Enumeration<String> keys = bundle.getKeys();
        int i = 0;
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object resource = bundle.getObject(key);
            if (resource != null) {
                w.println("      <trans-unit id=\"" + i + "\">");
                w.print("        <source xml:lang=\"en\"><![CDATA[");
                w.print(key);
                w.println("]]></source>");
                w.print("        <target xml:lang=\"" + lang + "\"><![CDATA[");
                w.print(resource);
                w.println("]]></target>");
                w.println("      </trans-unit>");
            }
            ++i;
        }
        w.println("    </body>");
        w.println("  </file>");
        w.println("</xliff>");
    }
}

