/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.i18n.impl.dict;

import com.adobe.granite.i18n.impl.bundle.XliffExporter;
import com.adobe.granite.i18n.impl.dict.XliffDictImporter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.util.TraversingItemVisitor;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XliffDictHelper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final XliffExporter exporter;

    public XliffDictHelper(Bundle bundle) {
        this.exporter = new XliffExporter(bundle);
    }

    public void exportDict(String path, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        try {
            Node node;
            if (session.nodeExists(path) && (node = session.getNode(path)).isNodeType("mix:language") && node.hasProperty("{http://www.jcp.org/jcr/1.0}language")) {
                final Locale locale = new Locale(node.getProperty("{http://www.jcp.org/jcr/1.0}language").getString());
                final HashMap translations = new HashMap();
                TraversingItemVisitor.Default v = new TraversingItemVisitor.Default(){

                    protected void entering(Node node, int level) throws RepositoryException {
                        if (node.isNodeType("sling:Message") && node.hasProperty("sling:message")) {
                            String value = node.getProperty("sling:message").getString();
                            String key = node.hasProperty("sling:key") ? node.getProperty("sling:key").getString() : node.getName();
                            translations.put(key, value);
                        }
                    }
                };
                v.visit(node);
                ResourceBundle bundle = new ResourceBundle(){

                    @Override
                    public Locale getLocale() {
                        return locale;
                    }

                    @Override
                    protected Object handleGetObject(String key) {
                        return translations.get(key);
                    }

                    @Override
                    public Enumeration<String> getKeys() {
                        return new IteratorEnumeration(translations.keySet().iterator());
                    }
                };
                this.exporter.export(bundle, response);
                return;
            }
            response.sendError(404);
        }
        catch (RepositoryException e) {
            this.log.error("export xliff failed", (Throwable)e);
            IOException ioe = new IOException("export xliff failed");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void importDict(String path, SlingHttpServletRequest request, SlingHttpServletResponse response, InputStream inputStream) throws IOException {
        String overwriteParam;
        String depthParam;
        String[] selectors;
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        int treeDepth = 0;
        for (String selector : selectors = request.getRequestPathInfo().getSelectors()) {
            if (selector == null) continue;
            try {
                treeDepth = Integer.parseInt(selector);
                break;
            }
            catch (NumberFormatException e) {
                treeDepth = 0;
            }
        }
        if ((depthParam = request.getParameter("depth")) != null) {
            try {
                treeDepth = Integer.parseInt(depthParam);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        boolean overwrite = (overwriteParam = request.getParameter("overwrite")) != null && ("true".equals(overwriteParam) || "on".equals(overwriteParam));
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(inputStream, (DefaultHandler)new XliffDictImporter(session, path, treeDepth, overwrite));
            response.setStatus(200);
            response.setContentType("text/html");
            response.getWriter().println("{ \"success\": true }");
        }
        catch (SAXException e) {
            this.log.error("import xliff failed", (Throwable)e);
            IOException ioe = new IOException("import xliff failed");
            ioe.initCause(e);
            throw ioe;
        }
        catch (ParserConfigurationException e) {
            this.log.error("import xliff failed", (Throwable)e);
            IOException ioe = new IOException("import xliff failed");
            ioe.initCause(e);
            throw ioe;
        }
    }
}

