/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.i18n.impl.dict;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XliffDictImporter
extends DefaultHandler {
    private final Logger log = LoggerFactory.getLogger(XliffDictImporter.class);
    private static final String LANGUAGE_MIXIN = "mix:language";
    private static final String SLING_MESSAGE_MIXIN = "sling:Message";
    private static final String SLING_KEY_PROP = "sling:key";
    private static final String SLING_MESSAGE_PROP = "sling:message";
    private TransUnit transUnit = null;
    private State state = State.OTHER;
    private final String path;
    private final Session session;
    private Map<String, Map<String, String>> storedTranslations = new HashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> storedLowerCaseNodeNames = new HashMap<String, Map<String, String>>();
    private int treeDepth;
    private boolean overwrite;

    public XliffDictImporter(Session session, String path, int treeDepth, boolean overwrite) {
        this.session = session;
        this.path = path;
        this.treeDepth = treeDepth;
        this.overwrite = overwrite;
    }

    private Map<String, String> getStoredTranslations(Node languageNode) throws RepositoryException {
        String path = languageNode.getPath();
        if (!this.storedTranslations.containsKey(path)) {
            HashMap<String, String> translations = new HashMap<String, String>();
            this.storedTranslations.put(path, translations);
            String query = "/jcr:root" + languageNode.getPath() + "//*[@sling:message]";
            QueryManager qm = languageNode.getSession().getWorkspace().getQueryManager();
            NodeIterator messageNodes = qm.createQuery(query, "xpath").execute().getNodes();
            while (messageNodes.hasNext()) {
                Node node = messageNodes.nextNode();
                try {
                    if (!node.isNodeType(SLING_MESSAGE_MIXIN)) continue;
                    if (node.hasProperty(SLING_KEY_PROP)) {
                        translations.put(node.getProperty(SLING_KEY_PROP).getString(), node.getPath());
                        continue;
                    }
                    translations.put(node.getName(), node.getPath());
                }
                catch (Exception e) {
                    this.log.warn("Error while reading existing translation inside '" + path + "'", (Throwable)e);
                }
            }
        }
        return this.storedTranslations.get(path);
    }

    private Map<String, String> getStoredLowerCaseNodeNames(Node languageNode) throws RepositoryException {
        String path = languageNode.getPath();
        if (!this.storedLowerCaseNodeNames.containsKey(path)) {
            HashMap<String, String> lowerCaseNodeNames = new HashMap<String, String>();
            this.storedLowerCaseNodeNames.put(path, lowerCaseNodeNames);
            String query = "/jcr:root" + languageNode.getPath() + "//*[@sling:message]";
            QueryManager qm = languageNode.getSession().getWorkspace().getQueryManager();
            NodeIterator messageNodes = qm.createQuery(query, "xpath").execute().getNodes();
            while (messageNodes.hasNext()) {
                Node node = messageNodes.nextNode();
                lowerCaseNodeNames.put(node.getName().toLowerCase(), node.getName());
            }
        }
        return this.storedLowerCaseNodeNames.get(path);
    }

    private static String getNodeName(String source) {
        source = source.substring(0, (source = source.trim()).length() > 50 ? 50 : source.length());
        source = source.replaceAll(":", "_");
        source = source.replaceAll("/", "_");
        source = source.replaceAll("<", "_");
        source = source.replaceAll(">", "_");
        return Text.escapeIllegalJcrChars((String)source);
    }

    private static String getKey(String source, String comment) {
        if (comment != null) {
            return source + " ((" + comment + "))";
        }
        return source;
    }

    private static String getCommentForLog(String comment) {
        if (comment != null) {
            return " (comment: " + comment + ")";
        }
        return "";
    }

    private String calculateFolderPath(String nodeName) {
        StringBuilder path = new StringBuilder();
        int i = 0;
        for (int n = 0; n < nodeName.length() && i < this.treeDepth; ++n) {
            char c = nodeName.charAt(n);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (c < '0' || c > '9')) continue;
            path.append(Character.toLowerCase(c));
            path.append("/");
            ++i;
        }
        path.append(nodeName);
        return path.toString();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.state = State.OTHER;
        if (name.equalsIgnoreCase("trans-unit")) {
            this.transUnit = new TransUnit();
        } else if (name.equalsIgnoreCase("source")) {
            this.state = State.SOURCE;
            this.transUnit.source = null;
        } else if (name.equalsIgnoreCase("target")) {
            this.state = State.TARGET;
            this.transUnit.language = attributes.getValue("xml:lang");
            this.transUnit.target = null;
        } else if (name.equalsIgnoreCase("context") && "comment".equalsIgnoreCase(attributes.getValue("context-type"))) {
            this.state = State.COMMENT;
            this.transUnit.comment = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.transUnit != null) {
            switch (this.state) {
                case SOURCE: {
                    if (this.transUnit.source != null) {
                        this.transUnit.source = this.transUnit.source + new String(ch, start, length);
                        break;
                    }
                    this.transUnit.source = new String(ch, start, length);
                    break;
                }
                case TARGET: {
                    if (this.transUnit.target != null) {
                        this.transUnit.target = this.transUnit.target + new String(ch, start, length);
                        break;
                    }
                    this.transUnit.target = new String(ch, start, length);
                    break;
                }
                case COMMENT: {
                    this.transUnit.comment = this.transUnit.comment != null ? this.transUnit.comment + new String(ch, start, length) : new String(ch, start, length);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.state = State.OTHER;
        if (!name.equalsIgnoreCase("trans-unit")) return;
        if (this.transUnit.source == null) return;
        if (this.transUnit.source.length() == 0) return;
        if (this.transUnit.target == null) return;
        if (this.transUnit.target.length() == 0) return;
        if (this.transUnit.language == null) return;
        if (this.transUnit.language.length() == 0) {
            return;
        }
        String lang = this.transUnit.language.toLowerCase();
        String[] langSplit = (lang = lang.replace("_", "-")).split("-");
        if (langSplit.length == 2 && langSplit[0].equals(langSplit[1])) {
            lang = langSplit[0];
        }
        String languageNodePath = this.path + "/" + lang;
        Node languageNode = null;
        try {
            languageNode = JcrUtils.getOrCreateByPath((String)languageNodePath, (String)"{http://www.jcp.org/jcr/nt/1.0}folder", (Session)this.session);
            if (!languageNode.isNodeType(LANGUAGE_MIXIN)) {
                languageNode.addMixin(LANGUAGE_MIXIN);
            }
            if (!languageNode.hasProperty("{http://www.jcp.org/jcr/1.0}language")) {
                languageNode.setProperty("{http://www.jcp.org/jcr/1.0}language", lang);
            }
            String key = XliffDictImporter.getKey(this.transUnit.source, this.transUnit.comment);
            Node messageNode = null;
            Map<String, String> translations = this.getStoredTranslations(languageNode);
            if (translations.containsKey(key)) {
                messageNode = (Node)this.session.getItem(translations.get(key));
                if (messageNode.hasProperty(SLING_MESSAGE_PROP)) {
                    String existingTranslation = messageNode.getProperty(SLING_MESSAGE_PROP).getString();
                    if (this.transUnit.target.equals(existingTranslation)) {
                        this.log.info(this.transUnit.language + ": skipping repeated translation '" + this.transUnit.source + "' => '" + this.transUnit.target + "'" + XliffDictImporter.getCommentForLog(this.transUnit.comment) + " :: '" + messageNode.getPath() + "'");
                        return;
                    }
                    if (!this.overwrite) {
                        this.log.info(this.transUnit.language + ": keeping old translation for '" + this.transUnit.source + "', " + "existing translation: '" + existingTranslation + "', " + "new translation: '" + this.transUnit.target + "'" + XliffDictImporter.getCommentForLog(this.transUnit.comment) + " :: '" + messageNode.getPath() + "'");
                        return;
                    }
                    this.log.info(this.transUnit.language + ": overwriting old translation for '" + this.transUnit.source + "', " + "existing translation: '" + existingTranslation + "', " + "new translation: '" + this.transUnit.target + "'" + XliffDictImporter.getCommentForLog(this.transUnit.comment) + " :: '" + messageNode.getPath() + "'");
                } else {
                    this.log.warn("existing message node without translation (sling:message) found '" + messageNode.getPath() + "'");
                }
            }
            Map<String, String> lowerCaseNodeNames = this.getStoredLowerCaseNodeNames(languageNode);
            if (messageNode == null) {
                String nodeNameHint = XliffDictImporter.getNodeName(this.transUnit.source);
                if (lowerCaseNodeNames.containsKey(nodeNameHint.toLowerCase())) {
                    nodeNameHint = lowerCaseNodeNames.get(nodeNameHint.toLowerCase());
                }
                String pathHint = languageNode.getPath() + "/" + this.calculateFolderPath(nodeNameHint);
                messageNode = JcrUtils.getOrCreateUniqueByPath((String)pathHint, (String)"{http://www.jcp.org/jcr/nt/1.0}folder", (Session)this.session);
            }
            this.log.info(this.transUnit.language + ": translating '" + this.transUnit.source + "' => '" + this.transUnit.target + "'" + XliffDictImporter.getCommentForLog(this.transUnit.comment) + " :: '" + messageNode.getPath() + "'");
            if (!messageNode.isNodeType(SLING_MESSAGE_MIXIN)) {
                messageNode.addMixin(SLING_MESSAGE_MIXIN);
            }
            if (!messageNode.getName().equals(key)) {
                messageNode.setProperty(SLING_KEY_PROP, key);
            }
            messageNode.setProperty(SLING_MESSAGE_PROP, this.transUnit.target);
            translations.put(key, messageNode.getPath());
            lowerCaseNodeNames.put(messageNode.getName().toLowerCase(), messageNode.getName());
            return;
        }
        catch (RepositoryException e) {
            this.log.error("could not add translation unit to '" + languageNodePath + "'", (Throwable)e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.session.save();
        }
        catch (RepositoryException e) {
            this.log.error("could not save xliff import", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        SOURCE,
        TARGET,
        COMMENT,
        OTHER;

    }

    private static class TransUnit {
        String source;
        String target;
        String language;
        String comment;

        private TransUnit() {
        }
    }
}

