/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.i18n;

import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;

public class I18n {
    private final HttpServletRequest request;
    private final ResourceBundle resourceBundle;
    private static String BUNDLE_REQ_ATTR = "org.apache.sling.i18n.resourcebundle";

    public I18n(HttpServletRequest request) {
        this.request = request;
        this.resourceBundle = null;
    }

    public I18n(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.request = null;
    }

    private ResourceBundle getResourceBundle() {
        if (this.request != null) {
            return I18n.getResourceBundle(this.request);
        }
        return this.resourceBundle;
    }

    private static ResourceBundle getResourceBundle(HttpServletRequest req) {
        if (req instanceof SlingHttpServletRequest) {
            return ((SlingHttpServletRequest)req).getResourceBundle(null);
        }
        return (ResourceBundle)req.getAttribute(BUNDLE_REQ_ATTR);
    }

    public String get(String text) {
        return I18n.get(this.getResourceBundle(), text, null, (Object[])null);
    }

    public String get(String text, String comment) {
        return I18n.get(this.getResourceBundle(), text, comment, (Object[])null);
    }

    public String get(String text, String comment, Object ... args) {
        return I18n.get(this.getResourceBundle(), text, comment, args);
    }

    public String getVar(String text) {
        return I18n.getVar(this.getResourceBundle(), text, null);
    }

    public String getVar(String text, String comment) {
        return I18n.getVar(this.getResourceBundle(), text, comment);
    }

    public String getVar(String text, String comment, Object ... args) {
        return I18n.getVar(this.getResourceBundle(), text, comment, args);
    }

    public static String get(HttpServletRequest request, String text) {
        return I18n.get(I18n.getResourceBundle(request), text, null, (Object[])null);
    }

    public static String get(HttpServletRequest request, String text, String comment) {
        return I18n.get(I18n.getResourceBundle(request), text, comment, (Object[])null);
    }

    public static String get(HttpServletRequest request, String text, String comment, Object ... args) {
        return I18n.get(I18n.getResourceBundle(request), text, comment, args);
    }

    public static String getVar(HttpServletRequest request, String text) {
        return I18n.getVar(I18n.getResourceBundle(request), text, null);
    }

    public static String getVar(HttpServletRequest request, String text, String comment) {
        return I18n.getVar(I18n.getResourceBundle(request), text, comment);
    }

    public static String getVar(HttpServletRequest request, String text, String comment, Object ... args) {
        return I18n.getVar(I18n.getResourceBundle(request), text, comment, args);
    }

    public static String get(ResourceBundle resourceBundle, String text) {
        return I18n.get(resourceBundle, text, null, (Object[])null);
    }

    public static String get(ResourceBundle resourceBundle, String text, String comment) {
        return I18n.get(resourceBundle, text, comment, (Object[])null);
    }

    public static String get(ResourceBundle resourceBundle, String text, String comment, Object ... args) {
        String msg;
        if (text == null) {
            return text;
        }
        if (resourceBundle == null) {
            return I18n.patchText(text, args);
        }
        boolean equals = false;
        if (comment != null && comment.length() > 0) {
            String key = text + " ((" + comment + "))";
            if (key.equals(msg = resourceBundle.getString(key))) {
                equals = true;
                msg = text;
            }
        } else {
            msg = resourceBundle.getString(text);
            if (text.equals(msg)) {
                equals = true;
            }
        }
        try {
            return I18n.patchText(msg, args);
        }
        catch (IllegalArgumentException e) {
            if (equals) {
                throw e;
            }
            return msg;
        }
    }

    public static String getVar(ResourceBundle resourceBundle, String text) {
        return I18n.get(resourceBundle, text, null);
    }

    public static String getVar(ResourceBundle resourceBundle, String text, String comment) {
        return I18n.get(resourceBundle, text, comment);
    }

    public static String getVar(ResourceBundle resourceBundle, String text, String comment, Object ... args) {
        return I18n.get(resourceBundle, text, comment, args);
    }

    private static String patchText(String text, Object ... args) {
        if (text == null || args == null) {
            return text;
        }
        for (int i = 0; i < args.length; ++i) {
            Object o = args[i];
            if (o == null) continue;
            text = text.replaceAll("\\{" + i + "\\}", o.toString());
        }
        return text;
    }
}

