/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.annotation;

import com.adobe.granite.jmx.annotation.AnnotatedStandardMBean;
import com.adobe.granite.jmx.annotation.OpenTypeInfo;
import com.adobe.granite.jmx.annotation.OpenTypeUtils;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenAnnotatedStandardMBean
extends AnnotatedStandardMBean {
    private static final Logger log = LoggerFactory.getLogger(OpenAnnotatedStandardMBean.class);

    public <T> OpenAnnotatedStandardMBean(T implementation, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(implementation, mbeanInterface);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = super.getMBeanInfo();
        try {
            if (info instanceof OpenMBeanInfoSupport) {
                return info;
            }
            MBeanAttributeInfo[] attrs = info.getAttributes();
            OpenMBeanAttributeInfo[] openAttrs = new OpenMBeanAttributeInfo[attrs.length];
            for (int i = 0; i < attrs.length; ++i) {
                openAttrs[i] = this.convert(attrs[i]);
            }
            MBeanConstructorInfo[] consts = info.getConstructors();
            OpenMBeanConstructorInfo[] openConsts = new OpenMBeanConstructorInfo[consts.length];
            for (int i = 0; i < consts.length; ++i) {
                openConsts[i] = this.convert(consts[i]);
            }
            MBeanOperationInfo[] ops = info.getOperations();
            OpenMBeanOperationInfo[] openOps = new OpenMBeanOperationInfo[ops.length];
            for (int i = 0; i < ops.length; ++i) {
                openOps[i] = this.convert(ops[i]);
            }
            OpenMBeanInfoSupport open = new OpenMBeanInfoSupport(info.getClassName(), info.getDescription(), openAttrs, openConsts, openOps, info.getNotifications());
            this.cacheMBeanInfo(open);
            return open;
        }
        catch (Exception e) {
            log.warn("Error occur coverting to OpenMBeanInfo", (Throwable)e);
            return info;
        }
    }

    private OpenMBeanAttributeInfo convert(MBeanAttributeInfo info) throws Exception {
        Class<?> ret = info.isReadable() ? this.getReadMethod(info).getReturnType() : this.getWriteMethod(info).getParameterTypes()[0];
        OpenTypeInfo typeInfo = this.getAnnotation(info, OpenTypeInfo.class);
        OpenType<?> type = OpenTypeUtils.createOpenType(ret, typeInfo);
        return new OpenMBeanAttributeInfoSupport(info.getName(), info.getDescription(), type, info.isReadable(), info.isWritable(), info.isIs());
    }

    private OpenMBeanConstructorInfo convert(MBeanConstructorInfo info) throws Exception {
        MBeanParameterInfo[] sig = info.getSignature();
        OpenMBeanParameterInfo[] openSig = new OpenMBeanParameterInfo[sig.length];
        for (int i = 0; i < sig.length; ++i) {
            openSig[i] = this.convert(info, sig[i], i);
        }
        return new OpenMBeanConstructorInfoSupport(info.getName(), info.getDescription(), openSig);
    }

    private OpenMBeanOperationInfo convert(MBeanOperationInfo info) throws Exception {
        Class returnType = info.getReturnType().equals("void") ? Void.class : this.getMBeanInterface().getClassLoader().loadClass(info.getReturnType());
        OpenTypeInfo typeInfo = this.getMethod(info).getAnnotation(OpenTypeInfo.class);
        OpenType<?> openType = OpenTypeUtils.createOpenType(returnType, typeInfo);
        MBeanParameterInfo[] sig = info.getSignature();
        OpenMBeanParameterInfo[] openSig = new OpenMBeanParameterInfo[sig.length];
        for (int i = 0; i < sig.length; ++i) {
            openSig[i] = this.convert(info, sig[i], i);
        }
        return new OpenMBeanOperationInfoSupport(info.getName(), info.getDescription(), openSig, openType, info.getImpact());
    }

    private OpenMBeanParameterInfo convert(MBeanConstructorInfo ctor, MBeanParameterInfo info, int seq) throws Exception {
        Class<?> clazz = this.getMBeanInterface().getClassLoader().loadClass(info.getType());
        OpenTypeInfo typeInfo = this.getParamAnnotation(ctor, seq, OpenTypeInfo.class);
        OpenType<?> openType = OpenTypeUtils.createOpenType(clazz, typeInfo);
        return new OpenMBeanParameterInfoSupport(info.getName(), info.getDescription(), openType);
    }

    private OpenMBeanParameterInfo convert(MBeanOperationInfo op, MBeanParameterInfo info, int seq) throws Exception {
        Class<?> clazz = this.getMBeanInterface().getClassLoader().loadClass(info.getType());
        OpenTypeInfo typeInfo = this.getParamAnnotation(op, seq, OpenTypeInfo.class);
        OpenType<?> openType = OpenTypeUtils.createOpenType(clazz, typeInfo);
        return new OpenMBeanParameterInfoSupport(info.getName(), info.getDescription(), openType);
    }
}

