/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.annotation;

import com.adobe.granite.jmx.annotation.Description;
import com.adobe.granite.jmx.annotation.OpenTypeInfo;
import com.adobe.granite.jmx.annotation.TabularTypeInfo;
import com.adobe.granite.jmx.internal.Utils;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OpenTypeUtils {
    public static OpenType<?> createOpenType(Class<?> clazz, OpenTypeInfo info) throws OpenDataException {
        if (clazz.isArray()) {
            return new ArrayType(Utils.getArrayDim(clazz), OpenTypeUtils.createOpenType(Utils.getArrayType(clazz), info));
        }
        if (CompositeData.class.isAssignableFrom(clazz)) {
            return OpenTypeUtils.createCompositeType(info.value());
        }
        if (TabularData.class.isAssignableFrom(clazz)) {
            return OpenTypeUtils.createTabularType(info.value());
        }
        SimpleType<?> type = OpenTypeUtils.getSimpleType(clazz);
        if (type == null) {
            throw new OpenDataException("Illegal class for open type: " + clazz);
        }
        return type;
    }

    public static SimpleType<?> getSimpleType(Class<?> clazz) {
        if (clazz.equals(BigDecimal.class)) {
            return SimpleType.BIGDECIMAL;
        }
        if (clazz.equals(BigInteger.class)) {
            return SimpleType.BIGINTEGER;
        }
        if (clazz.equals(Boolean.class)) {
            return SimpleType.BOOLEAN;
        }
        if (clazz.equals(Byte.class)) {
            return SimpleType.BYTE;
        }
        if (clazz.equals(Character.class)) {
            return SimpleType.CHARACTER;
        }
        if (clazz.equals(Date.class)) {
            return SimpleType.DATE;
        }
        if (clazz.equals(Double.class)) {
            return SimpleType.DOUBLE;
        }
        if (clazz.equals(Float.class)) {
            return SimpleType.FLOAT;
        }
        if (clazz.equals(Integer.class)) {
            return SimpleType.INTEGER;
        }
        if (clazz.equals(Long.class)) {
            return SimpleType.LONG;
        }
        if (clazz.equals(ObjectName.class)) {
            return SimpleType.OBJECTNAME;
        }
        if (clazz.equals(Short.class)) {
            return SimpleType.SHORT;
        }
        if (clazz.equals(String.class)) {
            return SimpleType.STRING;
        }
        if (clazz.equals(Void.class)) {
            return SimpleType.VOID;
        }
        return null;
    }

    public static CompositeType createCompositeType(Class<?> clazz) throws OpenDataException {
        PropertyDescriptor[] properties = PropertyUtils.getPropertyDescriptors(clazz);
        ArrayList<String> itemNames = new ArrayList<String>();
        ArrayList itemTypes = new ArrayList();
        for (int i = 0; i < properties.length; ++i) {
            PropertyDescriptor p = properties[i];
            if (!OpenType.ALLOWED_CLASSNAMES_LIST.contains(p.getPropertyType().getName())) continue;
            OpenTypeInfo childInfo = OpenTypeUtils.getAnnotation(p, OpenTypeInfo.class);
            OpenType<?> openType = OpenTypeUtils.createOpenType(p.getPropertyType(), childInfo);
            itemNames.add(p.getName());
            itemTypes.add(openType);
        }
        Description description = clazz.getAnnotation(Description.class);
        String desc = description == null ? clazz.getName() : description.value();
        String[] names = itemNames.toArray(new String[itemNames.size()]);
        return new CompositeType(clazz.getName(), desc, names, names, itemTypes.toArray(new OpenType[itemTypes.size()]));
    }

    public static TabularType createTabularType(Class<?> clazz) throws OpenDataException {
        Description description = clazz.getAnnotation(Description.class);
        String desc = description == null ? clazz.getName() : description.value();
        TabularTypeInfo rowTypeInfo = clazz.getAnnotation(TabularTypeInfo.class);
        CompositeType rowType = OpenTypeUtils.createCompositeType(rowTypeInfo.rowType());
        return new TabularType(clazz.getName(), desc, rowType, rowTypeInfo.indexNames());
    }

    private static <T extends Annotation> T getAnnotation(PropertyDescriptor p, Class<T> a) {
        if (p.getReadMethod() != null) {
            T result = p.getReadMethod().getAnnotation(a);
            if (result != null) {
                return result;
            }
            if (p.getWriteMethod() == null) {
                return null;
            }
        }
        return p.getWriteMethod().getAnnotation(a);
    }
}

