/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonOpenType {
    private JsonFactory jsonFactory = new JsonFactory();

    public String toJson(OpenType<?> type) throws IOException {
        if (type instanceof SimpleType) {
            return this.toJson((SimpleType)type);
        }
        if (type instanceof CompositeType) {
            return this.toJson((CompositeType)type);
        }
        if (type instanceof ArrayType) {
            return this.toJson((ArrayType)type);
        }
        if (type instanceof TabularType) {
            return this.toJson((TabularType)type);
        }
        throw new IllegalArgumentException("Unknown instance of open type: " + type.getClass().getName());
    }

    public String toJson(SimpleType<?> type) throws IOException {
        StringWriter sw = new StringWriter();
        JsonGenerator jg = this.jsonFactory.createJsonGenerator((Writer)sw);
        jg.writeStartObject();
        jg.writeStringField("class", type.getClass().getName());
        jg.writeStringField("className", type.getClassName());
        jg.writeStringField("typeName", type.getTypeName());
        jg.writeStringField("description", type.getDescription());
        jg.writeEndObject();
        jg.flush();
        return sw.toString();
    }

    public String toJson(CompositeType type) throws IOException {
        StringWriter sw = new StringWriter();
        JsonGenerator jg = this.jsonFactory.createJsonGenerator((Writer)sw);
        jg.writeStartObject();
        jg.writeStringField("class", type.getClass().getName());
        jg.writeStringField("className", type.getClassName());
        jg.writeStringField("typeName", type.getTypeName());
        jg.writeStringField("description", type.getDescription());
        jg.writeArrayFieldStart("keys");
        for (String key : type.keySet()) {
            jg.writeStartObject();
            jg.writeStringField("key", key);
            jg.writeStringField("description", type.getDescription(key));
            jg.writeFieldName("type");
            jg.writeRawValue(this.toJson(type.getType(key)));
            jg.writeEndObject();
        }
        jg.writeEndArray();
        jg.writeEndObject();
        jg.flush();
        return sw.toString();
    }

    public String toJson(ArrayType<?> type) throws IOException {
        StringWriter sw = new StringWriter();
        JsonGenerator jg = this.jsonFactory.createJsonGenerator((Writer)sw);
        jg.writeStartObject();
        jg.writeStringField("class", type.getClass().getName());
        jg.writeBooleanField("array", type.isArray());
        jg.writeNumberField("dimension", type.getDimension());
        jg.writeStringField("className", type.getClassName());
        jg.writeStringField("typeName", type.getTypeName());
        jg.writeStringField("description", type.getDescription());
        jg.writeFieldName("elementOpenType");
        jg.writeRawValue(this.toJson(type.getElementOpenType()));
        jg.writeEndObject();
        jg.flush();
        return sw.toString();
    }

    public String toJson(TabularType type) throws IOException {
        StringWriter sw = new StringWriter();
        JsonGenerator jg = this.jsonFactory.createJsonGenerator((Writer)sw);
        jg.writeStartObject();
        jg.writeStringField("class", type.getClass().getName());
        jg.writeStringField("className", type.getClassName());
        jg.writeStringField("typeName", type.getTypeName());
        jg.writeStringField("description", type.getDescription());
        jg.writeArrayFieldStart("indexNames");
        for (String name : type.getIndexNames()) {
            jg.writeString(name);
        }
        jg.writeEndArray();
        jg.writeFieldName("rowType");
        jg.writeRawValue(this.toJson(type.getRowType()));
        jg.writeEndObject();
        jg.flush();
        return sw.toString();
    }
}

