/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.editors;

import com.adobe.granite.jmx.internal.Utils;
import com.adobe.granite.jmx.internal.editors.AbstractJsonEditor;
import com.adobe.granite.jmx.internal.editors.PropertyEditorFinder;
import java.beans.PropertyEditor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenType;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayEditor
extends AbstractJsonEditor {
    private static final Logger log = LoggerFactory.getLogger(ArrayEditor.class);
    private JsonFactory jsonFactory = new JsonFactory();
    private PropertyEditorFinder finder;
    private ArrayType<?> arrayType;

    public ArrayEditor(PropertyEditorFinder finder, ArrayType<?> arrayType) {
        this.finder = finder;
        this.arrayType = arrayType;
    }

    @Override
    public String getAsText() {
        int length = Array.getLength(this.getValue());
        int dim = Utils.getArrayDim(this.getValue().getClass());
        if (dim > 1) {
            return StringEscapeUtils.escapeHtml4((String)ArrayUtils.toString((Object)this.getValue(), (String)"<null>"));
        }
        Class<?> itemClass = Utils.getArrayType(this.getValue().getClass());
        PropertyEditor editor = this.finder.find(itemClass, this.arrayType.getElementOpenType());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<ol>");
        for (int i = 0; i < length; ++i) {
            Object o = Array.get(this.getValue(), i);
            pw.print("<li>");
            editor.setValue(o);
            pw.print(editor.getAsText());
            pw.println("</li>");
        }
        pw.println("</ol>");
        return sw.toString();
    }

    @Override
    public void setAsText(String text) {
        try {
            JsonParser jp = this.jsonFactory.createJsonParser(text);
            ArrayList<Object> list = new ArrayList<Object>();
            jp.nextToken();
            while (jp.nextValue() != null) {
                if (jp.getCurrentToken().equals((Object)JsonToken.END_ARRAY)) continue;
                String raw = this.getString(jp);
                log.debug("current name: {}", (Object)jp.getCurrentName());
                log.debug("value: {}", (Object)raw);
                OpenType<?> type = this.arrayType.getElementOpenType();
                PropertyEditor editor = this.finder.find(type.getClassName(), type);
                editor.setAsText(raw);
                list.add(editor.getValue());
            }
            Object array = Array.newInstance(this.finder.loadClass(this.arrayType.getElementOpenType().getClassName()), list.size());
            int i = 0;
            for (Object e : list) {
                Array.set(array, i, e);
                ++i;
            }
            this.setValue(array);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

