/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.editors;

import com.adobe.granite.jmx.internal.editors.AbstractJsonEditor;
import com.adobe.granite.jmx.internal.editors.PropertyEditorFinder;
import java.beans.PropertyEditor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeDataEditor
extends AbstractJsonEditor {
    private static final Logger log = LoggerFactory.getLogger(CompositeDataEditor.class);
    private PropertyEditorFinder finder;
    private CompositeType compositeType;

    public CompositeDataEditor(PropertyEditorFinder finder, CompositeType compositeType) {
        this.finder = finder;
        this.compositeType = compositeType;
    }

    public String getAsText() {
        if (!(this.getValue() instanceof CompositeData)) {
            throw new IllegalArgumentException("Value is not a CompositeData");
        }
        CompositeData data = (CompositeData)this.getValue();
        CompositeType t = data.getCompositeType();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<table>");
        pw.println("<caption>" + t.getTypeName() + "</caption>");
        pw.println("<tbody>");
        for (String key : t.keySet()) {
            OpenType<?> type = t.getType(key);
            Object itemValue = data.get(key);
            pw.println("<tr>");
            pw.print("<td>");
            pw.print(key);
            pw.println("</td>");
            pw.print("<td>");
            PropertyEditor editor = this.finder.find(type.getClassName(), type);
            editor.setValue(itemValue);
            pw.print(editor.getAsText());
            pw.println("</td>");
            pw.println("</tr>");
        }
        pw.println("</tbody>");
        pw.println("</table>");
        return sw.toString();
    }

    public void setAsText(String text) {
        try {
            JsonParser jp = this.jsonFactory.createJsonParser(text);
            LinkedHashMap<String, Object> items = new LinkedHashMap<String, Object>();
            jp.nextToken();
            while (jp.nextValue() != null) {
                if (jp.getCurrentToken().equals((Object)JsonToken.END_OBJECT)) continue;
                String raw = this.getString(jp);
                log.debug("current name: {}", (Object)jp.getCurrentName());
                log.debug("value: {}", (Object)raw);
                OpenType<?> type = this.compositeType.getType(jp.getCurrentName());
                PropertyEditor editor = this.finder.find(type.getClassName(), type);
                editor.setAsText(raw);
                items.put(jp.getCurrentName(), editor.getValue());
            }
            this.setValue(new CompositeDataSupport(this.compositeType, items));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

