/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.editors;

import com.adobe.granite.jmx.internal.editors.ArrayEditor;
import com.adobe.granite.jmx.internal.editors.CompositeDataEditor;
import com.adobe.granite.jmx.internal.editors.DefaultPropertyEditor;
import com.adobe.granite.jmx.internal.editors.TabularDataEditor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyEditorFinder {
    private final PropertyEditor DEFAULT = new DefaultPropertyEditor();

    public PropertyEditor find(Class<?> clazz, OpenType<?> openType) {
        PropertyEditor editor;
        if (openType != null) {
            if (clazz.isArray()) {
                return new ArrayEditor(this, (ArrayType)openType);
            }
            if (CompositeData.class.isAssignableFrom(clazz)) {
                return new CompositeDataEditor(this, (CompositeType)openType);
            }
            if (TabularData.class.isAssignableFrom(clazz)) {
                return new TabularDataEditor(this, (TabularType)openType);
            }
        }
        return (editor = PropertyEditorManager.findEditor(clazz)) != null ? editor : this.DEFAULT;
    }

    public PropertyEditor find(String className, OpenType<?> openType) {
        try {
            return this.find(this.loadClass(className), openType);
        }
        catch (ClassNotFoundException e) {
            return this.DEFAULT;
        }
    }

    public boolean isEditable(String className) {
        try {
            Class<?> clazz = this.loadClass(className);
            PropertyEditor editor = PropertyEditorManager.findEditor(clazz);
            if (editor != null) {
                return true;
            }
            if (clazz.isArray()) {
                return true;
            }
            if (CompositeData.class.isAssignableFrom(clazz)) {
                return true;
            }
            return TabularData.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected abstract Class<?> loadClass(String var1) throws ClassNotFoundException;
}

