/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.openmbean;

import com.adobe.granite.jmx.internal.openmbean.ArrayTypePrinter;
import com.adobe.granite.jmx.internal.openmbean.CompositeTypePrinter;
import com.adobe.granite.jmx.internal.openmbean.DefaultPrinter;
import com.adobe.granite.jmx.internal.openmbean.OpenTypePrinter;
import com.adobe.granite.jmx.internal.openmbean.SimpleTypePrinter;
import com.adobe.granite.jmx.internal.openmbean.TabularTypePrinter;
import java.io.PrintWriter;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenTypePrinterManager {
    private static final OpenTypePrinter SIMPLE_TYPE = new SimpleTypePrinter();
    private static final OpenTypePrinter ARRAY_TYPE = new ArrayTypePrinter();
    private static final OpenTypePrinter COMPOSITE_TYPE = new CompositeTypePrinter();
    private static final OpenTypePrinter TABULAR_TYPE = new TabularTypePrinter();
    private static final OpenTypePrinter DEFAULT = new DefaultPrinter();

    public static OpenTypePrinter get(OpenType<?> type) {
        if (type instanceof SimpleType) {
            return SIMPLE_TYPE;
        }
        if (type instanceof ArrayType) {
            return ARRAY_TYPE;
        }
        if (type instanceof CompositeType) {
            return COMPOSITE_TYPE;
        }
        if (type instanceof TabularType) {
            return TABULAR_TYPE;
        }
        return DEFAULT;
    }

    public static void print(OpenType<?> type, Object value, PrintWriter pw, Bundle bundle) {
        OpenTypePrinterManager.get(type).print(type, value, pw, bundle);
    }
}

