/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.openmbean;

import com.adobe.granite.jmx.internal.openmbean.OpenTypePrinter;
import com.adobe.granite.jmx.internal.openmbean.OpenTypePrinterManager;
import java.io.PrintWriter;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabularTypePrinter
implements OpenTypePrinter {
    @Override
    public void print(OpenType<?> type, Object value, PrintWriter pw, Bundle bundle) {
        TabularType t = (TabularType)type;
        TabularData data = (TabularData)value;
        pw.println("<table>");
        pw.println("<caption>" + t.getDescription() + "</caption>");
        pw.println("<thead><tr>");
        for (String s : t.getRowType().keySet()) {
            pw.print("<td class='ui-widget-header'>");
            pw.print(s);
            pw.println("</td>");
        }
        pw.println("</tr></thead>");
        pw.println("<tbody>");
        for (String o : data.values()) {
            this.print((CompositeData)((Object)o), pw, bundle);
        }
        pw.println("<tbody>");
        pw.println("</table>");
    }

    private void print(CompositeData data, PrintWriter pw, Bundle bundle) {
        CompositeType t = data.getCompositeType();
        pw.println("<tr>");
        for (String key : t.keySet()) {
            OpenType<?> itemType = t.getType(key);
            Object itemValue = data.get(key);
            pw.print("<td>");
            OpenTypePrinterManager.print(itemType, itemValue, pw, bundle);
            pw.println("</td>");
        }
        pw.println("</tr>");
    }
}

