/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.editors;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateEditor
extends PropertyEditorSupport {
    public static final String FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";

    public String getAsText() {
        if (!(this.getValue() instanceof Date)) {
            throw new IllegalArgumentException("Value is not an instance of " + Date.class.getName());
        }
        SimpleDateFormat df = new SimpleDateFormat(FORMAT, Locale.US);
        return df.format(this.getValue());
    }

    public void setAsText(String text) {
        if (text == null || text.trim().length() == 0) {
            throw new IllegalArgumentException("Empty text");
        }
        SimpleDateFormat df = new SimpleDateFormat(FORMAT, Locale.US);
        try {
            this.setValue(df.parse(text.trim()));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

