/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal.editors;

import com.adobe.granite.jmx.internal.editors.PropertyEditorFinder;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularDataEditor
extends PropertyEditorSupport {
    private static final Logger log = LoggerFactory.getLogger(TabularDataEditor.class);
    private JsonFactory jsonFactory = new JsonFactory();
    private PropertyEditorFinder finder;
    private TabularType tabularType;

    public TabularDataEditor(PropertyEditorFinder finder, TabularType tabularType) {
        this.finder = finder;
        this.tabularType = tabularType;
    }

    public String getAsText() {
        if (!(this.getValue() instanceof TabularData)) {
            throw new IllegalArgumentException("Value is not a TabularData");
        }
        TabularData data = (TabularData)this.getValue();
        TabularType t = data.getTabularType();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<table>");
        pw.println("<caption>" + t.getTypeName() + "</caption>");
        pw.println("<thead><tr>");
        for (String s : t.getRowType().keySet()) {
            pw.print("<td class='ui-widget-header'>");
            pw.print((Object)s);
            pw.println("</td>");
        }
        pw.println("</tr></thead>");
        pw.println("<tbody>");
        for (String o : data.values()) {
            this.print((CompositeData)((Object)o), pw);
        }
        pw.println("<tbody>");
        pw.println("</table>");
        return sw.toString();
    }

    private void print(CompositeData data, PrintWriter pw) {
        CompositeType t = data.getCompositeType();
        pw.println("<tr>");
        for (String key1 : t.keySet()) {
            String key = key1.toString();
            OpenType<?> type = t.getType(key);
            Object itemValue = data.get(key);
            pw.print("<td>");
            PropertyEditor editor = this.finder.find(type.getClassName(), type);
            editor.setValue(itemValue);
            pw.print(editor.getAsText());
            pw.println("</td>");
        }
        pw.println("</tr>");
    }

    public void setAsText(String text) {
        try {
            JsonParser jp = this.jsonFactory.createJsonParser(text);
            TabularDataSupport data = new TabularDataSupport(this.tabularType);
            jp.nextToken();
            while (jp.nextValue() != null) {
                if (jp.getCurrentToken().equals((Object)JsonToken.END_ARRAY)) continue;
                String raw = jp.getText();
                if (jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT) || jp.getCurrentToken().equals((Object)JsonToken.START_ARRAY)) {
                    StringWriter sw = new StringWriter();
                    JsonGenerator jg = this.jsonFactory.createJsonGenerator((Writer)sw);
                    jg.copyCurrentStructure(jp);
                    jg.flush();
                    raw = sw.toString();
                }
                log.debug("current name: {}", (Object)jp.getCurrentName());
                log.debug("value: {}", (Object)raw);
                CompositeType type = this.tabularType.getRowType();
                PropertyEditor editor = this.finder.find(type.getClassName(), (OpenType)type);
                editor.setAsText(raw);
                data.put((CompositeData)editor.getValue());
            }
            this.setValue(data);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

