/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal;

import com.adobe.granite.jmx.internal.JMXConsolePlugin;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXConfigurationPrinter
implements ConfigurationPrinter {
    private static final String TITLE = "JMX";
    private MBeanServerConnection server = ManagementFactory.getPlatformMBeanServer();
    private SimpleDateFormat dateFormat = new SimpleDateFormat();

    public String getTitle() {
        return TITLE;
    }

    public void printConfiguration(PrintWriter writer) {
        Set<ObjectName> objectNames = null;
        try {
            objectNames = this.server.queryNames(null, null);
        }
        catch (IOException e) {
            this.handleException(e, "Error in querying MBeans", writer);
            return;
        }
        Set<ObjectName> sortedObjectNames = this.retrieveSortedObjectNames(objectNames);
        try {
            JSONWriter w = new JSONWriter((Writer)writer);
            w.setTidy(true);
            w.object();
            this.writeNumberOfMBeans(sortedObjectNames.size(), w);
            this.writeMBeans(sortedObjectNames, w);
            w.endObject();
        }
        catch (Exception e) {
            this.handleException(e, "Error in generating JSON for MBeans", writer);
            return;
        }
    }

    private void handleException(Exception e, String message, PrintWriter writer) {
        writer.println(message + ": " + e.getMessage());
        e.printStackTrace(writer);
    }

    private Set<ObjectName> retrieveSortedObjectNames(Set<ObjectName> objectNames) {
        TreeSet<ObjectName> sortedObjectNames = new TreeSet<ObjectName>(JMXConsolePlugin.OBJECT_NAME_COMPARATOR);
        for (ObjectName objectName : objectNames) {
            sortedObjectNames.add(objectName);
        }
        return sortedObjectNames;
    }

    private void writeNumberOfMBeans(int numberOfBeans, JSONWriter w) throws JSONException {
        w.key("NumberOfMBeans").value((long)numberOfBeans);
        w.key("Timestamp").value((Object)this.dateFormat.format(new Date()));
    }

    private void writeMBeans(Set<ObjectName> sortedObjectNames, JSONWriter w) throws Exception {
        w.key("MBeans").array();
        for (ObjectName objectName : sortedObjectNames) {
            this.writeSingleMBean(objectName, w);
        }
        w.endArray();
    }

    private void writeSingleMBean(ObjectName objectName, JSONWriter w) throws Exception {
        w.object();
        MBeanInfo mBeanInfo = this.server.getMBeanInfo(objectName);
        this.writeMBeanInfo(objectName, mBeanInfo, w);
        this.writeMBeanAttributes(objectName, mBeanInfo, w);
        w.endObject();
    }

    private void writeMBeanInfo(ObjectName objectName, MBeanInfo mBeanInfo, JSONWriter w) throws JSONException {
        w.key("Info").object();
        w.key("ObjectName").value((Object)objectName.toString());
        w.key("ClassName").value((Object)mBeanInfo.getClassName());
        w.key("Description").value((Object)mBeanInfo.getDescription());
        w.endObject();
    }

    private void writeMBeanAttributes(ObjectName objectName, MBeanInfo mBeanInfo, JSONWriter w) throws JSONException {
        w.key("Attributes").array();
        for (MBeanAttributeInfo attributeInfo : mBeanInfo.getAttributes()) {
            w.object();
            String attributeName = attributeInfo.getName();
            w.key("Name").value((Object)attributeName);
            Object attributeValue = this.readAttributeValue(objectName, attributeName);
            this.writeAttributeValue(attributeValue, w);
            w.key("MBeanAttributeInfo").object();
            w.key("Description").value((Object)attributeInfo.getDescription());
            w.key("Readable").value(attributeInfo.isReadable());
            w.key("Writable").value(attributeInfo.isWritable());
            w.key("Is").value(attributeInfo.isIs());
            w.key("Type").value((Object)attributeInfo.getType());
            w.endObject();
            w.endObject();
        }
        w.endArray();
    }

    private Object readAttributeValue(ObjectName objectName, String attributeName) {
        Object attributeValue = null;
        try {
            attributeValue = this.server.getAttribute(objectName, attributeName);
        }
        catch (Exception ex) {
            attributeValue = ex.getMessage();
        }
        return attributeValue;
    }

    private void writeAttributeValue(Object attributeValue, JSONWriter w) throws JSONException {
        this.writeAttributeValue(attributeValue, w, true);
    }

    private void writeAttributeValue(Object attributeValue, JSONWriter w, boolean writeFieldName) throws JSONException {
        if (writeFieldName) {
            w.key("Value");
        }
        if (attributeValue == null) {
            w.value(null);
        } else if (attributeValue.getClass().isArray()) {
            this.writeArrayAttributeValue(attributeValue, w);
        } else if (attributeValue instanceof TabularData) {
            this.writeTabularAttributeValue((TabularData)attributeValue, w);
        } else if (attributeValue instanceof CompositeData) {
            this.writeCompositeAttributeValue((CompositeData)attributeValue, w);
        } else {
            w.value((Object)attributeValue.toString());
        }
    }

    private void writeArrayAttributeValue(Object arrayValue, JSONWriter w) throws JSONException {
        w.array();
        int length = Array.getLength(arrayValue);
        for (int i = 0; i < length; ++i) {
            Object arrayElement = Array.get(arrayValue, i);
            this.writeAttributeValue(arrayElement, w, false);
        }
        w.endArray();
    }

    private void writeCompositeAttributeValue(CompositeData compositeData, JSONWriter w) throws JSONException {
        w.object();
        CompositeType compositeType = compositeData.getCompositeType();
        w.key("TypeName").value((Object)compositeType.getTypeName());
        w.key("Values");
        this.writeCompositeData(compositeData, w);
        w.endObject();
    }

    private void writeTabularAttributeValue(TabularData tabularData, JSONWriter w) throws JSONException {
        w.object();
        TabularType tabularType = tabularData.getTabularType();
        w.key("TypeName").value((Object)tabularType.getTypeName());
        w.key("Values").array();
        for (Object value : tabularData.values()) {
            this.writeCompositeData((CompositeData)value, w);
        }
        w.endArray();
        w.endObject();
    }

    private void writeCompositeData(CompositeData compositeData, JSONWriter w) throws JSONException {
        w.object();
        CompositeType compositeType = compositeData.getCompositeType();
        for (String key : compositeType.keySet()) {
            w.key(key.toString());
            Object value = compositeData.get(key.toString());
            this.writeAttributeValue(value, w, false);
        }
        w.endObject();
    }
}

