/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.jmx.internal;

import com.adobe.granite.jmx.internal.JsonOpenType;
import com.adobe.granite.jmx.internal.Utils;
import com.adobe.granite.jmx.internal.editors.Editor;
import com.adobe.granite.jmx.internal.editors.EditorRegistry;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXConsolePlugin
extends AbstractWebConsolePlugin {
    private static final Logger log = LoggerFactory.getLogger(JMXConsolePlugin.class);
    private static final long serialVersionUID = -4544727324932022674L;
    static final String LABEL = "jmx";
    static final String TITLE = "JMX";
    private static final String RESOURCE_PREFIX = "/jmx/";
    private EditorRegistry registry;
    private JsonOpenType jsonOpenType = new JsonOpenType();
    static final Comparator<ObjectName> OBJECT_NAME_COMPARATOR = new Comparator<ObjectName>(){

        @Override
        public int compare(ObjectName paramT1, ObjectName paramObjectName) {
            int j;
            int i = paramT1.getDomain().compareTo(paramObjectName.getDomain());
            if (i != 0) {
                return i;
            }
            String str1 = paramT1.getKeyProperty("type");
            String str2 = paramObjectName.getKeyProperty("type");
            if (str1 == null) {
                str1 = "";
            }
            if (str2 == null) {
                str2 = "";
            }
            if ((j = str1.compareTo(str2)) != 0) {
                return j;
            }
            return paramT1.getCanonicalName().compareTo(paramObjectName.getCanonicalName());
        }
    };

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    public void activate(final ComponentContext ctx) {
        this.registry = new EditorRegistry(){

            @Override
            public Class<?> loadClass(String className) throws ClassNotFoundException {
                return Utils.loadClass(className, ctx.getBundleContext().getBundle());
            }
        };
    }

    public void deactivate() {
        this.registry = null;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Path path = new Path(req);
        if (path.isRoot()) {
            res.sendError(405);
            return;
        }
        if (path.isAttribute()) {
            this.edit(path, req, res);
            return;
        }
        if (path.isOperation()) {
            this.invoke(path, req, res);
            return;
        }
        res.sendError(400);
    }

    private void invoke(Path path, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String oName = path.getObjectName();
        String operationName = path.getOperation();
        String signatureString = path.getSignature();
        String[] signature = signatureString.length() == 0 ? new String[]{} : signatureString.split(",");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        res.setContentType("text/plain;charset=UTF-8");
        PrintWriter writer = res.getWriter();
        try {
            ObjectName objectName = new ObjectName(oName);
            MBeanOperationInfo op = this.findOperation(server.getMBeanInfo(objectName), operationName, signatureString);
            if (op == null) {
                res.sendError(404);
                return;
            }
            Object[] params = new Object[signature.length];
            int i = 0;
            for (MBeanParameterInfo p : op.getSignature()) {
                String value = req.getParameter(p.getName());
                Editor editor = this.registry.find(p);
                params[i] = editor.parse(value);
                ++i;
            }
            Object value = server.invoke(objectName, operationName, params, signature);
            if (value == null) {
                writer.println("(null)");
                return;
            }
            try {
                Editor editor = this.registry.find(op, value);
                writer.println(editor.asHtml(value));
            }
            catch (IllegalArgumentException e) {
                writer.println(value.toString());
            }
        }
        catch (MalformedObjectNameException e) {
            res.sendError(404);
        }
        catch (NullPointerException e) {
            res.sendError(404);
        }
        catch (IntrospectionException e) {
            res.sendError(404);
        }
        catch (InstanceNotFoundException e) {
            res.sendError(404);
        }
        catch (MBeanException e) {
            e.getCause().printStackTrace(writer);
        }
        catch (RuntimeMBeanException e) {
            e.getCause().printStackTrace(writer);
        }
        catch (ReflectionException e) {
            log.error("Error occur invoking: " + oName + "#" + operationName + "(" + signatureString + ")", (Throwable)e);
            res.sendError(500);
        }
    }

    private void edit(Path path, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String oName = path.getObjectName();
        String attributeName = path.getAttribute();
        try {
            ObjectName objectName = new ObjectName(oName);
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            MBeanInfo mbean = server.getMBeanInfo(objectName);
            MBeanAttributeInfo info = this.findAttribute(mbean, attributeName);
            String value = req.getParameter("value");
            Editor editor = this.registry.find(info);
            Attribute attribute = new Attribute(attributeName, editor.parse(value));
            server.setAttribute(objectName, attribute);
        }
        catch (MalformedObjectNameException e) {
            res.sendError(404);
        }
        catch (NullPointerException e) {
            res.sendError(404);
        }
        catch (InstanceNotFoundException e) {
            res.sendError(404);
        }
        catch (IntrospectionException e) {
            res.sendError(404);
        }
        catch (ReflectionException e) {
            log.error("Error occur setting: " + oName + "#" + attributeName, (Throwable)e);
            res.sendError(500);
        }
        catch (AttributeNotFoundException e) {
            res.sendError(404);
        }
        catch (InvalidAttributeValueException e) {
            log.error("Error occur setting: " + oName + "#" + attributeName, (Throwable)e);
            res.sendError(500);
        }
        catch (MBeanException e) {
            log.error("Error occur setting: " + oName + "#" + attributeName, (Throwable)e);
            res.sendError(500);
        }
        catch (RuntimeMBeanException e) {
            log.error("Error occur setting: " + oName + "#" + attributeName, (Throwable)e);
            res.sendError(500);
        }
        catch (IllegalArgumentException e) {
            res.sendError(400);
        }
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Path path = new Path(req);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Output output = new Output(res, path, server);
        if (path.isRoot()) {
            output.printListOfMBeans();
            return;
        }
        if (path.isObject()) {
            try {
                ObjectName objectName = new ObjectName(path.getObjectName());
                MBeanInfo info = server.getMBeanInfo(objectName);
                output.printSingleMBean(objectName, info);
            }
            catch (MalformedObjectNameException e1) {
                res.sendError(404);
            }
            catch (NullPointerException e1) {
                res.sendError(404);
            }
            catch (InstanceNotFoundException e) {
                res.sendError(404);
            }
            catch (IntrospectionException e) {
                res.sendError(404);
            }
            catch (ReflectionException e) {
                res.sendError(500);
            }
            return;
        }
        res.sendError(404);
    }

    protected String[] getCssReferences() {
        return new String[]{"/jmx/res/jmx.css"};
    }

    private URL getResource(String path) {
        return path != null && path.startsWith(RESOURCE_PREFIX) ? ((Object)((Object)this)).getClass().getResource(path.substring(RESOURCE_PREFIX.length() - 1)) : null;
    }

    private MBeanOperationInfo findOperation(MBeanInfo mbean, String operationName, String signatureString) {
        for (MBeanOperationInfo op : mbean.getOperations()) {
            if (!op.getName().equals(operationName)) continue;
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (MBeanParameterInfo p : op.getSignature()) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(p.getType());
                ++i;
            }
            if (!sb.toString().equals(signatureString)) continue;
            return op;
        }
        return null;
    }

    private MBeanAttributeInfo findAttribute(MBeanInfo mbean, String attributeName) {
        for (MBeanAttributeInfo a : mbean.getAttributes()) {
            if (!a.getName().equals(attributeName)) continue;
            return a;
        }
        return null;
    }

    private class Output {
        private final HttpServletResponse response;
        private final Path path;
        private final MBeanServerConnection server;

        public Output(HttpServletResponse response, Path path, MBeanServerConnection server) {
            this.response = response;
            this.path = path;
            this.server = server;
        }

        public void printListOfMBeans() throws IOException {
            PrintWriter writer = this.response.getWriter();
            writer.println("<script>");
            writer.println("$(function() { $('#content table.mbeans').tablesorter(); });");
            writer.println("</script>");
            TreeSet<ObjectName> names = new TreeSet<ObjectName>(OBJECT_NAME_COMPARATOR);
            for (ObjectName name : this.server.queryNames(null, null)) {
                names.add(name);
            }
            writer.print("<p class=\"statline\">");
            writer.print(names.size());
            writer.println(" registered MBeans</p>");
            writer.println("<table class=\"mbeans nicetable\">");
            writer.println("<thead>");
            writer.print("<tr>");
            writer.print("<th class=\"col_domain\">Domain</th>");
            writer.print("<th class=\"col_type\">Type</th>");
            writer.print("<th class=\"col_name\">Name</th>");
            writer.print("<th class=\"col_props\">Properties</th>");
            writer.println("</tr>");
            writer.println("</thead>");
            writer.println("<tbody>");
            for (ObjectName name : names) {
                TreeMap<String, String> props = new TreeMap<String, String>(name.getKeyPropertyList());
                writer.print("<tr>");
                this.printObjectNameColumn(writer, name, name.getDomain());
                this.printObjectNameColumn(writer, name, props.remove("type"));
                this.printObjectNameColumn(writer, name, props.remove("name"));
                this.printObjectNameColumn(writer, name, props);
                writer.println("</tr>");
            }
            writer.println("</tbody>");
            writer.println("</table>");
        }

        private void printObjectNameColumn(PrintWriter writer, ObjectName name, Object object) {
            String text;
            writer.print("<td>");
            if (object != null && (text = object.toString().trim()).length() > 0 && !"{}".equals(text)) {
                String href = this.path.createObject(name.getCanonicalName());
                writer.print("<a href='");
                writer.print(StringEscapeUtils.escapeHtml4((String)href));
                writer.print("'>");
                writer.print(StringEscapeUtils.escapeHtml4((String)text));
                writer.print("</a>");
            }
            writer.print("</td>");
        }

        public void printSingleMBean(ObjectName name, MBeanInfo info) throws IOException {
            Object t;
            PrintWriter writer = this.response.getWriter();
            writer.print("<script src='");
            writer.print(this.path.createSub("/res/json2.js"));
            writer.println("'></script>");
            writer.print("<script src='");
            writer.print(this.path.createSub("/res/jmx.js"));
            writer.println("'></script>");
            TreeMap<String, String> props = new TreeMap<String, String>(name.getKeyPropertyList());
            writer.print("<h2>");
            writer.print(StringEscapeUtils.escapeHtml4((String)name.getDomain()));
            Object n = props.remove("name");
            if (n == null) {
                n = props.remove("id");
            }
            if (n != null) {
                writer.print(": ");
                writer.print(StringEscapeUtils.escapeHtml4((String)n.toString()));
            }
            if ((t = props.remove("type")) != null) {
                writer.print(" (");
                writer.print(StringEscapeUtils.escapeHtml4((String)t.toString()));
                writer.print(")");
            }
            writer.println("</h2>");
            writer.print("<p>");
            writer.print(StringEscapeUtils.escapeHtml4((String)info.getDescription()));
            writer.println("</p>");
            if (!props.isEmpty()) {
                writer.print("<ul>");
                for (Object key : props.keySet()) {
                    writer.print("<li>");
                    writer.print(StringEscapeUtils.escapeHtml4((String)key.toString()));
                    writer.print(" = ");
                    writer.print(StringEscapeUtils.escapeHtml4((String)props.get(key).toString()));
                    writer.println("</li>");
                }
                writer.println("</ul>");
            }
            writer.println("<table class=\"attributes nicetable\">");
            writer.println("<caption>Attributes</caption>");
            writer.println("<thead>");
            writer.print("<tr>");
            writer.print("<th class=\"col_Name\">Attribute Name</th>");
            writer.print("<th class=\"col_Value\">Attribute Value</th>");
            writer.println("</tr>");
            writer.println("</thead>");
            writer.println("<tbody>");
            for (MBeanAttributeInfo mBeanAttributeInfo : info.getAttributes()) {
                boolean editable;
                writer.print("<tr>");
                writer.print("<td title='");
                writer.print(StringEscapeUtils.escapeHtml4((String)mBeanAttributeInfo.getDescription()));
                writer.print("'>");
                writer.print(StringEscapeUtils.escapeHtml4((String)mBeanAttributeInfo.getName()));
                writer.print("</td>");
                writer.print("<td data-type='");
                writer.print(StringEscapeUtils.escapeHtml4((String)mBeanAttributeInfo.getType()));
                boolean bl = editable = mBeanAttributeInfo.isWritable() && JMXConsolePlugin.this.registry.isEditable(mBeanAttributeInfo);
                if (editable) {
                    writer.print("' class='editable");
                }
                if (mBeanAttributeInfo instanceof OpenMBeanAttributeInfo) {
                    writer.print("' data-opentype='");
                    writer.print(StringEscapeUtils.escapeHtml4((String)JMXConsolePlugin.this.jsonOpenType.toJson(((OpenMBeanAttributeInfo)((Object)mBeanAttributeInfo)).getOpenType())));
                }
                writer.print("'>");
                this.printAttribute(writer, name, mBeanAttributeInfo, editable);
                writer.print("</td>");
                writer.println("</tr>");
            }
            writer.println("</tbody>");
            writer.println("</table>");
            writer.println("<table class=\"operations nicetable\">");
            writer.println("<caption>Operations</caption>");
            writer.println("<thead>");
            writer.print("<tr>");
            writer.print("<th class=\"col_ReturnType\">Return Type</th>");
            writer.print("<th class=\"col_Name\">Name</th>");
            writer.println("</tr>");
            writer.println("</thead>");
            writer.println("<tbody>");
            for (MBeanFeatureInfo mBeanFeatureInfo : info.getOperations()) {
                writer.print("<tr><td class=\"returntype\">");
                writer.print(StringEscapeUtils.escapeHtml4((String)((MBeanOperationInfo)mBeanFeatureInfo).getReturnType()));
                writer.println("</td>");
                writer.print("<td class=\"name\">");
                this.printOperation(writer, name, (MBeanOperationInfo)mBeanFeatureInfo);
                writer.println("</td></tr>");
            }
            writer.println("</tbody>");
            writer.println("</table>");
        }

        public void printAttribute(PrintWriter writer, ObjectName name, MBeanAttributeInfo attribute, boolean editable) {
            String text;
            Editor editor;
            Object value;
            try {
                value = this.server.getAttribute(name, attribute.getName());
                if (value == null) {
                    writer.print("<null>");
                } else {
                    try {
                        editor = JMXConsolePlugin.this.registry.find(attribute, value);
                        text = editor.asHtml(value);
                        writer.print(text);
                    }
                    catch (IllegalArgumentException e) {
                        writer.print(value.toString());
                    }
                }
            }
            catch (MBeanException e) {
                value = null;
                writer.print(e.toString());
            }
            catch (AttributeNotFoundException e) {
                value = null;
                writer.print(e.toString());
            }
            catch (InstanceNotFoundException e) {
                value = null;
                writer.print(e.toString());
            }
            catch (ReflectionException e) {
                value = null;
                writer.print(e.toString());
            }
            catch (IOException e) {
                value = null;
                writer.print(e.toString());
            }
            if (editable) {
                writer.print("<form method='POST' action='");
                writer.print(this.path.createAttribute(name.getCanonicalName(), attribute.getName()));
                writer.println("'>");
                writer.print("<p class='input'>");
                writer.print(StringEscapeUtils.escapeHtml4((String)attribute.getType()));
                writer.print(" <label>");
                writer.print("<input name='value' type='text' value='");
                if (value != null) {
                    editor = JMXConsolePlugin.this.registry.find(attribute, value);
                    text = ((Object)editor.asJsonValue(value)).toString();
                    writer.print(StringEscapeUtils.escapeHtml4((String)text));
                }
                writer.print("' />");
                writer.println("</label></p>");
                writer.print("<p class='desc'>");
                writer.print(StringEscapeUtils.escapeHtml4((String)attribute.getDescription()));
                writer.println("</p>");
                writer.println("<input type='submit' value='Save' />");
                writer.println("</form>");
            }
        }

        private void printOperation(PrintWriter writer, ObjectName name, MBeanOperationInfo operation) throws IOException {
            int i = 0;
            StringBuilder sb = new StringBuilder();
            String[] signature = new String[operation.getSignature().length];
            Object[] signature2 = new String[operation.getSignature().length];
            boolean editable = true;
            for (MBeanParameterInfo p : operation.getSignature()) {
                signature[i] = p.getType();
                signature2[i] = p.getType() + " " + p.getName();
                if (!JMXConsolePlugin.this.registry.isEditable(p)) {
                    editable = false;
                }
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("<span class='param'>");
                sb.append("<span class='type'>");
                sb.append(StringEscapeUtils.escapeHtml4((String)p.getType()));
                sb.append("</span>");
                sb.append(" <span class='name' title='");
                sb.append(StringEscapeUtils.escapeHtml4((String)p.getDescription()));
                sb.append("'>");
                sb.append(StringEscapeUtils.escapeHtml4((String)p.getName()));
                sb.append("</span>");
                sb.append("</span>");
                ++i;
            }
            writer.print("<h4 class='");
            writer.print(editable ? "editable" : "");
            writer.print("'><span class='name'>");
            writer.print(StringEscapeUtils.escapeHtml4((String)operation.getName()));
            writer.print("</span>(");
            writer.print(sb);
            writer.println(")</h4>");
            writer.print("<p class='desc'>");
            writer.print(StringEscapeUtils.escapeHtml4((String)operation.getDescription()));
            writer.println("</p>");
            if (editable) {
                writer.println("<div class='dialog'>");
                writer.print("<h4>");
                writer.print(StringEscapeUtils.escapeHtml4((String)operation.getReturnType()));
                writer.print(" ");
                writer.print(StringEscapeUtils.escapeHtml4((String)operation.getName()));
                writer.print("(");
                writer.print(StringEscapeUtils.escapeHtml4((String)StringUtils.join((Object[])signature2, (String)", ")));
                writer.println(")</h4>");
                writer.print("<p class='desc'>");
                writer.print(StringEscapeUtils.escapeHtml4((String)operation.getDescription()));
                writer.println("</p>");
                writer.print("<form method='POST' action='");
                writer.print(this.path.createOperation(name.getCanonicalName(), operation.getName(), signature));
                writer.println("'>");
                writer.println("<ol>");
                for (MBeanParameterInfo p : operation.getSignature()) {
                    writer.print("<li class='input'><label>");
                    writer.print(StringEscapeUtils.escapeHtml4((String)(p.getType() + " " + p.getName())));
                    writer.print(" <input type='text' name='");
                    writer.print(StringEscapeUtils.escapeHtml4((String)p.getName()));
                    if (p instanceof OpenMBeanParameterInfo) {
                        writer.print("' data-opentype='");
                        writer.print(StringEscapeUtils.escapeHtml4((String)JMXConsolePlugin.this.jsonOpenType.toJson(((OpenMBeanParameterInfo)((Object)p)).getOpenType())));
                    }
                    writer.print("' />");
                    writer.print("</label><p class='desc'>");
                    writer.print(StringEscapeUtils.escapeHtml4((String)p.getDescription()));
                    writer.println("</p></li>");
                }
                writer.println("</ol>");
                writer.println("<input type='submit' value='Invoke' />");
                writer.println("</form>");
                writer.println("<pre class='output'></pre>");
                writer.println("</div>");
            }
        }
    }

    private class Path {
        private String root;
        private String[] elements;

        public Path(HttpServletRequest req) throws ServletException {
            Object rawRoot = req.getAttribute("felix.webconsole.pluginRoot");
            if (!(rawRoot instanceof String)) {
                throw new ServletException("Illegal attr: felix.webconsole.pluginRoot");
            }
            this.root = rawRoot.toString();
            String pathInfo = req.getRequestURI().substring(this.root.length());
            this.elements = pathInfo.split("/");
        }

        public boolean isRoot() {
            return this.elements.length == 1;
        }

        public boolean isObject() {
            return this.elements.length == 2;
        }

        public boolean isAttribute() {
            return this.elements.length == 4 && "a".equals(this.elements[2]);
        }

        public boolean isOperation() {
            return (this.elements.length == 4 || this.elements.length == 5) && "op".equals(this.elements[2]);
        }

        public String getRoot() {
            return this.root;
        }

        public String getObjectName() {
            return this.elements.length < 2 ? null : this.decodeUriComponent(this.elements[1]);
        }

        public String getAttribute() {
            return this.elements.length < 4 ? null : this.decodeUriComponent(this.elements[3]);
        }

        public String getOperation() {
            return this.elements.length < 4 ? null : this.decodeUriComponent(this.elements[3]);
        }

        public String getSignature() {
            if (this.elements.length == 4) {
                return "";
            }
            return this.elements.length < 5 ? null : this.decodeUriComponent(this.elements[4]);
        }

        public String createObject(String name) {
            return this.createSub("/" + this.encodeUriComponent(name));
        }

        public String createAttribute(String objectName, String name) {
            return this.createObject(objectName) + "/a/" + this.encodeUriComponent(name);
        }

        public String createOperation(String objectName, String name, String[] signature) {
            return this.createObject(objectName) + "/op/" + this.encodeUriComponent(name) + "/" + this.encodeUriComponent(StringUtils.join((Object[])signature, (char)','));
        }

        public String createSub(String path) {
            return this.getRoot() + path;
        }

        private String encodeUriComponent(String s) {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        private String decodeUriComponent(String s) {
            try {
                return URLDecoder.decode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

